/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.region;

import com.huaweicloud.sdk.core.region.EnvRegionCache;
import com.huaweicloud.sdk.core.region.IRegionProvider;
import com.huaweicloud.sdk.core.region.Region;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.util.Locale;
import java.util.Objects;

public class EnvRegionProvider
implements IRegionProvider {
    private static final String ENV_REGION_PREFIX = "HUAWEICLOUD_SDK_REGION";
    private final String serviceName;

    public EnvRegionProvider(String serviceName) {
        this.serviceName = serviceName.toUpperCase(Locale.ROOT);
    }

    @Override
    public Region getRegion(String regionId) {
        Region region = EnvRegionCache.getInstance().value.get(this.serviceName + regionId);
        if (Objects.nonNull(region)) {
            return region;
        }
        String envName = String.format("%s_%s_%s", ENV_REGION_PREFIX, this.serviceName, regionId.replaceAll("-", "_").toUpperCase(Locale.ROOT));
        String endpoint = System.getenv(envName);
        if (StringUtils.isEmpty(endpoint)) {
            return null;
        }
        region = new Region(regionId, endpoint);
        EnvRegionCache.getInstance().value.put(this.serviceName + regionId, region);
        return region;
    }
}

