/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class Dot11FrameType
extends NamedNumber<Byte, Dot11FrameType> {
    private static final long serialVersionUID = 863329177944877431L;
    public static final Dot11FrameType ASSOCIATION_REQUEST = new Dot11FrameType((byte)0, "Association request");
    public static final Dot11FrameType ASSOCIATION_RESPONSE = new Dot11FrameType((byte)1, "Association response");
    public static final Dot11FrameType REASSOCIATION_REQUEST = new Dot11FrameType((byte)2, "Reassociation request");
    public static final Dot11FrameType REASSOCIATION_RESPONSE = new Dot11FrameType((byte)3, "Reassociation response");
    public static final Dot11FrameType PROBE_REQUEST = new Dot11FrameType((byte)4, "Probe request");
    public static final Dot11FrameType PROBE_RESPONSE = new Dot11FrameType((byte)5, "Probe response");
    public static final Dot11FrameType TIMING_ADVERTISEMENT = new Dot11FrameType((byte)6, "Timing Advertisement");
    public static final Dot11FrameType BEACON = new Dot11FrameType((byte)8, "Beacon");
    public static final Dot11FrameType ATIM = new Dot11FrameType((byte)9, "ATIM");
    public static final Dot11FrameType DISASSOCIATION = new Dot11FrameType((byte)10, "Disassociation");
    public static final Dot11FrameType AUTHENTICATION = new Dot11FrameType((byte)11, "Authentication");
    public static final Dot11FrameType DEAUTHENTICATION = new Dot11FrameType((byte)12, "Deauthentication");
    public static final Dot11FrameType ACTION = new Dot11FrameType((byte)13, "Action");
    public static final Dot11FrameType ACTION_NO_ACK = new Dot11FrameType((byte)14, "Action No Ack");
    public static final Dot11FrameType CONTROL_WRAPPER = new Dot11FrameType((byte)23, "Control Wrapper");
    public static final Dot11FrameType BLOCK_ACK_REQUEST = new Dot11FrameType((byte)24, "Block Ack Request");
    public static final Dot11FrameType BLOCK_ACK = new Dot11FrameType((byte)25, "Block Ack");
    public static final Dot11FrameType PS_POLL = new Dot11FrameType((byte)26, "PS-Poll");
    public static final Dot11FrameType RTS = new Dot11FrameType((byte)27, "RTS");
    public static final Dot11FrameType CTS = new Dot11FrameType((byte)28, "CTS");
    public static final Dot11FrameType ACK = new Dot11FrameType((byte)29, "ACK");
    public static final Dot11FrameType CF_END = new Dot11FrameType((byte)30, "CF-End");
    public static final Dot11FrameType CF_END_CF_ACK = new Dot11FrameType((byte)31, "CF-End + CF-Ack");
    public static final Dot11FrameType DATA = new Dot11FrameType((byte)32, "Data");
    public static final Dot11FrameType DATA_CF_ACK = new Dot11FrameType((byte)33, "Data + CF-Ack");
    public static final Dot11FrameType DATA_CF_POLL = new Dot11FrameType((byte)34, "Data + CF-Poll");
    public static final Dot11FrameType DATA_CF_ACK_CF_POLL = new Dot11FrameType((byte)35, "Data + CF-Ack + CF-Poll");
    public static final Dot11FrameType NULL = new Dot11FrameType((byte)36, "Null");
    public static final Dot11FrameType CF_ACK = new Dot11FrameType((byte)37, "CF-Ack");
    public static final Dot11FrameType CF_POLL = new Dot11FrameType((byte)38, "CF-Poll");
    public static final Dot11FrameType CF_ACK_CF_POLL = new Dot11FrameType((byte)39, "CF-Ack + CF-Poll");
    public static final Dot11FrameType QOS_DATA = new Dot11FrameType((byte)40, "QoS Data");
    public static final Dot11FrameType QOS_DATA_CF_ACK = new Dot11FrameType((byte)41, "QoS Data + CF-Ack");
    public static final Dot11FrameType QOS_DATA_CF_POLL = new Dot11FrameType((byte)42, "QoS Data + CF-Poll");
    public static final Dot11FrameType QOS_DATA_CF_ACK_CF_POLL = new Dot11FrameType((byte)43, "QoS Data + CF-Ack + CF-Poll");
    public static final Dot11FrameType QOS_NULL = new Dot11FrameType((byte)44, "QoS Null");
    public static final Dot11FrameType QOS_CF_POLL = new Dot11FrameType((byte)46, "QoS CF-Poll");
    public static final Dot11FrameType QOS_CF_ACK_CF_POLL = new Dot11FrameType((byte)47, "QoS CF-Ack + CF-Poll");
    private static final Map<Byte, Dot11FrameType> registry = new HashMap<Byte, Dot11FrameType>();
    private final Type type;

    public Dot11FrameType(Byte value, String name) {
        super(value, name);
        if ((value & 0xC0) != 0) {
            throw new IllegalArgumentException(value + " is invalid value. (value & 0xC0) must be 0.");
        }
        switch (value >> 4) {
            case 0: {
                this.type = Type.MANAGEMENT;
                break;
            }
            case 1: {
                this.type = Type.CONTROL;
                break;
            }
            case 2: {
                this.type = Type.DATA;
                break;
            }
            case 3: {
                this.type = Type.RESERVED;
                break;
            }
            default: {
                throw new AssertionError((Object)"Never get here.");
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    public static Dot11FrameType getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new Dot11FrameType(value, "unknown");
    }

    public static Dot11FrameType register(Dot11FrameType number) {
        return registry.put((Byte)number.value(), number);
    }

    @Override
    public int compareTo(Dot11FrameType o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    static {
        registry.put((Byte)ASSOCIATION_REQUEST.value(), ASSOCIATION_REQUEST);
        registry.put((Byte)ASSOCIATION_RESPONSE.value(), ASSOCIATION_RESPONSE);
        registry.put((Byte)REASSOCIATION_REQUEST.value(), REASSOCIATION_REQUEST);
        registry.put((Byte)REASSOCIATION_RESPONSE.value(), REASSOCIATION_RESPONSE);
        registry.put((Byte)PROBE_REQUEST.value(), PROBE_REQUEST);
        registry.put((Byte)PROBE_RESPONSE.value(), PROBE_RESPONSE);
        registry.put((Byte)TIMING_ADVERTISEMENT.value(), TIMING_ADVERTISEMENT);
        registry.put((Byte)BEACON.value(), BEACON);
        registry.put((Byte)ATIM.value(), ATIM);
        registry.put((Byte)DISASSOCIATION.value(), DISASSOCIATION);
        registry.put((Byte)AUTHENTICATION.value(), AUTHENTICATION);
        registry.put((Byte)DEAUTHENTICATION.value(), DEAUTHENTICATION);
        registry.put((Byte)ACTION.value(), ACTION);
        registry.put((Byte)ACTION_NO_ACK.value(), ACTION_NO_ACK);
        registry.put((Byte)CONTROL_WRAPPER.value(), CONTROL_WRAPPER);
        registry.put((Byte)BLOCK_ACK_REQUEST.value(), BLOCK_ACK_REQUEST);
        registry.put((Byte)BLOCK_ACK.value(), BLOCK_ACK);
        registry.put((Byte)PS_POLL.value(), PS_POLL);
        registry.put((Byte)RTS.value(), RTS);
        registry.put((Byte)CTS.value(), CTS);
        registry.put((Byte)ACK.value(), ACK);
        registry.put((Byte)CF_END.value(), CF_END);
        registry.put((Byte)CF_END_CF_ACK.value(), CF_END_CF_ACK);
        registry.put((Byte)DATA.value(), DATA);
        registry.put((Byte)DATA_CF_ACK.value(), DATA_CF_ACK);
        registry.put((Byte)DATA_CF_POLL.value(), DATA_CF_POLL);
        registry.put((Byte)DATA_CF_ACK_CF_POLL.value(), DATA_CF_ACK_CF_POLL);
        registry.put((Byte)NULL.value(), NULL);
        registry.put((Byte)CF_ACK.value(), CF_ACK);
        registry.put((Byte)CF_POLL.value(), CF_POLL);
        registry.put((Byte)CF_ACK_CF_POLL.value(), CF_ACK_CF_POLL);
        registry.put((Byte)QOS_DATA.value(), QOS_DATA);
        registry.put((Byte)QOS_DATA_CF_ACK.value(), QOS_DATA_CF_ACK);
        registry.put((Byte)QOS_DATA_CF_POLL.value(), QOS_DATA_CF_POLL);
        registry.put((Byte)QOS_DATA_CF_ACK_CF_POLL.value(), QOS_DATA_CF_ACK_CF_POLL);
        registry.put((Byte)QOS_NULL.value(), QOS_NULL);
        registry.put((Byte)QOS_CF_POLL.value(), QOS_CF_POLL);
        registry.put((Byte)QOS_CF_ACK_CF_POLL.value(), QOS_CF_ACK_CF_POLL);
    }

    public static enum Type {
        MANAGEMENT(0),
        CONTROL(1),
        DATA(2),
        RESERVED(3);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

