/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.entity;

import cn.afterturn.easypoi.excel.entity.ExcelBaseParams;
import cn.afterturn.easypoi.excel.export.styler.ExcelExportStylerDefaultImpl;
import java.util.Arrays;
import org.apache.poi.ss.usermodel.Workbook;

public class TemplateExportParams
extends ExcelBaseParams {
    private boolean scanAllsheet = false;
    private String templateUrl;
    private Workbook templateWb;
    private Integer[] sheetNum = new Integer[]{0};
    private String[] sheetName;
    private int headingRows = 1;
    private int headingStartRow = 1;
    private int dataSheetNum = 0;
    private Class<?> style = ExcelExportStylerDefaultImpl.class;
    private String tempParams = "t";
    private boolean colForEach = false;
    private boolean readonly = false;

    public TemplateExportParams() {
    }

    public TemplateExportParams(String templateUrl, boolean scanAllsheet, String ... sheetName) {
        this.templateUrl = templateUrl;
        this.scanAllsheet = scanAllsheet;
        if (sheetName != null && sheetName.length > 0) {
            this.sheetName = sheetName;
        }
    }

    public TemplateExportParams(String templateUrl, Integer ... sheetNum) {
        this.templateUrl = templateUrl;
        if (sheetNum != null && sheetNum.length > 0) {
            this.sheetNum = sheetNum;
        }
    }

    public TemplateExportParams(String templateUrl, String sheetName, Integer ... sheetNum) {
        this.templateUrl = templateUrl;
        this.sheetName = new String[]{sheetName};
        if (sheetNum != null && sheetNum.length > 0) {
            this.sheetNum = sheetNum;
        }
    }

    public boolean isScanAllsheet() {
        return this.scanAllsheet;
    }

    public String getTemplateUrl() {
        return this.templateUrl;
    }

    public Workbook getTemplateWb() {
        return this.templateWb;
    }

    public Integer[] getSheetNum() {
        return this.sheetNum;
    }

    public String[] getSheetName() {
        return this.sheetName;
    }

    public int getHeadingRows() {
        return this.headingRows;
    }

    public int getHeadingStartRow() {
        return this.headingStartRow;
    }

    public int getDataSheetNum() {
        return this.dataSheetNum;
    }

    public Class<?> getStyle() {
        return this.style;
    }

    public String getTempParams() {
        return this.tempParams;
    }

    public boolean isColForEach() {
        return this.colForEach;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setScanAllsheet(boolean scanAllsheet) {
        this.scanAllsheet = scanAllsheet;
    }

    public void setTemplateUrl(String templateUrl) {
        this.templateUrl = templateUrl;
    }

    public void setTemplateWb(Workbook templateWb) {
        this.templateWb = templateWb;
    }

    public void setSheetNum(Integer[] sheetNum) {
        this.sheetNum = sheetNum;
    }

    public void setSheetName(String[] sheetName) {
        this.sheetName = sheetName;
    }

    public void setHeadingRows(int headingRows) {
        this.headingRows = headingRows;
    }

    public void setHeadingStartRow(int headingStartRow) {
        this.headingStartRow = headingStartRow;
    }

    public void setDataSheetNum(int dataSheetNum) {
        this.dataSheetNum = dataSheetNum;
    }

    public void setStyle(Class<?> style) {
        this.style = style;
    }

    public void setTempParams(String tempParams) {
        this.tempParams = tempParams;
    }

    public void setColForEach(boolean colForEach) {
        this.colForEach = colForEach;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateExportParams)) {
            return false;
        }
        TemplateExportParams other = (TemplateExportParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isScanAllsheet() != other.isScanAllsheet()) {
            return false;
        }
        String this$templateUrl = this.getTemplateUrl();
        String other$templateUrl = other.getTemplateUrl();
        if (this$templateUrl == null ? other$templateUrl != null : !this$templateUrl.equals(other$templateUrl)) {
            return false;
        }
        Workbook this$templateWb = this.getTemplateWb();
        Workbook other$templateWb = other.getTemplateWb();
        if (this$templateWb == null ? other$templateWb != null : !this$templateWb.equals(other$templateWb)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSheetNum(), other.getSheetNum())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSheetName(), other.getSheetName())) {
            return false;
        }
        if (this.getHeadingRows() != other.getHeadingRows()) {
            return false;
        }
        if (this.getHeadingStartRow() != other.getHeadingStartRow()) {
            return false;
        }
        if (this.getDataSheetNum() != other.getDataSheetNum()) {
            return false;
        }
        Class<?> this$style = this.getStyle();
        Class<?> other$style = other.getStyle();
        if (this$style == null ? other$style != null : !this$style.equals(other$style)) {
            return false;
        }
        String this$tempParams = this.getTempParams();
        String other$tempParams = other.getTempParams();
        if (this$tempParams == null ? other$tempParams != null : !this$tempParams.equals(other$tempParams)) {
            return false;
        }
        if (this.isColForEach() != other.isColForEach()) {
            return false;
        }
        return this.isReadonly() == other.isReadonly();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TemplateExportParams;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isScanAllsheet() ? 79 : 97);
        String $templateUrl = this.getTemplateUrl();
        result = result * 59 + ($templateUrl == null ? 43 : $templateUrl.hashCode());
        Workbook $templateWb = this.getTemplateWb();
        result = result * 59 + ($templateWb == null ? 43 : $templateWb.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSheetNum());
        result = result * 59 + Arrays.deepHashCode(this.getSheetName());
        result = result * 59 + this.getHeadingRows();
        result = result * 59 + this.getHeadingStartRow();
        result = result * 59 + this.getDataSheetNum();
        Class<?> $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        String $tempParams = this.getTempParams();
        result = result * 59 + ($tempParams == null ? 43 : $tempParams.hashCode());
        result = result * 59 + (this.isColForEach() ? 79 : 97);
        result = result * 59 + (this.isReadonly() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "TemplateExportParams(scanAllsheet=" + this.isScanAllsheet() + ", templateUrl=" + this.getTemplateUrl() + ", templateWb=" + this.getTemplateWb() + ", sheetNum=" + Arrays.deepToString(this.getSheetNum()) + ", sheetName=" + Arrays.deepToString(this.getSheetName()) + ", headingRows=" + this.getHeadingRows() + ", headingStartRow=" + this.getHeadingStartRow() + ", dataSheetNum=" + this.getDataSheetNum() + ", style=" + this.getStyle() + ", tempParams=" + this.getTempParams() + ", colForEach=" + this.isColForEach() + ", readonly=" + this.isReadonly() + ")";
    }
}

