/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public final class TimeZoneUtil {
    private static final Integer LANG_REGION_LENGTH = 2;

    private TimeZoneUtil() {
    }

    public static void setTimeZoneAndLocale(String timeZoneId, String locale) {
        TimeZoneUtil.setTimeZone(timeZoneId);
        TimeZoneUtil.setLocale(locale);
    }

    public static void setTimeZone(String timeZoneId) {
        if (StringUtils.isBlank((CharSequence)timeZoneId)) {
            return;
        }
        TimeZone.setDefault(TimeZone.getTimeZone(timeZoneId));
    }

    public static void setLocale(String locale) {
        if (StringUtils.isBlank((CharSequence)locale)) {
            return;
        }
        String[] arr = locale.split("_");
        if (arr.length == LANG_REGION_LENGTH) {
            String language = arr[0];
            String country = arr[1];
            Locale.setDefault(new Locale(language, country));
        }
    }
}

