/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import com.google.protobuf.UnsafeByteOperations;
import io.greptime.models.ValueUtil;
import io.greptime.v1.Common;
import io.greptime.v1.RowData;

public final class RowHelper {
    public static void addValue(RowData.Row.Builder builder, Common.ColumnDataType dataType, Common.ColumnDataTypeExtension dataTypeExtension, Object value) {
        RowData.Value.Builder valueBuilder = RowData.Value.newBuilder();
        if (value == null) {
            builder.addValues(valueBuilder.build());
            return;
        }
        switch (dataType) {
            case INT8: {
                valueBuilder.setI8Value(((Integer)value).intValue());
                break;
            }
            case INT16: {
                valueBuilder.setI16Value(((Integer)value).intValue());
                break;
            }
            case INT32: {
                valueBuilder.setI32Value(((Integer)value).intValue());
                break;
            }
            case INT64: {
                valueBuilder.setI64Value(ValueUtil.getLongValue(value));
                break;
            }
            case UINT8: {
                valueBuilder.setU8Value(((Integer)value).intValue());
                break;
            }
            case UINT16: {
                valueBuilder.setU16Value(((Integer)value).intValue());
                break;
            }
            case UINT32: {
                valueBuilder.setU32Value(((Integer)value).intValue());
                break;
            }
            case UINT64: {
                valueBuilder.setU64Value(ValueUtil.getLongValue(value));
                break;
            }
            case FLOAT32: {
                valueBuilder.setF32Value(((Number)value).floatValue());
                break;
            }
            case FLOAT64: {
                valueBuilder.setF64Value(((Number)value).doubleValue());
                break;
            }
            case BOOLEAN: {
                valueBuilder.setBoolValue(((Boolean)value).booleanValue());
                break;
            }
            case BINARY: {
                valueBuilder.setBinaryValue(UnsafeByteOperations.unsafeWrap((byte[])((byte[])value)));
                break;
            }
            case STRING: {
                valueBuilder.setStringValue((String)value);
                break;
            }
            case DATE: {
                valueBuilder.setDateValue(ValueUtil.getDateValue(value));
                break;
            }
            case DATETIME: {
                valueBuilder.setDatetimeValue(ValueUtil.getDateTimeValue(value));
                break;
            }
            case TIMESTAMP_SECOND: {
                valueBuilder.setTimestampSecondValue(ValueUtil.getLongValue(value));
                break;
            }
            case TIMESTAMP_MILLISECOND: {
                valueBuilder.setTimestampMillisecondValue(ValueUtil.getLongValue(value));
                break;
            }
            case TIMESTAMP_MICROSECOND: {
                valueBuilder.setTimestampMicrosecondValue(ValueUtil.getLongValue(value));
                break;
            }
            case TIMESTAMP_NANOSECOND: {
                valueBuilder.setTimestampNanosecondValue(ValueUtil.getLongValue(value));
                break;
            }
            case TIME_SECOND: {
                valueBuilder.setTimeSecondValue(ValueUtil.getLongValue(value));
                break;
            }
            case TIME_MILLISECOND: {
                valueBuilder.setTimeMillisecondValue(ValueUtil.getLongValue(value));
                break;
            }
            case TIME_MICROSECOND: {
                valueBuilder.setTimeMicrosecondValue(ValueUtil.getLongValue(value));
                break;
            }
            case TIME_NANOSECOND: {
                valueBuilder.setTimeNanosecondValue(ValueUtil.getLongValue(value));
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                valueBuilder.setIntervalYearMonthValue(((Integer)value).intValue());
                break;
            }
            case INTERVAL_DAY_TIME: {
                valueBuilder.setIntervalDayTimeValue(ValueUtil.getLongValue(value));
                break;
            }
            case INTERVAL_MONTH_DAY_NANO: {
                valueBuilder.setIntervalMonthDayNanoValue(ValueUtil.getIntervalMonthDayNanoValue(value));
                break;
            }
            case DECIMAL128: {
                valueBuilder.setDecimal128Value(ValueUtil.getDecimal128Value(dataTypeExtension, value));
                break;
            }
            case JSON: {
                valueBuilder.setStringValue(ValueUtil.getJsonString(value));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported `data_type`: %s", dataType));
            }
        }
        builder.addValues(valueBuilder.build());
    }

    private RowHelper() {
    }
}

