/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import jakarta.persistence.criteria.Predicate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.hertzbeat.common.constants.PluginType;
import org.apache.hertzbeat.common.entity.dto.PluginUpload;
import org.apache.hertzbeat.common.entity.job.Configmap;
import org.apache.hertzbeat.common.entity.manager.PluginItem;
import org.apache.hertzbeat.common.entity.manager.PluginMetadata;
import org.apache.hertzbeat.common.entity.plugin.PluginConfig;
import org.apache.hertzbeat.common.entity.plugin.PluginContext;
import org.apache.hertzbeat.common.support.exception.CommonException;
import org.apache.hertzbeat.manager.dao.PluginItemDao;
import org.apache.hertzbeat.manager.dao.PluginMetadataDao;
import org.apache.hertzbeat.manager.dao.PluginParamDao;
import org.apache.hertzbeat.manager.pojo.dto.PluginParam;
import org.apache.hertzbeat.manager.pojo.dto.PluginParametersVO;
import org.apache.hertzbeat.manager.service.PluginService;
import org.apache.hertzbeat.plugin.Plugin;
import org.apache.hertzbeat.plugin.PostAlertPlugin;
import org.apache.hertzbeat.plugin.PostCollectPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

@Service
public class PluginServiceImpl
implements PluginService {
    private static final Logger log = LoggerFactory.getLogger(PluginServiceImpl.class);
    private final PluginMetadataDao metadataDao;
    private final PluginItemDao itemDao;
    private final PluginParamDao pluginParamDao;
    public static Map<Class<?>, PluginType> PLUGIN_TYPE_MAPPING = new HashMap();
    private static final Map<String, Boolean> PLUGIN_ENABLE_STATUS = new ConcurrentHashMap<String, Boolean>();
    private static final Map<Long, PluginConfig> PARAMS_CONFIG_MAP = new ConcurrentHashMap<Long, PluginConfig>();
    private static final Map<Long, List<Configmap>> PARAMS_MAP = new ConcurrentHashMap<Long, List<Configmap>>();
    private static final Map<String, Long> ITEM_TO_PLUGINMETADATAID_MAP = new ConcurrentHashMap<String, Long>();
    private final List<URLClassLoader> pluginClassLoaders = new ArrayList<URLClassLoader>();

    @Override
    @Transactional
    public void deletePlugins(Set<Long> ids) {
        Iterable plugins = this.metadataDao.findAllById(ids);
        for (PluginMetadata plugin : plugins) {
            plugin.setEnableStatus(false);
            this.updateStatus(plugin);
        }
        this.loadJarToClassLoader();
        for (PluginMetadata plugin : plugins) {
            try {
                File otherLibDir;
                File jarFile = new File(plugin.getJarFilePath());
                if (jarFile.exists()) {
                    FileUtils.delete(jarFile);
                }
                if ((otherLibDir = new File(this.getOtherLibDir(plugin.getJarFilePath()))).exists()) {
                    FileUtils.deleteDirectory(otherLibDir);
                }
                this.metadataDao.deleteById(plugin.getId());
                this.syncPluginParamMap(plugin.getId(), null, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.pluginParamDao.deletePluginParamsByPluginMetadataIdIn(ids);
        this.syncPluginStatus();
    }

    private String getOtherLibDir(String pluginJarPath) {
        return pluginJarPath.substring(0, pluginJarPath.lastIndexOf("."));
    }

    @Override
    public void updateStatus(PluginMetadata plugin) {
        Optional pluginMetadata = this.metadataDao.findById(plugin.getId());
        if (!pluginMetadata.isPresent()) {
            throw new IllegalArgumentException("The plugin is not existed");
        }
        PluginMetadata metadata = (PluginMetadata)pluginMetadata.get();
        metadata.setEnableStatus(plugin.getEnableStatus());
        this.metadataDao.save(metadata);
        this.syncSinglePluginStatus(metadata);
    }

    @Override
    public PluginParametersVO getParamDefine(Long pluginMetadataId) {
        PluginParametersVO pluginParametersVO = new PluginParametersVO();
        if (PARAMS_CONFIG_MAP.containsKey(pluginMetadataId)) {
            PluginConfig config = PARAMS_CONFIG_MAP.get(pluginMetadataId);
            List<PluginParam> paramsByPluginMetadataId = this.pluginParamDao.findParamsByPluginMetadataId(pluginMetadataId);
            pluginParametersVO.setParamDefines(Optional.ofNullable(config).map(PluginConfig::getParams).orElse(new ArrayList()));
            pluginParametersVO.setPluginParams(paramsByPluginMetadataId);
            return pluginParametersVO;
        }
        return pluginParametersVO;
    }

    @Override
    @Transactional
    public void savePluginParam(List<PluginParam> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        this.pluginParamDao.deletePluginParamsByPluginMetadataId(params.get(0).getPluginMetadataId());
        this.pluginParamDao.saveAll(params);
        this.syncPluginParamMap(params.get(0).getPluginMetadataId(), params, false);
    }

    private void syncPluginParamMap(Long pluginMetadataId, List<PluginParam> params, boolean isDelete) {
        if (isDelete) {
            PARAMS_MAP.remove(pluginMetadataId);
            return;
        }
        List<Configmap> configmapList = params.stream().map(item -> new Configmap(item.getField(), item.getParamValue(), item.getType())).toList();
        PARAMS_MAP.put(pluginMetadataId, configmapList);
    }

    public PluginMetadata validateJarFile(File jarFile) {
        PluginMetadata metadata = new PluginMetadata();
        ArrayList<PluginItem> pluginItems = new ArrayList<PluginItem>();
        AtomicInteger pluginImplementationCount = new AtomicInteger(0);
        try {
            URL jarUrl = new URL("file:" + jarFile.getAbsolutePath());
            try (URLClassLoader classLoader = new URLClassLoader(new URL[]{jarUrl}, this.getClass().getClassLoader());
                 JarFile jar = new JarFile(jarFile);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.getName().endsWith(".class")) {
                        String className = entry.getName().replace("/", ".").replace(".class", "");
                        try {
                            Class<?> cls = classLoader.loadClass(className);
                            if (cls.isInterface()) continue;
                            if (pluginImplementationCount.get() >= 1) {
                                throw new CommonException("A plugin package can only contain one plugin implementation class");
                            }
                            PLUGIN_TYPE_MAPPING.forEach((clazz, type) -> {
                                if (clazz.isAssignableFrom(cls)) {
                                    pluginItems.add(new PluginItem(className, (PluginType)((Object)type)));
                                    pluginImplementationCount.incrementAndGet();
                                }
                            });
                        }
                        catch (ClassNotFoundException e) {
                            System.err.println("Failed to load class: " + className);
                        }
                    }
                    if (!entry.getName().contains("define") || !entry.getName().endsWith(".yml") && !entry.getName().endsWith(".yaml")) continue;
                    PluginConfig config = this.readPluginConfig(jar, entry);
                    metadata.setParamCount(CollectionUtils.size(config.getParams()));
                }
                if (pluginItems.isEmpty()) {
                    throw new CommonException("Illegal plug-ins, please refer to https://hertzbeat.apache.org/docs/help/plugin/");
                }
            }
            catch (IOException e) {
                log.error("Error reading JAR file:{}", (Object)jarFile.getAbsoluteFile(), (Object)e);
                throw new CommonException("Error reading JAR file: " + jarFile.getAbsolutePath());
            }
        }
        catch (MalformedURLException e) {
            log.error("Invalid JAR file URL: {}", (Object)jarFile.getAbsoluteFile(), (Object)e);
            throw new CommonException("Invalid JAR file URL: " + jarFile.getAbsolutePath());
        }
        catch (YAMLException e) {
            throw new CommonException("YAML the file format is incorrect");
        }
        metadata.setItems(pluginItems);
        return metadata;
    }

    private void validateMetadata(PluginMetadata metadata) {
        if (this.metadataDao.countPluginMetadataByName(metadata.getName()) != 0) {
            throw new CommonException("A plugin named " + metadata.getName() + " already exists");
        }
    }

    @Override
    @Transactional
    public void savePlugin(PluginUpload pluginUpload) {
        PluginMetadata pluginMetadata;
        List<PluginItem> pluginItems;
        String jarPath = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).getAbsolutePath();
        Path extLibPath = Paths.get(new File(jarPath).getParent(), "plugin-lib");
        File extLibDir = extLibPath.toFile();
        Object fileName = pluginUpload.getJarFile().getOriginalFilename();
        this.validateFileName((String)fileName);
        fileName = UUID.randomUUID().toString().replace("-", "") + "_" + (String)fileName;
        File destFile = new File(extLibDir, (String)fileName);
        FileUtils.createParentDirectories(destFile);
        pluginUpload.getJarFile().transferTo(destFile);
        try {
            PluginMetadata parsed = this.validateJarFile(destFile);
            pluginItems = parsed.getItems();
            pluginMetadata = PluginMetadata.builder().name(pluginUpload.getName()).enableStatus(true).paramCount(parsed.getParamCount()).items(pluginItems).jarFilePath(destFile.getAbsolutePath()).gmtCreate(LocalDateTime.now()).build();
            this.validateMetadata(pluginMetadata);
        }
        catch (Exception e) {
            FileUtils.delete(destFile);
            throw e;
        }
        this.metadataDao.save(pluginMetadata);
        this.itemDao.saveAll(pluginItems);
        this.loadJarToClassLoader();
        this.syncPluginStatus();
    }

    private void validateFileName(String fileName) {
        if (fileName == null) {
            throw new CommonException("Failed to upload plugin");
        }
        if (fileName.matches(".*(\\.\\.|[\n\t\r/\\\\]).*")) {
            throw new CommonException("Invalid plugin file name: " + fileName);
        }
    }

    @Override
    public boolean pluginIsEnable(Class<?> clazz) {
        return Boolean.TRUE.equals(PLUGIN_ENABLE_STATUS.get(clazz.getName()));
    }

    @Override
    public Page<PluginMetadata> getPlugins(String search, int pageIndex, int pageSize) {
        Specification specification = (root, query, criteriaBuilder) -> {
            ArrayList<Predicate> andList = new ArrayList<Predicate>();
            if (search != null && !search.isEmpty()) {
                Predicate predicateApp = criteriaBuilder.like(root.get("name"), "%" + search + "%");
                andList.add(predicateApp);
            }
            Predicate[] andPredicates = new Predicate[andList.size()];
            Predicate andPredicate = criteriaBuilder.and(andList.toArray(andPredicates));
            if (andPredicates.length == 0) {
                return query.where(new Predicate[0]).getRestriction();
            }
            return andPredicate;
        };
        PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);
        return this.metadataDao.findAll(specification, (Pageable)pageRequest);
    }

    @PostConstruct
    private void syncPluginStatus() {
        Iterable plugins = this.metadataDao.findAll();
        HashMap<String, Boolean> statusMap = new HashMap<String, Boolean>();
        HashMap<String, Long> itemToPluginMetadataIdMap = new HashMap<String, Long>();
        for (PluginMetadata plugin : plugins) {
            for (PluginItem item : plugin.getItems()) {
                statusMap.put(item.getClassIdentifier(), plugin.getEnableStatus());
                itemToPluginMetadataIdMap.put(item.getClassIdentifier(), plugin.getId());
            }
        }
        PLUGIN_ENABLE_STATUS.clear();
        PLUGIN_ENABLE_STATUS.putAll(statusMap);
        ITEM_TO_PLUGINMETADATAID_MAP.clear();
        ITEM_TO_PLUGINMETADATAID_MAP.putAll(itemToPluginMetadataIdMap);
    }

    private void syncSinglePluginStatus(PluginMetadata plugin) {
        if (plugin == null || CollectionUtils.isEmpty(plugin.getItems())) {
            return;
        }
        for (PluginItem item : plugin.getItems()) {
            PLUGIN_ENABLE_STATUS.put(item.getClassIdentifier(), plugin.getEnableStatus());
            ITEM_TO_PLUGINMETADATAID_MAP.put(item.getClassIdentifier(), plugin.getId());
        }
    }

    @PostConstruct
    private void initParams() {
        try {
            Iterable params = this.pluginParamDao.findAll();
            Map<Long, List<PluginParam>> content = params.stream().collect(Collectors.groupingBy(PluginParam::getPluginMetadataId));
            for (Map.Entry<Long, List<PluginParam>> entry : content.entrySet()) {
                this.syncPluginParamMap(entry.getKey(), entry.getValue(), false);
            }
        }
        catch (Exception e) {
            log.error("Failed to init params:{}", (Object)e.getMessage());
            throw new CommonException("Failed to init params:" + e.getMessage());
        }
    }

    @PostConstruct
    private void loadJarToClassLoader() {
        try {
            for (URLClassLoader pluginClassLoader : this.pluginClassLoaders) {
                if (pluginClassLoader == null) continue;
                pluginClassLoader.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!this.pluginClassLoaders.isEmpty()) {
            this.pluginClassLoaders.clear();
            System.gc();
        }
        PARAMS_CONFIG_MAP.clear();
        List<PluginMetadata> plugins = this.metadataDao.findPluginMetadataByEnableStatusTrue();
        for (PluginMetadata metadata : plugins) {
            try {
                List<URL> urls = this.loadLibInPlugin(metadata.getJarFilePath(), metadata.getId());
                urls.add(new File(metadata.getJarFilePath()).toURI().toURL());
                this.pluginClassLoaders.add(new URLClassLoader(urls.toArray(new URL[0]), Plugin.class.getClassLoader()));
            }
            catch (MalformedURLException e) {
                log.error("Failed to load plugin:{}", (Object)e.getMessage());
                throw new CommonException("Failed to load plugin:" + e.getMessage());
            }
            catch (IOException exception) {
                log.error("{} plugin file is missing, please delete the plugin and upload it again", (Object)metadata.getName());
            }
        }
    }

    private List<URL> loadLibInPlugin(String pluginJarPath, Long pluginMetadataId) throws IOException {
        File libDir = new File(this.getOtherLibDir(pluginJarPath));
        FileUtils.forceMkdir(libDir);
        ArrayList<URL> libUrls = new ArrayList<URL>();
        try (JarFile jarFile = new JarFile(pluginJarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                File file = new File(libDir, entry.getName());
                if (entry.isDirectory()) continue;
                if (entry.getName().endsWith(".jar")) {
                    if (!file.getParentFile().exists()) {
                        FileUtils.createParentDirectories(file);
                    }
                    try (InputStream in = jarFile.getInputStream(entry);
                         FileOutputStream out = new FileOutputStream(file);){
                        int len;
                        byte[] buffer = new byte[4096];
                        while ((len = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, len);
                        }
                        libUrls.add(file.toURI().toURL());
                        out.flush();
                    }
                }
                if (!entry.getName().contains("define") || !entry.getName().endsWith(".yml") && !entry.getName().endsWith(".yaml")) continue;
                PluginConfig config = this.readPluginConfig(jarFile, entry);
                PARAMS_CONFIG_MAP.put(pluginMetadataId, config);
            }
        }
        return libUrls;
    }

    private PluginConfig readPluginConfig(JarFile jarFile, JarEntry entry) throws IOException {
        Yaml yaml = new Yaml();
        try (InputStream ymlInputStream = jarFile.getInputStream(entry);){
            PluginConfig config = yaml.loadAs(ymlInputStream, PluginConfig.class);
            if (config == null) {
                PluginConfig pluginConfig = new PluginConfig();
                return pluginConfig;
            }
            PluginConfig pluginConfig = config;
            return pluginConfig;
        }
    }

    @Override
    public <T> void pluginExecute(Class<T> clazz, Consumer<T> execute) {
        for (URLClassLoader pluginClassLoader : this.pluginClassLoaders) {
            ServiceLoader<T> load = ServiceLoader.load(clazz, pluginClassLoader);
            for (T t : load) {
                if (!this.pluginIsEnable(t.getClass())) continue;
                execute.accept(t);
            }
        }
    }

    @Override
    public <T> void pluginExecute(Class<T> clazz, BiConsumer<T, PluginContext> execute) {
        for (URLClassLoader pluginClassLoader : this.pluginClassLoaders) {
            ServiceLoader<T> load = ServiceLoader.load(clazz, pluginClassLoader);
            for (T t : load) {
                if (!this.pluginIsEnable(t.getClass())) continue;
                Long pluginId = ITEM_TO_PLUGINMETADATAID_MAP.get(t.getClass().getName());
                List<Configmap> configmapList = PARAMS_MAP.get(pluginId);
                PluginContext context = PluginContext.builder().params(configmapList).build();
                execute.accept(t, context);
            }
        }
    }

    public PluginServiceImpl(PluginMetadataDao metadataDao, PluginItemDao itemDao, PluginParamDao pluginParamDao) {
        this.metadataDao = metadataDao;
        this.itemDao = itemDao;
        this.pluginParamDao = pluginParamDao;
    }

    static {
        PLUGIN_TYPE_MAPPING.put(Plugin.class, PluginType.POST_ALERT);
        PLUGIN_TYPE_MAPPING.put(PostAlertPlugin.class, PluginType.POST_ALERT);
        PLUGIN_TYPE_MAPPING.put(PostCollectPlugin.class, PluginType.POST_COLLECT);
    }
}

