/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command;

import java.nio.ByteBuffer;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiPacketContext;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.IpmiLun;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.IpmiCommand;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.AbstractIpmiPayload;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.IpmiPayloadType;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.integrity.IntegrityUtils;

public abstract class AbstractIpmiCommand
extends AbstractIpmiPayload
implements IpmiCommand {
    private static final int SEQUENCE_NUMBER_MASK = 63;
    private byte rsAddress = (byte)32;
    private IpmiLun rsLun = IpmiLun.L0;
    private byte rqAddress = (byte)-127;
    private IpmiLun rqLun = IpmiLun.L0;
    private byte sequenceNumber;

    @Override
    public IpmiPayloadType getPayloadType() {
        return IpmiPayloadType.IPMI;
    }

    @Override
    public byte getRsAddress() {
        return this.rsAddress;
    }

    @Override
    public IpmiLun getRsLun() {
        return this.rsLun;
    }

    @Override
    public byte getRqAddress() {
        return this.rqAddress;
    }

    @Override
    public IpmiLun getRqLun() {
        return this.rqLun;
    }

    @Override
    public void setRqLun(IpmiLun rqLun) {
        this.rqLun = rqLun;
    }

    @Override
    public byte getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public void setSequenceNumber(byte sequenceNumber) {
        this.sequenceNumber = (byte)(sequenceNumber & 0x3F);
    }

    @Override
    public int getWireLength(IpmiPacketContext context) {
        return 7 + this.getDataWireLength(context);
    }

    public abstract int getDataWireLength(IpmiPacketContext var1);

    public abstract void toWireData(IpmiPacketContext var1, ByteBuffer var2);

    @Override
    public void toWire(IpmiPacketContext context, ByteBuffer buffer) {
        int c1 = buffer.position();
        buffer.put(this.getRsAddress());
        int netFn = this.getCommandName().getNetworkFunction().getCode(this);
        buffer.put((byte)(netFn << 2 | this.getRsLun().getValue()));
        byte c1sum = IntegrityUtils.calculateChecksum(buffer, c1);
        buffer.put(c1sum);
        int c2 = buffer.position();
        buffer.put(this.getRqAddress());
        byte seq = (byte)(this.getSequenceNumber() & 0x3F);
        buffer.put((byte)(seq << 2 | this.getRqLun().getValue()));
        buffer.put(this.getCommandName().getCode());
        this.toWireData(context, buffer);
        byte c2sum = IntegrityUtils.calculateChecksum(buffer, c2);
        buffer.put(c2sum);
    }

    public abstract void fromWireData(IpmiPacketContext var1, ByteBuffer var2);

    @Override
    public void fromWire(IpmiPacketContext context, ByteBuffer buffer) {
        int c1 = buffer.position();
        this.rqAddress = buffer.get();
        byte tmp = buffer.get();
        this.rqLun = IpmiCode.fromInt(IpmiLun.class, tmp & 3);
        IntegrityUtils.validChecksum(buffer, c1);
        int c2 = buffer.position();
        this.rsAddress = buffer.get();
        tmp = buffer.get();
        this.sequenceNumber = (byte)(tmp >>> 2 & 0x3F);
        this.rsLun = IpmiCode.fromInt(IpmiLun.class, tmp & 3);
        buffer.get();
        buffer.limit(buffer.limit() - 1);
        this.fromWireData(context, buffer);
        buffer.limit(buffer.limit() + 1);
        IntegrityUtils.validChecksum(buffer, c2);
    }
}

