/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.util.Arrays;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiPacketContext;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiSession;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.AbstractSessionIpmiPayload;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.IpmiPayloadType;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.MessageStatusCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.IpmiIntegrityCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.integrity.IpmiIntegrity;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteOrderUtils;

public class RakpMessage4
extends AbstractSessionIpmiPayload {
    private MessageStatusCode messageStatusCode;
    public int consoleSessionId;
    public byte[] integrityCheckValue;

    @Override
    public int getWireLength(IpmiPacketContext context) {
        return 0;
    }

    @Override
    public void toWire(IpmiPacketContext context, ByteBuffer buffer) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void fromWire(IpmiPacketContext context, ByteBuffer buffer) {
        this.messageTag = buffer.get();
        this.messageStatusCode = IpmiCode.fromBuffer(MessageStatusCode.class, buffer);
        RakpMessage4.ignoreBytes(buffer, 2);
        this.consoleSessionId = ByteOrderUtils.readLeInt(buffer);
        this.integrityCheckValue = ByteOrderUtils.readBytes(buffer, buffer.remaining());
        byte[] hash = this.verifyIntegrityCheckValue(context.getIpmiSession());
        if (!Arrays.equals(hash, this.integrityCheckValue)) {
            throw new RuntimeException("integrity check value mismatch");
        }
    }

    @Override
    public IpmiPayloadType getPayloadType() {
        return IpmiPayloadType.RAKPMessage4;
    }

    public byte[] verifyIntegrityCheckValue(IpmiSession session) {
        int length = 36;
        ByteBuffer buffer = ByteBuffer.allocate(length);
        ByteOrderUtils.writeBytes(buffer, session.getConsoleRandomNumber());
        ByteOrderUtils.writeLeInt(buffer, session.getSystemSessionId());
        ByteOrderUtils.writeBytes(buffer, session.getSystemGuid());
        IpmiIntegrityCode ipmiIntegrityCode = session.getIntegrityAlgorithm();
        IpmiIntegrity ipmiIntegrity = ipmiIntegrityCode.newIpmiIntegrity();
        if (ipmiIntegrity == null) {
            throw new UnsupportedOperationException("Unsupported authentication code: " + ipmiIntegrityCode);
        }
        try {
            ipmiIntegrity.setKey(session.getSik());
            ipmiIntegrity.setData(buffer.array());
            return ipmiIntegrity.getHash();
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }
}

