/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.manager.Label;
import org.apache.hertzbeat.manager.dao.LabelDao;
import org.apache.hertzbeat.manager.service.LabelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class LabelServiceImpl
implements LabelService {
    private static final Logger log = LoggerFactory.getLogger(LabelServiceImpl.class);
    @Autowired
    private LabelDao labelDao;

    @Override
    public void addLabel(Label label) {
        Optional<Label> optional = this.labelDao.findLabelByNameAndTagValue(label.getName(), label.getTagValue());
        if (optional.isPresent()) {
            throw new IllegalArgumentException("The label already exists.");
        }
        label.setType((byte)1);
        label.setId(null);
        this.labelDao.save(label);
    }

    @Override
    public void modifyLabel(Label label) {
        Optional optional = this.labelDao.findById(label.getId());
        if (optional.isPresent()) {
            Optional<Label> existOptional = this.labelDao.findLabelByNameAndTagValue(label.getName(), label.getTagValue());
            if (existOptional.isPresent() && !existOptional.get().getId().equals(label.getId())) {
                throw new IllegalArgumentException("The label with same key and value already exists.");
            }
        } else {
            throw new IllegalArgumentException("The label is not existed");
        }
        label.setTagValue(StringUtils.isEmpty((CharSequence)label.getTagValue()) ? null : label.getTagValue());
        this.labelDao.save(label);
    }

    @Override
    public Page<Label> getLabels(String search, Byte type, int pageIndex, int pageSize) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Predicate> andList = new ArrayList<Predicate>();
            if (type != null) {
                Predicate predicateApp = criteriaBuilder.equal((Expression)root.get("type"), (Object)type);
                andList.add(predicateApp);
            }
            Predicate[] andPredicates = new Predicate[andList.size()];
            Predicate andPredicate = criteriaBuilder.and(andList.toArray(andPredicates));
            ArrayList<Predicate> orList = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((CharSequence)search)) {
                Predicate predicateName = criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("name")), "%" + search.toLowerCase() + "%");
                orList.add(predicateName);
                Predicate predicateValue = criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("tagValue")), "%" + search.toLowerCase() + "%");
                orList.add(predicateValue);
            }
            Predicate[] orPredicates = new Predicate[orList.size()];
            Predicate orPredicate = criteriaBuilder.or(orList.toArray(orPredicates));
            if (andPredicates.length == 0 && orPredicates.length == 0) {
                return query.where(new Predicate[0]).getRestriction();
            }
            if (andPredicates.length == 0) {
                return orPredicate;
            }
            if (orPredicates.length == 0) {
                return andPredicate;
            }
            return query.where(new Predicate[]{andPredicate, orPredicate}).getRestriction();
        };
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize);
        return this.labelDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public void deleteLabels(HashSet<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.labelDao.deleteLabelsByIdIn(ids);
    }

    @Override
    public List<Label> determineNewLabels(Set<Map.Entry<String, String>> originLabels) {
        if (originLabels == null || originLabels.isEmpty()) {
            return List.of();
        }
        Set allLabels = this.labelDao.findAll().stream().map(label -> Map.entry(label.getName(), label.getTagValue())).collect(Collectors.toSet());
        Set addLabelsKv = originLabels.stream().filter(label -> !allLabels.contains(label)).collect(Collectors.toCollection(HashSet::new));
        return addLabelsKv.stream().map(kv -> {
            Label label = new Label();
            label.setId(null);
            label.setName((String)kv.getKey());
            label.setTagValue((String)kv.getValue());
            label.setType((byte)0);
            return label;
        }).toList();
    }
}

