/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.table;

import java.util.Iterator;
import java.util.List;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.table.BaseTable;
import org.apache.arrow.vector.table.Row;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.TransferPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowTable
extends BaseTable {
    private static final Logger log = LoggerFactory.getLogger(ArrowTable.class);

    public ArrowTable(List<FieldVector> fieldVectors, int rowCount, DictionaryProvider provider) {
        super(fieldVectors, rowCount, provider);
    }

    public ArrowTable(VectorSchemaRoot vsr) {
        this(vsr.getFieldVectors(), vsr.getRowCount(), null);
        try {
            this.schema = Schema.fromJSON((String)vsr.getSchema().toJson());
        }
        catch (Exception e) {
            log.error("Failed to parse arrow table schema from VectorSchemaRoot", (Throwable)e);
        }
        vsr.clear();
    }

    public VectorSchemaRoot toVectorSchemaRoot() {
        List<FieldVector> fieldVectorList = this.fieldVectors.stream().map(v -> {
            TransferPair transferPair = v.getTransferPair(v.getAllocator());
            transferPair.transfer();
            return (FieldVector)transferPair.getTo();
        }).toList();
        VectorSchemaRoot vsr = new VectorSchemaRoot(this.schema, fieldVectorList, this.rowCount);
        this.clear();
        return vsr;
    }

    public FieldVector getVector(String columnName) {
        return super.getVector(columnName);
    }

    public Iterator<Row> iterator() {
        return new Iterator<Row>(){
            private final Row row;
            {
                this.row = new Row((BaseTable)ArrowTable.this);
            }

            @Override
            public Row next() {
                this.row.next();
                return this.row;
            }

            @Override
            public boolean hasNext() {
                return this.row.hasNext();
            }
        };
    }
}

