/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.util;

import org.apache.commons.lang3.StringUtils;

public class PoiDataDesensitizationUtil {
    private static String SPILT_START_END = "_";
    private static String SPILT_MAX = ",";
    private static String SPILT_MARK = "~";

    public static String desensitization(String rule, Object data) {
        String value = data.toString();
        if (rule.contains(SPILT_START_END)) {
            String[] arr = rule.split(SPILT_START_END);
            return PoiDataDesensitizationUtil.subStartEndString(Integer.parseInt(arr[0]), Integer.parseInt(arr[1]), value);
        }
        if (rule.contains(SPILT_MAX)) {
            String[] arr = rule.split(SPILT_MAX);
            return PoiDataDesensitizationUtil.subMaxString(Integer.parseInt(arr[0]), Integer.parseInt(arr[1]), value);
        }
        if (rule.contains(SPILT_MARK)) {
            String[] arr = rule.split(SPILT_MARK);
            return PoiDataDesensitizationUtil.markSpilt(Integer.parseInt(arr[0]), arr[1], value);
        }
        return value;
    }

    private static String markSpilt(int start, String mark, String value) {
        if (value == null) {
            return null;
        }
        int end = value.lastIndexOf(mark);
        if (end <= start) {
            return value;
        }
        return StringUtils.left((String)value, (int)start).concat(StringUtils.leftPad((String)StringUtils.right((String)value, (int)(value.length() - end)), (int)(value.length() - start), (String)"*"));
    }

    private static String subMaxString(int start, int end, String value) {
        if (value == null) {
            return null;
        }
        if (start > end) {
            throw new IllegalArgumentException("start must less end");
        }
        int len = value.length();
        if (len <= start) {
            return StringUtils.leftPad((String)"", (int)len, (String)"*");
        }
        if (len > start && len <= end) {
            if (len == 1) {
                return value;
            }
            if (len == 2) {
                return StringUtils.left((String)value, (int)1).concat("*");
            }
            return StringUtils.left((String)value, (int)1).concat(StringUtils.leftPad((String)StringUtils.right((String)value, (int)1), (int)(StringUtils.length((CharSequence)value) - 1), (String)"*"));
        }
        start = (int)Math.ceil(((double)(len - end) + 0.0) / 2.0);
        end = (end = len - start - end) == 0 ? 1 : end;
        return StringUtils.left((String)value, (int)start).concat(StringUtils.leftPad((String)StringUtils.right((String)value, (int)end), (int)(len - start), (String)"*"));
    }

    private static String subStartEndString(int start, int end, String value) {
        if (value == null) {
            return null;
        }
        if (value.length() <= start + end) {
            return value;
        }
        return StringUtils.left((String)value, (int)start).concat(StringUtils.leftPad((String)StringUtils.right((String)value, (int)end), (int)(StringUtils.length((CharSequence)value) - start), (String)"*"));
    }
}

