/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.notice.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.hertzbeat.alert.notice.AlertNoticeException;
import org.apache.hertzbeat.alert.notice.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WeComAppAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(WeComAppAlertNotifyHandlerImpl.class);
    private static final String APP_MESSAGE_URL = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=%s";
    private static final String SECRET_URL = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=%s&corpsecret=%s";
    private static final String DEFAULT_ALL = "@all";
    private final RestTemplate restTemplate;

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) throws AlertNoticeException {
        String corpId = receiver.getCorpId();
        Integer agentId = receiver.getAgentId();
        String appSecret = receiver.getAppSecret();
        String userId = receiver.getUserId();
        String partyId = receiver.getPartyId();
        String tagId = receiver.getTagId();
        try {
            ResponseEntity entityResponse = this.restTemplate.getForEntity(String.format(SECRET_URL, corpId, appSecret), WeChatAppReq.class, new Object[0]);
            if (Objects.nonNull(entityResponse.getBody())) {
                boolean hasTagId;
                String accessToken = ((WeChatAppReq)entityResponse.getBody()).getAccessToken();
                WeChatAppDTO.MarkdownDTO markdown = new WeChatAppDTO.MarkdownDTO();
                markdown.setContent(this.renderContent(noticeTemplate, alert));
                WeChatAppDTO.WeChatAppDTOBuilder weChatAppDTOBuilder = WeChatAppDTO.builder().msgType("markdown").markdown(markdown).agentId(agentId);
                boolean hasUserId = receiver.getUserId() != null;
                boolean hasPartyId = receiver.getPartyId() != null;
                boolean bl = hasTagId = receiver.getTagId() != null;
                if (hasUserId) {
                    weChatAppDTOBuilder.toUser(userId);
                }
                if (hasPartyId) {
                    weChatAppDTOBuilder.toParty(partyId);
                }
                if (hasTagId) {
                    weChatAppDTOBuilder.toTag(tagId);
                }
                if (!(hasUserId || hasPartyId || hasTagId)) {
                    weChatAppDTOBuilder.toUser(DEFAULT_ALL);
                }
                WeChatAppDTO weChatAppDTO = weChatAppDTOBuilder.build();
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                HttpEntity weChatAppEntity = new HttpEntity((Object)weChatAppDTO, (MultiValueMap)headers);
                ResponseEntity response = this.restTemplate.postForEntity(String.format(APP_MESSAGE_URL, accessToken), (Object)weChatAppEntity, WeChatAppReq.class, new Object[0]);
                if (Objects.nonNull(response.getBody()) && !Objects.equals(((WeChatAppReq)response.getBody()).getErrCode(), 0)) {
                    log.warn("Send Enterprise WeChat App Error: {}", (Object)((WeChatAppReq)response.getBody()).getErrMsg());
                    throw new AlertNoticeException("Http StatusCode " + response.getStatusCode() + " Error: " + ((WeChatAppReq)response.getBody()).getErrMsg());
                }
            }
        }
        catch (Exception e) {
            throw new AlertNoticeException("[Enterprise WeChat Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 10;
    }

    public WeComAppAlertNotifyHandlerImpl(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    protected static class WeChatAppReq {
        @JsonProperty(value="errcode")
        private Integer errCode;
        @JsonProperty(value="errmsg")
        private String errMsg;
        @JsonProperty(value="access_token")
        private String accessToken;

        public Integer getErrCode() {
            return this.errCode;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        @JsonProperty(value="errcode")
        public void setErrCode(Integer errCode) {
            this.errCode = errCode;
        }

        @JsonProperty(value="errmsg")
        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        @JsonProperty(value="access_token")
        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeChatAppReq)) {
                return false;
            }
            WeChatAppReq other = (WeChatAppReq)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$errCode = this.getErrCode();
            Integer other$errCode = other.getErrCode();
            if (this$errCode == null ? other$errCode != null : !((Object)this$errCode).equals(other$errCode)) {
                return false;
            }
            String this$errMsg = this.getErrMsg();
            String other$errMsg = other.getErrMsg();
            if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            return !(this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WeChatAppReq;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $errCode = this.getErrCode();
            result = result * 59 + ($errCode == null ? 43 : ((Object)$errCode).hashCode());
            String $errMsg = this.getErrMsg();
            result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            return result;
        }

        public String toString() {
            return "WeComAppAlertNotifyHandlerImpl.WeChatAppReq(errCode=" + this.getErrCode() + ", errMsg=" + this.getErrMsg() + ", accessToken=" + this.getAccessToken() + ")";
        }

        public WeChatAppReq(Integer errCode, String errMsg, String accessToken) {
            this.errCode = errCode;
            this.errMsg = errMsg;
            this.accessToken = accessToken;
        }

        public WeChatAppReq() {
        }
    }

    protected static class WeChatAppDTO {
        public static final String MARKDOWN = "markdown";
        @JsonProperty(value="touser")
        private String toUser;
        @JsonProperty(value="toparty")
        private String toParty;
        @JsonProperty(value="totag")
        private String toTag;
        @JsonProperty(value="msgtype")
        private String msgType;
        @JsonProperty(value="agentid")
        private Integer agentId;
        private TextDTO text;
        private MarkdownDTO markdown;

        public static WeChatAppDTOBuilder builder() {
            return new WeChatAppDTOBuilder();
        }

        public String getToUser() {
            return this.toUser;
        }

        public String getToParty() {
            return this.toParty;
        }

        public String getToTag() {
            return this.toTag;
        }

        public String getMsgType() {
            return this.msgType;
        }

        public Integer getAgentId() {
            return this.agentId;
        }

        public TextDTO getText() {
            return this.text;
        }

        public MarkdownDTO getMarkdown() {
            return this.markdown;
        }

        @JsonProperty(value="touser")
        public void setToUser(String toUser) {
            this.toUser = toUser;
        }

        @JsonProperty(value="toparty")
        public void setToParty(String toParty) {
            this.toParty = toParty;
        }

        @JsonProperty(value="totag")
        public void setToTag(String toTag) {
            this.toTag = toTag;
        }

        @JsonProperty(value="msgtype")
        public void setMsgType(String msgType) {
            this.msgType = msgType;
        }

        @JsonProperty(value="agentid")
        public void setAgentId(Integer agentId) {
            this.agentId = agentId;
        }

        public void setText(TextDTO text) {
            this.text = text;
        }

        public void setMarkdown(MarkdownDTO markdown) {
            this.markdown = markdown;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeChatAppDTO)) {
                return false;
            }
            WeChatAppDTO other = (WeChatAppDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$agentId = this.getAgentId();
            Integer other$agentId = other.getAgentId();
            if (this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId)) {
                return false;
            }
            String this$toUser = this.getToUser();
            String other$toUser = other.getToUser();
            if (this$toUser == null ? other$toUser != null : !this$toUser.equals(other$toUser)) {
                return false;
            }
            String this$toParty = this.getToParty();
            String other$toParty = other.getToParty();
            if (this$toParty == null ? other$toParty != null : !this$toParty.equals(other$toParty)) {
                return false;
            }
            String this$toTag = this.getToTag();
            String other$toTag = other.getToTag();
            if (this$toTag == null ? other$toTag != null : !this$toTag.equals(other$toTag)) {
                return false;
            }
            String this$msgType = this.getMsgType();
            String other$msgType = other.getMsgType();
            if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
                return false;
            }
            TextDTO this$text = this.getText();
            TextDTO other$text = other.getText();
            if (this$text == null ? other$text != null : !((Object)this$text).equals(other$text)) {
                return false;
            }
            MarkdownDTO this$markdown = this.getMarkdown();
            MarkdownDTO other$markdown = other.getMarkdown();
            return !(this$markdown == null ? other$markdown != null : !((Object)this$markdown).equals(other$markdown));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WeChatAppDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $agentId = this.getAgentId();
            result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
            String $toUser = this.getToUser();
            result = result * 59 + ($toUser == null ? 43 : $toUser.hashCode());
            String $toParty = this.getToParty();
            result = result * 59 + ($toParty == null ? 43 : $toParty.hashCode());
            String $toTag = this.getToTag();
            result = result * 59 + ($toTag == null ? 43 : $toTag.hashCode());
            String $msgType = this.getMsgType();
            result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
            TextDTO $text = this.getText();
            result = result * 59 + ($text == null ? 43 : ((Object)$text).hashCode());
            MarkdownDTO $markdown = this.getMarkdown();
            result = result * 59 + ($markdown == null ? 43 : ((Object)$markdown).hashCode());
            return result;
        }

        public String toString() {
            return "WeComAppAlertNotifyHandlerImpl.WeChatAppDTO(toUser=" + this.getToUser() + ", toParty=" + this.getToParty() + ", toTag=" + this.getToTag() + ", msgType=" + this.getMsgType() + ", agentId=" + this.getAgentId() + ", text=" + this.getText() + ", markdown=" + this.getMarkdown() + ")";
        }

        public WeChatAppDTO(String toUser, String toParty, String toTag, String msgType, Integer agentId, TextDTO text, MarkdownDTO markdown) {
            this.toUser = toUser;
            this.toParty = toParty;
            this.toTag = toTag;
            this.msgType = msgType;
            this.agentId = agentId;
            this.text = text;
            this.markdown = markdown;
        }

        public WeChatAppDTO() {
        }

        public static class WeChatAppDTOBuilder {
            private String toUser;
            private String toParty;
            private String toTag;
            private String msgType;
            private Integer agentId;
            private TextDTO text;
            private MarkdownDTO markdown;

            WeChatAppDTOBuilder() {
            }

            @JsonProperty(value="touser")
            public WeChatAppDTOBuilder toUser(String toUser) {
                this.toUser = toUser;
                return this;
            }

            @JsonProperty(value="toparty")
            public WeChatAppDTOBuilder toParty(String toParty) {
                this.toParty = toParty;
                return this;
            }

            @JsonProperty(value="totag")
            public WeChatAppDTOBuilder toTag(String toTag) {
                this.toTag = toTag;
                return this;
            }

            @JsonProperty(value="msgtype")
            public WeChatAppDTOBuilder msgType(String msgType) {
                this.msgType = msgType;
                return this;
            }

            @JsonProperty(value="agentid")
            public WeChatAppDTOBuilder agentId(Integer agentId) {
                this.agentId = agentId;
                return this;
            }

            public WeChatAppDTOBuilder text(TextDTO text) {
                this.text = text;
                return this;
            }

            public WeChatAppDTOBuilder markdown(MarkdownDTO markdown) {
                this.markdown = markdown;
                return this;
            }

            public WeChatAppDTO build() {
                return new WeChatAppDTO(this.toUser, this.toParty, this.toTag, this.msgType, this.agentId, this.text, this.markdown);
            }

            public String toString() {
                return "WeComAppAlertNotifyHandlerImpl.WeChatAppDTO.WeChatAppDTOBuilder(toUser=" + this.toUser + ", toParty=" + this.toParty + ", toTag=" + this.toTag + ", msgType=" + this.msgType + ", agentId=" + this.agentId + ", text=" + this.text + ", markdown=" + this.markdown + ")";
            }
        }

        protected static class TextDTO {
            private String content;

            public String getContent() {
                return this.content;
            }

            public void setContent(String content) {
                this.content = content;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TextDTO)) {
                    return false;
                }
                TextDTO other = (TextDTO)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$content = this.getContent();
                String other$content = other.getContent();
                return !(this$content == null ? other$content != null : !this$content.equals(other$content));
            }

            protected boolean canEqual(Object other) {
                return other instanceof TextDTO;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $content = this.getContent();
                result = result * 59 + ($content == null ? 43 : $content.hashCode());
                return result;
            }

            public String toString() {
                return "WeComAppAlertNotifyHandlerImpl.WeChatAppDTO.TextDTO(content=" + this.getContent() + ")";
            }
        }

        protected static class MarkdownDTO {
            private String content;

            public String getContent() {
                return this.content;
            }

            public void setContent(String content) {
                this.content = content;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MarkdownDTO)) {
                    return false;
                }
                MarkdownDTO other = (MarkdownDTO)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$content = this.getContent();
                String other$content = other.getContent();
                return !(this$content == null ? other$content != null : !this$content.equals(other$content));
            }

            protected boolean canEqual(Object other) {
                return other instanceof MarkdownDTO;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $content = this.getContent();
                result = result * 59 + ($content == null ? 43 : $content.hashCode());
                return result;
            }

            public String toString() {
                return "WeComAppAlertNotifyHandlerImpl.WeChatAppDTO.MarkdownDTO(content=" + this.getContent() + ")";
            }
        }
    }
}

