/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import jakarta.annotation.Resource;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.List;
import org.apache.hertzbeat.alert.dto.AlertDefineDTO;
import org.apache.hertzbeat.alert.dto.ExportAlertDefineDTO;
import org.apache.hertzbeat.alert.service.AlertDefineImExportService;
import org.apache.hertzbeat.alert.service.AlertDefineService;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;

public abstract class AlertDefineAbstractImExportServiceImpl
implements AlertDefineImExportService {
    private static final Logger log = LoggerFactory.getLogger(AlertDefineAbstractImExportServiceImpl.class);
    @Resource
    @Lazy
    private AlertDefineService alertDefineService;

    @Override
    public void importConfig(InputStream is) {
        List<AlertDefine> formList = this.parseImport(is).stream().map(this::convert).toList();
        if (!CollectionUtils.isEmpty(formList)) {
            formList.forEach(alertDefine -> {
                this.alertDefineService.validate((AlertDefine)alertDefine, false);
                this.alertDefineService.addAlertDefine((AlertDefine)alertDefine);
            });
        }
    }

    @Override
    public void exportConfig(OutputStream os, List<Long> configList) {
        List<ExportAlertDefineDTO> monitorList = configList.stream().map(it -> this.alertDefineService.getAlertDefine((long)it)).map(this::convert).toList();
        this.writeOs(monitorList, os);
    }

    abstract List<ExportAlertDefineDTO> parseImport(InputStream var1);

    abstract void writeOs(List<ExportAlertDefineDTO> var1, OutputStream var2);

    private ExportAlertDefineDTO convert(AlertDefine alertDefine) {
        ExportAlertDefineDTO exportAlertDefine = new ExportAlertDefineDTO();
        AlertDefineDTO alertDefineDTO = new AlertDefineDTO();
        BeanUtils.copyProperties((Object)alertDefine, (Object)alertDefineDTO);
        exportAlertDefine.setAlertDefine(alertDefineDTO);
        return exportAlertDefine;
    }

    private AlertDefine convert(ExportAlertDefineDTO exportAlertDefineDTO) {
        AlertDefine alertDefine = new AlertDefine();
        AlertDefineDTO alertDefineDTO = exportAlertDefineDTO.getAlertDefine();
        BeanUtils.copyProperties((Object)alertDefineDTO, (Object)alertDefine);
        return alertDefine;
    }

    protected String fileNamePrefix() {
        return "hertzbeat_alertDefine_" + LocalDate.now();
    }
}

