/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit.window;

import com.netflix.concurrency.limits.internal.Preconditions;
import com.netflix.concurrency.limits.limit.window.ImmutablePercentileSampleWindow;
import com.netflix.concurrency.limits.limit.window.SampleWindowFactory;

public class PercentileSampleWindowFactory
implements SampleWindowFactory {
    private final double percentile;
    private final int windowSize;

    private PercentileSampleWindowFactory(double percentile, int windowSize) {
        this.percentile = percentile;
        this.windowSize = windowSize;
    }

    public static PercentileSampleWindowFactory of(double percentile, int windowSize) {
        Preconditions.checkArgument(percentile > 0.0 && percentile < 1.0, "Percentile should belong to (0, 1.0)");
        return new PercentileSampleWindowFactory(percentile, windowSize);
    }

    @Override
    public ImmutablePercentileSampleWindow newInstance() {
        return new ImmutablePercentileSampleWindow(this.percentile, this.windowSize);
    }
}

