/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Sets;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Predicate;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hertzbeat.alert.dao.AlertDefineBindDao;
import org.apache.hertzbeat.common.entity.grafana.GrafanaDashboard;
import org.apache.hertzbeat.common.entity.job.Configmap;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.manager.Collector;
import org.apache.hertzbeat.common.entity.manager.CollectorMonitorBind;
import org.apache.hertzbeat.common.entity.manager.Label;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.MonitorBind;
import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.support.event.MonitorDeletedEvent;
import org.apache.hertzbeat.common.util.AesUtil;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.FileUtil;
import org.apache.hertzbeat.common.util.IntervalExpressionUtil;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.common.util.SnowFlakeIdGenerator;
import org.apache.hertzbeat.grafana.service.DashboardService;
import org.apache.hertzbeat.manager.config.ManagerSseManager;
import org.apache.hertzbeat.manager.dao.CollectorDao;
import org.apache.hertzbeat.manager.dao.CollectorMonitorBindDao;
import org.apache.hertzbeat.manager.dao.LabelDao;
import org.apache.hertzbeat.manager.dao.MonitorBindDao;
import org.apache.hertzbeat.manager.dao.MonitorDao;
import org.apache.hertzbeat.manager.dao.ParamDao;
import org.apache.hertzbeat.manager.pojo.dto.AppCount;
import org.apache.hertzbeat.manager.pojo.dto.MonitorDto;
import org.apache.hertzbeat.manager.scheduler.CollectJobScheduling;
import org.apache.hertzbeat.manager.service.AppService;
import org.apache.hertzbeat.manager.service.ImExportService;
import org.apache.hertzbeat.manager.service.LabelService;
import org.apache.hertzbeat.manager.service.MonitorService;
import org.apache.hertzbeat.manager.support.exception.MonitorDatabaseException;
import org.apache.hertzbeat.manager.support.exception.MonitorDetectException;
import org.apache.hertzbeat.warehouse.service.WarehouseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class MonitorServiceImpl
implements MonitorService {
    private static final Logger log = LoggerFactory.getLogger(MonitorServiceImpl.class);
    public static final String PATTERN_HTTP = "(?i)http://";
    public static final String PATTERN_HTTPS = "(?i)https://";
    private static final Long MONITOR_ID_TMP = 1000000000L;
    private static final byte ALL_MONITOR_STATUS = 9;
    private static final String CONTENT_VALUE = "application/octet-stream;charset=" + StandardCharsets.UTF_8;
    private final Map<String, ImExportService> imExportServiceMap = new HashMap<String, ImExportService>();
    @Autowired
    private AppService appService;
    @Autowired
    private CollectJobScheduling collectJobScheduling;
    @Autowired
    private MonitorDao monitorDao;
    @Autowired
    private ParamDao paramDao;
    @Autowired
    private MonitorBindDao monitorBindDao;
    @Autowired
    private CollectorDao collectorDao;
    @Autowired
    private CollectorMonitorBindDao collectorMonitorBindDao;
    @Autowired
    private AlertDefineBindDao alertDefineBindDao;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private WarehouseService warehouseService;
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private ManagerSseManager managerSseManager;
    @Autowired
    private LabelDao labelDao;
    @Autowired
    private LabelService labelService;

    public MonitorServiceImpl(List<ImExportService> imExportServiceList) {
        imExportServiceList.forEach(it -> this.imExportServiceMap.put(it.type(), (ImExportService)it));
    }

    @Override
    @Transactional(readOnly=true)
    public void detectMonitor(Monitor monitor, List<Param> params, String collector) throws MonitorDetectException {
        if ("static".equals(monitor.getScrape()) || !StringUtils.hasText(monitor.getScrape())) {
            this.detectMonitorDirectly(monitor, params, collector);
        } else {
            this.detectSdMonitor(monitor, params, collector);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addMonitor(Monitor monitor, List<Param> params, String collector, GrafanaDashboard grafanaDashboard) throws RuntimeException {
        List<Label> addLabels;
        long monitorId = SnowFlakeIdGenerator.generateId();
        Map<String, String> labels = monitor.getLabels();
        if (labels == null) {
            labels = new HashMap<String, String>(8);
            monitor.setLabels(labels);
        }
        if (!(addLabels = this.labelService.determineNewLabels(labels.entrySet())).isEmpty()) {
            this.labelDao.saveAll(addLabels);
        }
        boolean isStatic = "static".equals(monitor.getScrape()) || !StringUtils.hasText(monitor.getScrape());
        String app = isStatic ? monitor.getApp() : monitor.getScrape();
        Job appDefine = this.appService.getAppDefine(app);
        if (!isStatic) {
            appDefine.setSd(true);
        }
        if ("prometheus".equals(monitor.getApp())) {
            appDefine.setApp("_prometheus_" + monitor.getName());
        }
        appDefine.setMonitorId(monitorId);
        appDefine.setDefaultInterval(monitor.getIntervals().intValue());
        appDefine.setCyclic(true);
        appDefine.setTimestamp(System.currentTimeMillis());
        Map<String, String> metadata = Map.of("instancename", monitor.getName(), "instancehost", monitor.getHost());
        appDefine.setMetadata(metadata);
        appDefine.setLabels(monitor.getLabels());
        appDefine.setAnnotations(monitor.getAnnotations());
        List<Configmap> configmaps = params.stream().map(param -> {
            param.setMonitorId(monitorId);
            return new Configmap(param.getField(), param.getParamValue(), param.getType());
        }).collect(Collectors.toList());
        appDefine.setConfigmap(configmaps);
        long jobId = collector == null ? this.collectJobScheduling.addAsyncCollectJob(appDefine, null) : this.collectJobScheduling.addAsyncCollectJob(appDefine, collector);
        try {
            this.detectMonitor(monitor, params, collector);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (collector != null) {
                CollectorMonitorBind collectorMonitorBind = CollectorMonitorBind.builder().collector(collector).monitorId(monitorId).build();
                this.collectorMonitorBindDao.save(collectorMonitorBind);
            }
            monitor.setId(monitorId);
            monitor.setJobId(jobId);
            if (monitor.getApp().equals("prometheus") && grafanaDashboard != null && grafanaDashboard.isEnabled()) {
                this.dashboardService.createOrUpdateDashboard(grafanaDashboard.getTemplate(), monitorId);
            }
            this.monitorDao.save(monitor);
            this.paramDao.saveAll(params);
        }
        catch (Exception e) {
            log.error("Error while adding monitor: {}", (Object)e.getMessage(), (Object)e);
            this.collectJobScheduling.cancelAsyncCollectJob(jobId);
            throw new MonitorDatabaseException(e.getMessage());
        }
    }

    @Override
    public void export(List<Long> ids, String type, HttpServletResponse res) throws Exception {
        ImExportService imExportService = this.imExportServiceMap.get(type);
        if (imExportService == null) {
            throw new IllegalArgumentException("not support export type: " + type);
        }
        String fileName = imExportService.getFileName();
        res.setHeader("Content-Disposition", CONTENT_VALUE);
        res.setContentType(CONTENT_VALUE);
        res.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, StandardCharsets.UTF_8));
        res.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        imExportService.exportConfig(res.getOutputStream(), ids);
    }

    @Override
    public void importConfig(MultipartFile file) throws Exception {
        String fileName = FileUtil.getFileName(file);
        String type = FileUtil.getFileType(file);
        try {
            if (!this.imExportServiceMap.containsKey(type)) {
                String errMsg = "file " + fileName + " is not supported.";
                throw new RuntimeException(errMsg);
            }
            ImExportService imExportService = this.imExportServiceMap.get(type);
            imExportService.importConfig(fileName, file.getInputStream());
        }
        catch (Exception e) {
            this.managerSseManager.broadcastImportTaskFail(fileName, e.getMessage());
            throw e;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public void validate(MonitorDto monitorDto, Boolean isModify) throws IllegalArgumentException {
        Monitor monitor = monitorDto.getMonitor();
        monitor.setHost(monitor.getHost().trim());
        monitor.setName(monitor.getName().trim());
        Map<String, Param> paramMap = monitorDto.getParams().stream().peek(param -> {
            param.setMonitorId(monitor.getId());
            String value = param.getParamValue() == null ? null : param.getParamValue().trim();
            param.setParamValue(value);
        }).collect(Collectors.toMap(Param::getField, param -> param));
        if (isModify != null) {
            Optional<Job> defineOptional = this.appService.getAppDefineOption(monitor.getName());
            if (defineOptional.isPresent()) {
                throw new IllegalArgumentException("Monitoring name cannot be the existed monitoring type name!");
            }
            Optional<Monitor> monitorOptional = this.monitorDao.findMonitorByNameEquals(monitor.getName());
            if (monitorOptional.isPresent()) {
                Monitor existMonitor = monitorOptional.get();
                if (isModify.booleanValue()) {
                    if (!existMonitor.getId().equals(monitor.getId())) {
                        throw new IllegalArgumentException("Monitoring name already exists!");
                    }
                } else {
                    throw new IllegalArgumentException("Monitoring name already exists!");
                }
            }
        }
        if (StringUtils.hasText(monitorDto.getCollector())) {
            Optional<Collector> optionalCollector = this.collectorDao.findCollectorByName(monitorDto.getCollector());
            if (optionalCollector.isEmpty()) {
                throw new IllegalArgumentException("The pinned collector does not exist.");
            }
        } else {
            monitorDto.setCollector(null);
        }
        List<ParamDefine> paramDefines = this.appService.getAppParamDefines(monitorDto.getMonitor().getApp());
        if (!CollectionUtils.isEmpty(paramDefines)) {
            block27: for (ParamDefine paramDefine : paramDefines) {
                String field = paramDefine.getField();
                Param param2 = paramMap.get(field);
                if (paramDefine.isRequired() && (param2 == null || param2.getParamValue() == null)) {
                    throw new IllegalArgumentException("Params field " + field + " is required.");
                }
                if (param2 == null || !StringUtils.hasText(param2.getParamValue())) continue;
                switch (paramDefine.getType()) {
                    case "number": {
                        double doubleValue;
                        try {
                            doubleValue = Double.parseDouble(param2.getParamValue());
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Params field " + field + " type " + paramDefine.getType() + " is invalid.");
                        }
                        if (paramDefine.getRange() != null && !IntervalExpressionUtil.validNumberIntervalExpress(doubleValue, paramDefine.getRange())) {
                            throw new IllegalArgumentException("Params field " + field + " type " + paramDefine.getType() + " over range " + paramDefine.getRange());
                        }
                        param2.setType((byte)0);
                        continue block27;
                    }
                    case "textarea": {
                        Short textareaLimit = paramDefine.getLimit();
                        if (textareaLimit == null || param2.getParamValue().length() <= textareaLimit) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " type " + paramDefine.getType() + " over limit " + param2.getParamValue());
                    }
                    case "text": {
                        Short textLimit = paramDefine.getLimit();
                        if (textLimit == null || param2.getParamValue().length() <= textLimit) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " type " + paramDefine.getType() + " over limit " + textLimit);
                    }
                    case "host": {
                        String hostValue = param2.getParamValue();
                        if (hostValue.toLowerCase().contains("http://")) {
                            hostValue = hostValue.replaceAll(PATTERN_HTTP, " ");
                        }
                        if (hostValue.toLowerCase().contains("https://")) {
                            hostValue = hostValue.replace(PATTERN_HTTPS, " ");
                        }
                        if (IpDomainUtil.validateIpDomain(hostValue)) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " value " + hostValue + " is invalid host value.");
                    }
                    case "password": {
                        String passwordValue = param2.getParamValue();
                        if (!AesUtil.isCiphertext(passwordValue)) {
                            passwordValue = AesUtil.aesEncode(passwordValue);
                            param2.setParamValue(passwordValue);
                        }
                        param2.setType((byte)2);
                        continue block27;
                    }
                    case "boolean": {
                        String booleanValue = param2.getParamValue();
                        if ("true".equalsIgnoreCase(booleanValue) || "false".equalsIgnoreCase(booleanValue)) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " value " + booleanValue + " is invalid boolean value.");
                    }
                    case "radio": {
                        List<ParamDefine.Option> options = paramDefine.getOptions();
                        boolean invalid = true;
                        if (options != null) {
                            for (ParamDefine.Option option : options) {
                                if (!param2.getParamValue().equalsIgnoreCase(option.getValue())) continue;
                                invalid = false;
                                break;
                            }
                        }
                        if (!invalid) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " value " + param2.getParamValue() + " is invalid option value");
                    }
                    case "checkbox": {
                        List<ParamDefine.Option> checkboxOptions = paramDefine.getOptions();
                        boolean checkboxInvalid = true;
                        if (checkboxOptions != null) {
                            for (ParamDefine.Option option : checkboxOptions) {
                                if (!param2.getParamValue().equalsIgnoreCase(option.getValue())) continue;
                                checkboxInvalid = false;
                                break;
                            }
                        }
                        if (!checkboxInvalid) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " value " + param2.getParamValue() + " is invalid checkbox value");
                    }
                    case "metrics-field": 
                    case "key-value": {
                        if (JsonUtil.fromJson(param2.getParamValue(), new TypeReference<Object>(){}) != null) continue block27;
                        throw new IllegalArgumentException("Params field " + field + " value " + param2.getParamValue() + " is invalid key-value value");
                    }
                    case "array": {
                        String[] arrays = param2.getParamValue().split(",");
                        if (arrays.length == 0) {
                            throw new IllegalArgumentException("Param field" + field + " value " + param2.getParamValue() + " is invalid arrays value");
                        }
                        if (!param2.getParamValue().startsWith("[") || !param2.getParamValue().endsWith("]")) continue block27;
                        param2.setParamValue(param2.getParamValue().substring(1, param2.getParamValue().length() - 1));
                        continue block27;
                    }
                }
                throw new IllegalArgumentException("ParamDefine type " + paramDefine.getType() + " is invalid.");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyMonitor(Monitor monitor, List<Param> params, String collector, GrafanaDashboard grafanaDashboard) throws RuntimeException {
        boolean isStatic;
        List<Label> addLabels;
        long monitorId = monitor.getId();
        Optional queryOption = this.monitorDao.findById(monitorId);
        if (queryOption.isEmpty()) {
            throw new IllegalArgumentException("The Monitor " + monitorId + " not exists");
        }
        Monitor preMonitor = (Monitor)queryOption.get();
        if (!preMonitor.getApp().equals(monitor.getApp())) {
            throw new IllegalArgumentException("Can not modify monitor's app type");
        }
        Map<String, String> labels = monitor.getLabels();
        if (labels == null) {
            labels = new HashMap<String, String>(8);
            monitor.setLabels(labels);
        }
        if (!(addLabels = this.labelService.determineNewLabels(labels.entrySet())).isEmpty()) {
            this.labelDao.saveAll(addLabels);
        }
        boolean bl = isStatic = "static".equals(monitor.getScrape()) || !StringUtils.hasText(monitor.getScrape());
        if (preMonitor.getStatus() != 0) {
            String app = isStatic ? monitor.getApp() : monitor.getScrape();
            Job appDefine = this.appService.getAppDefine(app);
            if (!isStatic) {
                appDefine.setSd(true);
            }
            if ("prometheus".equals(monitor.getApp())) {
                appDefine.setApp("_prometheus_" + monitor.getName());
            }
            appDefine.setId(preMonitor.getJobId());
            appDefine.setMonitorId(monitorId);
            appDefine.setDefaultInterval(monitor.getIntervals().intValue());
            appDefine.setCyclic(true);
            appDefine.setTimestamp(System.currentTimeMillis());
            Map<String, String> metadata = Map.of("instancename", monitor.getName(), "instancehost", monitor.getHost());
            appDefine.setMetadata(metadata);
            appDefine.setLabels(monitor.getLabels());
            appDefine.setAnnotations(monitor.getAnnotations());
            List<Configmap> configmaps = params.stream().map(param -> new Configmap(param.getField(), param.getParamValue(), param.getType())).collect(Collectors.toList());
            appDefine.setConfigmap(configmaps);
            long newJobId = collector == null ? this.collectJobScheduling.updateAsyncCollectJob(appDefine) : this.collectJobScheduling.updateAsyncCollectJob(appDefine, collector);
            monitor.setJobId(newJobId);
            try {
                this.detectMonitor(monitor, params, collector);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.collectorMonitorBindDao.deleteCollectorMonitorBindsByMonitorId(monitorId);
            if (collector != null) {
                CollectorMonitorBind collectorMonitorBind = CollectorMonitorBind.builder().collector(collector).monitorId(monitorId).build();
                this.collectorMonitorBindDao.save(collectorMonitorBind);
            }
            monitor.setGmtUpdate(LocalDateTime.now());
            if (monitor.getApp().equals("prometheus") && grafanaDashboard != null) {
                if (grafanaDashboard.isEnabled()) {
                    this.dashboardService.createOrUpdateDashboard(grafanaDashboard.getTemplate(), monitorId);
                } else {
                    this.dashboardService.closeGrafanaDashboard(monitorId);
                }
            }
            this.monitorDao.save(monitor);
            this.paramDao.saveAll(params);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            this.collectJobScheduling.cancelAsyncCollectJob(monitor.getJobId());
            throw new MonitorDatabaseException(e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteMonitor(long id) throws RuntimeException {
        this.deleteMonitors(Sets.newHashSet(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteMonitors(Set<Long> ids) throws RuntimeException {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Set subMonitorIds = this.monitorBindDao.findMonitorBindsByBizIdIn(ids).stream().map(MonitorBind::getMonitorId).collect(Collectors.toSet());
        HashSet<Long> allMonitorIds = new HashSet<Long>(ids);
        allMonitorIds.addAll(subMonitorIds);
        List<Monitor> monitors = this.monitorDao.findMonitorsByIdIn(allMonitorIds);
        if (!monitors.isEmpty()) {
            this.monitorDao.deleteAll(monitors);
            this.paramDao.deleteParamsByMonitorIdIn(ids);
            Set<Long> monitorIds = monitors.stream().map(Monitor::getId).collect(Collectors.toSet());
            this.alertDefineBindDao.deleteAlertDefineMonitorBindsByMonitorIdIn(monitorIds);
            this.monitorBindDao.deleteMonitorBindByBizIdIn(monitorIds);
            for (Monitor monitor : monitors) {
                this.monitorBindDao.deleteByMonitorId(monitor.getId());
                this.collectorMonitorBindDao.deleteCollectorMonitorBindsByMonitorId(monitor.getId());
                this.collectJobScheduling.cancelAsyncCollectJob(monitor.getJobId());
                this.applicationContext.publishEvent(new MonitorDeletedEvent((Object)this.applicationContext, monitor.getId()));
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public MonitorDto getMonitorDto(long id) throws RuntimeException {
        Optional monitorOptional = this.monitorDao.findById(id);
        if (monitorOptional.isPresent()) {
            Monitor monitor = (Monitor)monitorOptional.get();
            MonitorDto monitorDto = new MonitorDto();
            List<Param> params = this.paramDao.findParamsByMonitorId(id);
            monitorDto.setParams(params);
            if ("prometheus".equalsIgnoreCase(monitor.getApp()) || monitor.getType() == 1) {
                List<CollectRep.MetricsData> metricsDataList = this.warehouseService.queryMonitorMetricsData(id);
                List<String> metrics = metricsDataList.stream().map(CollectRep.MetricsData::getMetrics).collect(Collectors.toList());
                monitorDto.setMetrics(metrics);
                monitorDto.setGrafanaDashboard(this.dashboardService.getDashboardByMonitorId(id));
            } else {
                boolean isStatic = "static".equals(monitor.getScrape()) || !StringUtils.hasText(monitor.getScrape());
                String type = isStatic ? monitor.getApp() : monitor.getScrape();
                Job job = this.appService.getAppDefine(type);
                List<String> metrics = job.getMetrics().stream().filter(Metrics::isVisible).map(Metrics::getName).collect(Collectors.toList());
                monitorDto.setMetrics(metrics);
            }
            monitorDto.setMonitor(monitor);
            Optional<CollectorMonitorBind> bindOptional = this.collectorMonitorBindDao.findCollectorMonitorBindByMonitorId(monitor.getId());
            bindOptional.ifPresent(bind -> monitorDto.setCollector(bind.getCollector()));
            return monitorDto;
        }
        return null;
    }

    @Override
    public Page<Monitor> getMonitors(List<Long> monitorIds, String app, String search, Byte status, String sort, String order, int pageIndex, int pageSize, String labels) {
        Specification specification = (root, query, criteriaBuilder) -> {
            ArrayList<Predicate> andList = new ArrayList<Predicate>();
            if (!CollectionUtils.isEmpty(monitorIds)) {
                CriteriaBuilder.In inPredicate = criteriaBuilder.in(root.get("id"));
                Iterator iterator = monitorIds.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    inPredicate.value(id);
                }
                andList.add(inPredicate);
            }
            if (StringUtils.hasText(app)) {
                Predicate predicateApp = criteriaBuilder.equal(root.get("app"), app);
                andList.add(predicateApp);
            }
            if (status != null && status >= 0 && status < 9) {
                Predicate predicateStatus = criteriaBuilder.equal(root.get("status"), status);
                andList.add(predicateStatus);
            }
            Predicate[] andPredicates = new Predicate[andList.size()];
            Predicate andPredicate = criteriaBuilder.and(andList.toArray(andPredicates));
            ArrayList<Predicate> orList = new ArrayList<Predicate>();
            if (StringUtils.hasText(search)) {
                Predicate predicateHost = criteriaBuilder.like(root.get("host"), "%" + search + "%");
                Predicate predicate = criteriaBuilder.like(criteriaBuilder.lower(root.get("name")), "%" + search.toLowerCase() + "%");
                if (CommonUtil.isNumeric(search)) {
                    Predicate predicateId = criteriaBuilder.equal(root.get("id"), Long.parseLong(search));
                    orList.add(predicateId);
                }
                orList.add(predicateHost);
                orList.add(predicate);
            }
            if (StringUtils.hasText(labels)) {
                String[] labelAres;
                for (String label : labelAres = labels.split(",")) {
                    String labelValue;
                    String[] labelArr = label.split(":");
                    String labelName = labelArr[0];
                    String string = labelValue = labelArr.length == 2 ? labelArr[1] : null;
                    if (labelValue == null) {
                        orList.add(criteriaBuilder.like(root.get("labels"), "%" + labelName + "%"));
                        continue;
                    }
                    String pattern = String.format("%%\"%s\":\"%s\"%%", labelName, labelValue);
                    orList.add(criteriaBuilder.like(root.get("labels"), pattern));
                }
            }
            Predicate[] orPredicates = new Predicate[orList.size()];
            Predicate predicate = criteriaBuilder.or(orList.toArray(orPredicates));
            if (andPredicates.length == 0 && orPredicates.length == 0) {
                return query.where(new Predicate[0]).getRestriction();
            }
            if (andPredicates.length == 0) {
                return predicate;
            }
            if (orPredicates.length == 0) {
                return andPredicate;
            }
            return query.where(new Predicate[]{andPredicate, predicate}).getRestriction();
        };
        Sort sortExp = Sort.by(new Sort.Order(Sort.Direction.fromString(order), sort));
        PageRequest pageRequest = PageRequest.of(pageIndex, pageSize, sortExp);
        return this.monitorDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public void cancelManageMonitors(Set<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Set subMonitorIds = this.monitorBindDao.findMonitorBindsByBizIdIn(ids).stream().map(MonitorBind::getMonitorId).collect(Collectors.toSet());
        ids.addAll(subMonitorIds);
        List managedMonitors = this.monitorDao.findMonitorsByIdIn(ids).stream().filter(monitor -> monitor.getStatus() != 0).peek(monitor -> monitor.setStatus((byte)0)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(managedMonitors)) {
            for (Monitor monitor2 : managedMonitors) {
                this.collectJobScheduling.cancelAsyncCollectJob(monitor2.getJobId());
            }
            this.monitorDao.saveAll((Iterable)managedMonitors);
        }
    }

    @Override
    public void enableManageMonitors(Set<Long> ids) {
        Set subMonitorIds = this.monitorBindDao.findMonitorBindsByBizIdIn(ids).stream().map(MonitorBind::getMonitorId).collect(Collectors.toSet());
        ids.addAll(subMonitorIds);
        List unManagedMonitors = this.monitorDao.findMonitorsByIdIn(ids).stream().filter(monitor -> monitor.getStatus() == 0).peek(monitor -> monitor.setStatus((byte)1)).collect(Collectors.toList());
        if (unManagedMonitors.isEmpty()) {
            return;
        }
        for (Monitor monitor2 : unManagedMonitors) {
            List<Param> params = this.paramDao.findParamsByMonitorId(monitor2.getId());
            boolean isStatic = "static".equals(monitor2.getScrape()) || !StringUtils.hasText(monitor2.getScrape());
            String app = isStatic ? monitor2.getApp() : monitor2.getScrape();
            Job appDefine = this.appService.getAppDefine(app);
            if (!isStatic) {
                appDefine.setSd(true);
            }
            if ("prometheus".equals(monitor2.getApp())) {
                appDefine.setApp("_prometheus_" + monitor2.getName());
            }
            appDefine.setMonitorId(monitor2.getId());
            appDefine.setDefaultInterval(monitor2.getIntervals().intValue());
            appDefine.setCyclic(true);
            appDefine.setTimestamp(System.currentTimeMillis());
            Map<String, String> metadata = Map.of("instancename", monitor2.getName(), "instancehost", monitor2.getHost());
            appDefine.setMetadata(metadata);
            appDefine.setLabels(monitor2.getLabels());
            appDefine.setAnnotations(monitor2.getAnnotations());
            List<Configmap> configmaps = params.stream().map(param -> new Configmap(param.getField(), param.getParamValue(), param.getType())).collect(Collectors.toList());
            List<ParamDefine> paramDefaultValue = appDefine.getParams().stream().filter(item -> StringUtils.hasText(item.getDefaultValue())).toList();
            paramDefaultValue.forEach(defaultVar -> {
                if (configmaps.stream().noneMatch(item -> item.getKey().equals(defaultVar.getField()))) {
                    Configmap configmap = new Configmap(defaultVar.getField(), defaultVar.getDefaultValue(), 1);
                    configmaps.add(configmap);
                }
            });
            appDefine.setConfigmap(configmaps);
            Optional<CollectorMonitorBind> bindOptional = this.collectorMonitorBindDao.findCollectorMonitorBindByMonitorId(monitor2.getId());
            String collector = bindOptional.map(CollectorMonitorBind::getCollector).orElse(null);
            long newJobId = this.collectJobScheduling.addAsyncCollectJob(appDefine, collector);
            monitor2.setJobId(newJobId);
            this.applicationContext.publishEvent(new MonitorDeletedEvent((Object)this.applicationContext, monitor2.getId()));
            try {
                this.detectMonitor(monitor2, params, collector);
            }
            catch (Exception exception) {}
        }
        this.monitorDao.saveAll((Iterable)unManagedMonitors);
    }

    @Override
    public List<AppCount> getAllAppMonitorsCount() {
        List<AppCount> appCounts = this.monitorDao.findAppsStatusCount();
        if (CollectionUtils.isEmpty(appCounts)) {
            return null;
        }
        HashMap<String, AppCount> appCountMap = new HashMap<String, AppCount>(appCounts.size());
        for (AppCount item2 : appCounts) {
            AppCount appCount = appCountMap.getOrDefault(item2.getApp(), new AppCount());
            appCount.setApp(item2.getApp());
            switch (item2.getStatus()) {
                case 1: {
                    appCount.setAvailableSize(appCount.getAvailableSize() + item2.getSize());
                    break;
                }
                case 2: {
                    appCount.setUnAvailableSize(appCount.getUnAvailableSize() + item2.getSize());
                    break;
                }
                case 0: {
                    appCount.setUnManageSize(appCount.getUnManageSize() + item2.getSize());
                    break;
                }
            }
            appCountMap.put(item2.getApp(), appCount);
        }
        return appCountMap.values().stream().map(item -> {
            item.setSize(item.getAvailableSize() + item.getUnManageSize() + item.getUnAvailableSize());
            try {
                Job job = this.appService.getAppDefine(item.getApp());
                item.setCategory(job.getCategory());
            }
            catch (Exception ignored) {
                return null;
            }
            return item;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void updateAppCollectJob(Job job) {
        List<Monitor> monitors = this.monitorDao.findMonitorsByAppEquals(job.getApp()).stream().filter(monitor -> monitor.getStatus() != 0).toList();
        if (monitors.isEmpty()) {
            return;
        }
        List<CollectorMonitorBind> monitorBinds = this.collectorMonitorBindDao.findCollectorMonitorBindsByMonitorIdIn(monitors.stream().map(Monitor::getId).collect(Collectors.toSet()));
        Map<Long, String> monitorIdCollectorMap = monitorBinds.stream().collect(Collectors.toMap(CollectorMonitorBind::getMonitorId, CollectorMonitorBind::getCollector));
        for (Monitor monitor2 : monitors) {
            try {
                Job appDefine = job.clone();
                if (monitor2 == null || appDefine == null || monitor2.getId() == null || monitor2.getJobId() == null) {
                    log.error("update monitor job error when template modify, define | id | jobId is null. continue");
                    continue;
                }
                if ("prometheus".equals(monitor2.getApp())) {
                    appDefine.setApp("_prometheus_" + monitor2.getName());
                }
                appDefine.setId(monitor2.getJobId());
                appDefine.setMonitorId(monitor2.getId());
                appDefine.setDefaultInterval(monitor2.getIntervals().intValue());
                appDefine.setCyclic(true);
                appDefine.setTimestamp(System.currentTimeMillis());
                Map<String, String> metadata = Map.of("instancename", monitor2.getName(), "instancehost", monitor2.getHost());
                appDefine.setMetadata(metadata);
                appDefine.setLabels(monitor2.getLabels());
                appDefine.setAnnotations(monitor2.getAnnotations());
                List<Param> params = this.paramDao.findParamsByMonitorId(monitor2.getId());
                List<Configmap> configmaps = params.stream().map(param -> new Configmap(param.getField(), param.getParamValue(), param.getType())).collect(Collectors.toList());
                List<ParamDefine> paramDefaultValue = appDefine.getParams().stream().filter(item -> StringUtils.hasText(item.getDefaultValue())).toList();
                paramDefaultValue.forEach(defaultVar -> {
                    if (configmaps.stream().noneMatch(item -> item.getKey().equals(defaultVar.getField()))) {
                        Configmap configmap = new Configmap(defaultVar.getField(), defaultVar.getDefaultValue(), 1);
                        configmaps.add(configmap);
                    }
                });
                appDefine.setConfigmap(configmaps);
                String collector = monitorIdCollectorMap.get(monitor2.getId());
                long newJobId = this.collectJobScheduling.updateAsyncCollectJob(appDefine, collector);
                monitor2.setJobId(newJobId);
                this.monitorDao.save(monitor2);
            }
            catch (Exception e) {
                log.error("update monitor job error when template modify: {}.continue", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Override
    public Monitor getMonitor(Long monitorId) {
        return this.monitorDao.findById(monitorId).orElse(null);
    }

    @Override
    public void updateMonitorStatus(Long monitorId, byte status) {
        this.monitorDao.updateMonitorStatus(monitorId, status);
    }

    @Override
    public List<Monitor> getAppMonitors(String app) {
        return this.monitorDao.findMonitorsByAppEquals(app);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyMonitor(Long id) {
        Optional monitorOptional = this.monitorDao.findById(id);
        if (monitorOptional.isEmpty()) {
            throw new IllegalArgumentException("Monitor not found: " + id);
        }
        Monitor sourceMonitor = (Monitor)monitorOptional.get();
        List<Param> sourceParams = this.paramDao.findParamsByMonitorId(id);
        Monitor newMonitor = new Monitor();
        BeanUtils.copyProperties((Object)sourceMonitor, (Object)newMonitor, "id", "jobId", "status");
        newMonitor.setName(sourceMonitor.getName() + "_copy");
        newMonitor.setStatus((byte)1);
        newMonitor.setGmtCreate(LocalDateTime.now());
        newMonitor.setGmtUpdate(LocalDateTime.now());
        ArrayList<Param> newParams = new ArrayList<Param>();
        if (!sourceParams.isEmpty()) {
            for (Param sourceParam : sourceParams) {
                Param newParam = new Param();
                BeanUtils.copyProperties((Object)sourceParam, (Object)newParam, "id");
                newParam.setMonitorId(newMonitor.getId());
                newParams.add(newParam);
            }
        }
        this.addMonitor(newMonitor, newParams, null, null);
    }

    private void detectSdMonitor(Monitor monitor, List<Param> params, String collector) {
        Long monitorId = monitor.getId();
        if (monitorId == null || monitorId == 0L) {
            monitorId = MONITOR_ID_TMP;
        }
        if (monitor.getScrape() == null || params == null || params.isEmpty()) {
            throw new IllegalArgumentException("scrape params is null or empty!");
        }
        Job appDefine = this.appService.getAppDefine(monitor.getScrape());
        appDefine.setMonitorId(monitorId);
        appDefine.setCyclic(false);
        appDefine.setTimestamp(System.currentTimeMillis());
        Map<String, String> metadata = Map.of("instancename", monitor.getName());
        appDefine.setMetadata(metadata);
        appDefine.setLabels(monitor.getLabels());
        appDefine.setAnnotations(monitor.getAnnotations());
        List<Configmap> configmaps = params.stream().map(param -> new Configmap(param.getField(), param.getParamValue(), param.getType())).collect(Collectors.toList());
        appDefine.setConfigmap(configmaps);
        appDefine.setSd(true);
        List<CollectRep.MetricsData> collectRep = collector != null ? this.collectJobScheduling.collectSyncJobData(appDefine, collector) : this.collectJobScheduling.collectSyncJobData(appDefine);
        monitor.setStatus((byte)1);
        if (collectRep == null || collectRep.isEmpty()) {
            monitor.setStatus((byte)2);
            throw new MonitorDetectException("Collect Timeout No Response");
        }
        if (collectRep.get(0).getCode() != CollectRep.Code.SUCCESS) {
            monitor.setStatus((byte)2);
            throw new MonitorDetectException(collectRep.get(0).getMsg());
        }
        collectRep.forEach(CollectRep.MetricsData::close);
    }

    private void detectMonitorDirectly(Monitor monitor, List<Param> params, String collector) {
        Long monitorId = monitor.getId();
        if (monitorId == null || monitorId == 0L) {
            monitorId = MONITOR_ID_TMP;
        }
        Job appDefine = this.appService.getAppDefine(monitor.getApp());
        if ("prometheus".equals(monitor.getApp())) {
            appDefine.setApp("_prometheus_" + monitor.getName());
        }
        appDefine.setMonitorId(monitorId);
        appDefine.setCyclic(false);
        appDefine.setTimestamp(System.currentTimeMillis());
        Map<String, String> metadata = Map.of("instancename", monitor.getName(), "instancehost", monitor.getHost());
        appDefine.setMetadata(metadata);
        appDefine.setLabels(monitor.getLabels());
        appDefine.setAnnotations(monitor.getAnnotations());
        List<Configmap> configmaps = params.stream().map(param -> new Configmap(param.getField(), param.getParamValue(), param.getType())).collect(Collectors.toList());
        appDefine.setConfigmap(configmaps);
        List<Metrics> availableMetrics = appDefine.getMetrics().stream().filter(item -> item.getPriority() == 0).collect(Collectors.toList());
        appDefine.setMetrics(availableMetrics);
        List<CollectRep.MetricsData> collectRep = collector != null ? this.collectJobScheduling.collectSyncJobData(appDefine, collector) : this.collectJobScheduling.collectSyncJobData(appDefine);
        monitor.setStatus((byte)1);
        if (collectRep == null || collectRep.isEmpty()) {
            monitor.setStatus((byte)2);
            throw new MonitorDetectException("Collect Timeout No Response");
        }
        if (collectRep.get(0).getCode() != CollectRep.Code.SUCCESS) {
            monitor.setStatus((byte)2);
            throw new MonitorDetectException(collectRep.get(0).getMsg());
        }
        collectRep.forEach(CollectRep.MetricsData::close);
    }
}

