/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

import io.greptime.common.util.Ensures;
import io.greptime.common.util.LogScheduledThreadPoolExecutor;
import io.greptime.common.util.LogThreadPoolExecutor;
import io.greptime.common.util.MetricScheduledThreadPoolExecutor;
import io.greptime.common.util.MetricThreadPoolExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadPoolUtil {
    private static final RejectedExecutionHandler defaultHandler = new ThreadPoolExecutor.AbortPolicy();

    public static PoolBuilder newBuilder() {
        return new PoolBuilder();
    }

    public static ScheduledPoolBuilder newScheduledBuilder() {
        return new ScheduledPoolBuilder();
    }

    public static ThreadPoolExecutor newThreadPool(String poolName, boolean enableMetric, int coreThreads, int maximumThreads, long keepAliveSeconds, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedHandler) {
        TimeUnit unit = TimeUnit.SECONDS;
        if (enableMetric) {
            return new MetricThreadPoolExecutor(coreThreads, maximumThreads, keepAliveSeconds, unit, workQueue, threadFactory, rejectedHandler, poolName);
        }
        return new LogThreadPoolExecutor(coreThreads, maximumThreads, keepAliveSeconds, unit, workQueue, threadFactory, rejectedHandler, poolName);
    }

    public static ScheduledThreadPoolExecutor newScheduledThreadPool(String poolName, boolean enableMetric, int coreThreads, ThreadFactory threadFactory, RejectedExecutionHandler rejectedHandler) {
        if (enableMetric) {
            return new MetricScheduledThreadPoolExecutor(coreThreads, threadFactory, rejectedHandler, poolName);
        }
        return new LogScheduledThreadPoolExecutor(coreThreads, threadFactory, rejectedHandler, poolName);
    }

    private ThreadPoolUtil() {
    }

    static /* synthetic */ RejectedExecutionHandler access$000() {
        return defaultHandler;
    }

    public static class ScheduledPoolBuilder {
        private String poolName;
        private Boolean enableMetric;
        private Integer coreThreads;
        private ThreadFactory threadFactory;
        private RejectedExecutionHandler handler = ThreadPoolUtil.access$000();

        public ScheduledPoolBuilder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public ScheduledPoolBuilder enableMetric(Boolean enableMetric) {
            this.enableMetric = enableMetric;
            return this;
        }

        public ScheduledPoolBuilder coreThreads(Integer coreThreads) {
            this.coreThreads = coreThreads;
            return this;
        }

        public ScheduledPoolBuilder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public ScheduledPoolBuilder rejectedHandler(RejectedExecutionHandler handler) {
            this.handler = handler;
            return this;
        }

        public ScheduledThreadPoolExecutor build() {
            Ensures.ensureNonNull(this.poolName, "null `poolName`");
            Ensures.ensureNonNull(this.enableMetric, "null `enableMetric`");
            Ensures.ensureNonNull(this.coreThreads, "null `coreThreads`");
            Ensures.ensureNonNull(this.threadFactory, "null `threadFactory`");
            Ensures.ensureNonNull(this.handler, "null `handler`");
            return ThreadPoolUtil.newScheduledThreadPool(this.poolName, this.enableMetric, this.coreThreads, this.threadFactory, this.handler);
        }
    }

    public static class PoolBuilder {
        private String poolName;
        private Boolean enableMetric;
        private Integer coreThreads;
        private Integer maximumThreads;
        private Long keepAliveSeconds;
        private BlockingQueue<Runnable> workQueue;
        private ThreadFactory threadFactory;
        private RejectedExecutionHandler handler = ThreadPoolUtil.access$000();

        public PoolBuilder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public PoolBuilder enableMetric(Boolean enableMetric) {
            this.enableMetric = enableMetric;
            return this;
        }

        public PoolBuilder coreThreads(Integer coreThreads) {
            this.coreThreads = coreThreads;
            return this;
        }

        public PoolBuilder maximumThreads(Integer maximumThreads) {
            this.maximumThreads = maximumThreads;
            return this;
        }

        public PoolBuilder keepAliveSeconds(Long keepAliveSeconds) {
            this.keepAliveSeconds = keepAliveSeconds;
            return this;
        }

        public PoolBuilder workQueue(BlockingQueue<Runnable> workQueue) {
            this.workQueue = workQueue;
            return this;
        }

        public PoolBuilder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public PoolBuilder rejectedHandler(RejectedExecutionHandler handler) {
            this.handler = handler;
            return this;
        }

        public ThreadPoolExecutor build() {
            Ensures.ensureNonNull(this.poolName, "null `poolName`");
            Ensures.ensureNonNull(this.enableMetric, "null `enableMetric`");
            Ensures.ensureNonNull(this.coreThreads, "null `coreThreads`");
            Ensures.ensureNonNull(this.maximumThreads, "null `maximumThreads`");
            Ensures.ensureNonNull(this.keepAliveSeconds, "null `keepAliveSeconds`");
            Ensures.ensureNonNull(this.workQueue, "null `workQueue`");
            Ensures.ensureNonNull(this.threadFactory, "null `threadFactory`");
            Ensures.ensureNonNull(this.handler, "null `handler`");
            return ThreadPoolUtil.newThreadPool(this.poolName, this.enableMetric, this.coreThreads, this.maximumThreads, this.keepAliveSeconds, this.workQueue, this.threadFactory, this.handler);
        }
    }
}

