/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.otel.config;

import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ServiceAttributes;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.warehouse.store.history.tsdb.greptime.GreptimeProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OpenTelemetryConfig {
    private static final Logger log = LoggerFactory.getLogger(OpenTelemetryConfig.class);
    private static final String HERTZBEAT_SERVICE_NAME = "HertzBeat";
    private static final String DEFAULT_GREPTIME_DB_NAME = "public";
    private static final String DEFAULT_LOGS_TABLE_NAME = "hzb_logs";
    private static final String DEFAULT_TRACES_TABLE_NAME = "hzb_traces";
    private static final String GREPTIME_DB_NAME_HEADER = "X-Greptime-DB-Name";
    private static final String GREPTIME_LOG_TABLE_NAME_HEADER = "X-Greptime-Log-Table-Name";
    private static final String GREPTIME_TRACE_TABLE_NAME_HEADER = "X-Greptime-Trace-Table-Name";
    private static final String GREPTIME_PIPELINE_NAME_HEADER = "X-Greptime-Pipeline-Name";

    private void addAuthenticationHeaders(Map<String, String> headers, GreptimeProperties greptimeProps) {
        if (greptimeProps != null && StringUtils.isNotBlank((CharSequence)greptimeProps.username()) && StringUtils.isNotBlank((CharSequence)greptimeProps.password())) {
            String credentials = greptimeProps.username() + ":" + greptimeProps.password();
            String encodedCredentials = Base64.getEncoder().encodeToString(credentials.getBytes());
            headers.put("Authorization", "Basic " + encodedCredentials);
            log.debug("Added Basic Authentication header for GreptimeDB.");
        } else {
            log.debug("GreptimeDB username/password not configured, skipping Authentication header.");
        }
    }

    private Map<String, String> buildGreptimeOtlpLogHeaders(GreptimeProperties greptimeProps) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(GREPTIME_DB_NAME_HEADER, DEFAULT_GREPTIME_DB_NAME);
        headers.put(GREPTIME_LOG_TABLE_NAME_HEADER, DEFAULT_LOGS_TABLE_NAME);
        this.addAuthenticationHeaders(headers, greptimeProps);
        return Collections.unmodifiableMap(headers);
    }

    private Map<String, String> buildGreptimeOtlpTraceHeaders(GreptimeProperties greptimeProps) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(GREPTIME_DB_NAME_HEADER, DEFAULT_GREPTIME_DB_NAME);
        headers.put(GREPTIME_TRACE_TABLE_NAME_HEADER, DEFAULT_TRACES_TABLE_NAME);
        headers.put("Content-Type", "application/x-protobuf");
        headers.put(GREPTIME_PIPELINE_NAME_HEADER, "greptime_trace_v1");
        this.addAuthenticationHeaders(headers, greptimeProps);
        return Collections.unmodifiableMap(headers);
    }

    @Bean
    public AutoConfigurationCustomizerProvider defaultOtelCustomizer() {
        log.info("Applying default OpenTelemetry SDK customizations.");
        return providerCustomizer -> providerCustomizer.addPropertiesCustomizer(sdkConfigProperties -> {
            HashMap<String, String> newProperties = new HashMap<String, String>();
            newProperties.put("otel.metrics.exporter", "none");
            newProperties.put("otel.traces.exporter", "none");
            newProperties.put("otel.logs.exporter", "none");
            return newProperties;
        }).addResourceCustomizer((resource, configProperties) -> {
            log.info("Customizing auto-configured OpenTelemetry Resource with service name: {}.", (Object)HERTZBEAT_SERVICE_NAME);
            return resource.merge(Resource.builder().put(ServiceAttributes.SERVICE_NAME, (Object)HERTZBEAT_SERVICE_NAME).build());
        });
    }

    @Bean
    @ConditionalOnProperty(name={"warehouse.store.greptime.enabled"}, havingValue="true")
    public AutoConfigurationCustomizerProvider greptimeOtelCustomizer(GreptimeProperties greptimeProperties) {
        log.info("GreptimeDB is enabled. Applying additional OpenTelemetry SDK customizations for GrepTimeDB.");
        return providerCustomizer -> providerCustomizer.addPropertiesCustomizer(sdkConfigProperties -> {
            HashMap<String, String> newProperties = new HashMap<String, String>();
            newProperties.put("otel.traces.exporter", "otlp");
            return newProperties;
        }).addSpanExporterCustomizer((originalSpanExporter, configProperties) -> {
            String traceEndpoint = greptimeProperties.httpEndpoint() + "/v1/otlp/v1/traces";
            log.info("Programmatically configuring OtlpHttpSpanExporter for GreptimeDB traces. Endpoint: {}", (Object)traceEndpoint);
            Map<String, String> traceHeaders = this.buildGreptimeOtlpTraceHeaders(greptimeProperties);
            log.info("Trace Headers for GreptimeDB (programmatic HTTP config): {}", traceHeaders);
            OtlpHttpSpanExporterBuilder httpExporterBuilder = OtlpHttpSpanExporter.builder().setEndpoint(traceEndpoint).setHeaders(() -> traceHeaders).setTimeout(10000L, TimeUnit.MILLISECONDS);
            return httpExporterBuilder.build();
        }).addLoggerProviderCustomizer((sdkLoggerProviderBuilder, configProperties) -> {
            log.info("Customizing auto-configured SdkLoggerProviderBuilder for GrepTimeDB logs.");
            OtlpHttpLogRecordExporter logExporter = OtlpHttpLogRecordExporter.builder().setEndpoint(greptimeProperties.httpEndpoint() + "/v1/otlp/v1/logs").setHeaders(() -> this.buildGreptimeOtlpLogHeaders(greptimeProperties)).setTimeout(10000L, TimeUnit.MILLISECONDS).build();
            BatchLogRecordProcessor batchLogProcessor = BatchLogRecordProcessor.builder((LogRecordExporter)logExporter).setScheduleDelay(1000L, TimeUnit.MILLISECONDS).setMaxExportBatchSize(512).build();
            return sdkLoggerProviderBuilder.addLogRecordProcessor((LogRecordProcessor)batchLogProcessor);
        });
    }
}

