/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.azure.resource;

import io.opentelemetry.contrib.azure.resource.AzureMetadataService;
import io.opentelemetry.contrib.azure.resource.AzureVmResourceProvider;
import io.opentelemetry.contrib.azure.resource.CloudResourceProvider;
import io.opentelemetry.contrib.azure.resource.IncubatingAttributes;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class AzureAksResourceProvider
extends CloudResourceProvider {
    private static final Map<String, AzureVmResourceProvider.Entry> COMPUTE_MAPPING = new HashMap<String, AzureVmResourceProvider.Entry>();
    static final String KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    private final Supplier<Optional<String>> client;
    private final Map<String, String> environment;

    static String parseClusterName(String resourceGroup) {
        String[] splitAll = resourceGroup.split("_");
        if (splitAll.length == 4 && splitAll[0].equalsIgnoreCase("mc")) {
            return splitAll[splitAll.length - 2];
        }
        return resourceGroup;
    }

    public AzureAksResourceProvider() {
        this(AzureMetadataService.defaultClient(), System.getenv());
    }

    AzureAksResourceProvider(Supplier<Optional<String>> client, Map<String, String> environment) {
        this.client = client;
        this.environment = environment;
    }

    public int order() {
        return 100;
    }

    public Resource createResource(ConfigProperties configProperties) {
        if (this.environment.get(KUBERNETES_SERVICE_HOST) == null) {
            return Resource.empty();
        }
        return this.client.get().map(body -> AzureVmResourceProvider.parseMetadata(body, COMPUTE_MAPPING, "azure_aks")).orElse(Resource.empty());
    }

    static {
        COMPUTE_MAPPING.put("resourceGroupName", new AzureVmResourceProvider.Entry(IncubatingAttributes.K8S_CLUSTER_NAME, AzureAksResourceProvider::parseClusterName));
    }
}

