/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.net.http.HttpClient;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.net.ssl.SSLParameters;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.AbstractClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.http.client.JdkClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JdkClientHttpRequestFactoryBuilder
extends AbstractClientHttpRequestFactoryBuilder<JdkClientHttpRequestFactory> {
    private final Consumer<HttpClient.Builder> httpClientCustomizer;

    JdkClientHttpRequestFactoryBuilder() {
        this(null, JdkClientHttpRequestFactoryBuilder.emptyCustomizer());
    }

    private JdkClientHttpRequestFactoryBuilder(List<Consumer<JdkClientHttpRequestFactory>> customizers, Consumer<HttpClient.Builder> httpClientCustomizer) {
        super(customizers);
        this.httpClientCustomizer = httpClientCustomizer;
    }

    public JdkClientHttpRequestFactoryBuilder withCustomizer(Consumer<JdkClientHttpRequestFactory> customizer) {
        return new JdkClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizer), this.httpClientCustomizer);
    }

    public JdkClientHttpRequestFactoryBuilder withCustomizers(Collection<Consumer<JdkClientHttpRequestFactory>> customizers) {
        return new JdkClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizers), this.httpClientCustomizer);
    }

    public JdkClientHttpRequestFactoryBuilder withHttpClientCustomizer(Consumer<HttpClient.Builder> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, (String)"'httpClientCustomizer' must not be null");
        return new JdkClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientCustomizer.andThen(httpClientCustomizer));
    }

    @Override
    protected JdkClientHttpRequestFactory createClientHttpRequestFactory(ClientHttpRequestFactorySettings settings) {
        HttpClient httpClient = this.createHttpClient(settings);
        JdkClientHttpRequestFactory requestFactory = new JdkClientHttpRequestFactory(httpClient);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::readTimeout).to(arg_0 -> ((JdkClientHttpRequestFactory)requestFactory).setReadTimeout(arg_0));
        return requestFactory;
    }

    private HttpClient createHttpClient(ClientHttpRequestFactorySettings settings) {
        HttpClient.Builder builder = HttpClient.newBuilder();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::connectTimeout).to(builder::connectTimeout);
        map.from(settings::sslBundle).as(SslBundle::createSslContext).to(builder::sslContext);
        map.from(settings::sslBundle).as(this::asSslParameters).to(builder::sslParameters);
        map.from(settings::redirects).as(this::asHttpClientRedirect).to(builder::followRedirects);
        this.httpClientCustomizer.accept(builder);
        return builder.build();
    }

    private SSLParameters asSslParameters(SslBundle sslBundle) {
        SslOptions options = sslBundle.getOptions();
        SSLParameters parameters = new SSLParameters();
        parameters.setCipherSuites(options.getCiphers());
        parameters.setProtocols(options.getEnabledProtocols());
        return parameters;
    }

    private HttpClient.Redirect asHttpClientRedirect(ClientHttpRequestFactorySettings.Redirects redirects) {
        return switch (redirects) {
            default -> throw new IncompatibleClassChangeError();
            case ClientHttpRequestFactorySettings.Redirects.FOLLOW_WHEN_POSSIBLE, ClientHttpRequestFactorySettings.Redirects.FOLLOW -> HttpClient.Redirect.NORMAL;
            case ClientHttpRequestFactorySettings.Redirects.DONT_FOLLOW -> HttpClient.Redirect.NEVER;
        };
    }

    static class Classes {
        static final String HTTP_CLIENT = "java.net.http.HttpClient";
        static final boolean PRESENT = ClassUtils.isPresent((String)"java.net.http.HttpClient", null);

        Classes() {
        }
    }
}

