/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.jpa.repository.query.HqlParser;
import org.springframework.data.jpa.repository.query.HqlQueryRenderer;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.jpa.repository.query.QueryTransformers;
import org.springframework.lang.Nullable;

class HqlCountQueryTransformer
extends HqlQueryRenderer {
    @Nullable
    private final String countProjection;
    @Nullable
    private final String primaryFromAlias;
    private boolean containsCTE = false;

    HqlCountQueryTransformer(@Nullable String countProjection, @Nullable String primaryFromAlias) {
        this.countProjection = countProjection;
        this.primaryFromAlias = primaryFromAlias;
    }

    @Override
    public QueryRenderer.QueryRendererBuilder visitOrderedQuery(HqlParser.OrderedQueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.query() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.query()));
        } else if (ctx.queryExpression() != null) {
            QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
            nested.append(QueryTokens.TOKEN_OPEN_PAREN);
            nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.queryExpression()));
            nested.append(QueryTokens.TOKEN_CLOSE_PAREN);
            builder.appendExpression(nested);
        }
        if (ctx.queryOrder() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.queryOrder()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCte(HqlParser.CteContext ctx) {
        this.containsCTE = true;
        return super.visitCte(ctx);
    }

    @Override
    public QueryRenderer.QueryRendererBuilder visitFromQuery(HqlParser.FromQueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (!HqlCountQueryTransformer.isSubquery(ctx) && ctx.selectClause() == null) {
            QueryRenderer.QueryRendererBuilder countBuilder = QueryRenderer.builder();
            countBuilder.append(QueryTokens.TOKEN_SELECT_COUNT);
            if (this.countProjection != null) {
                countBuilder.append(QueryTokens.token(this.countProjection));
            } else if (this.primaryFromAlias == null) {
                countBuilder.append(QueryTokens.TOKEN_DOUBLE_UNDERSCORE);
            } else {
                countBuilder.append(QueryTokens.token(this.primaryFromAlias));
            }
            countBuilder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            builder.appendExpression(countBuilder);
        }
        if (ctx.fromClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.fromClause()));
        }
        if (ctx.whereClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.whereClause()));
        }
        if (ctx.groupByClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (ctx.havingClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.havingClause()));
        }
        if (ctx.selectClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.selectClause()));
        }
        return builder;
    }

    @Override
    public QueryRenderer.QueryRendererBuilder visitFromRoot(HqlParser.FromRootContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.entityName() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entityName()));
            if (ctx.variable() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
            }
        } else if (ctx.subquery() != null) {
            if (ctx.LATERAL() != null) {
                builder.append(QueryTokens.expression(ctx.LATERAL()));
            }
            QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
            nested.append(QueryTokens.TOKEN_OPEN_PAREN);
            nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            nested.append(QueryTokens.TOKEN_CLOSE_PAREN);
            builder.appendExpression(nested);
            if (ctx.variable() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
            }
        }
        return builder;
    }

    @Override
    public QueryRenderer.QueryRendererBuilder visitJoin(HqlParser.JoinContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.joinType()));
        builder.append(QueryTokens.expression(ctx.JOIN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.joinTarget()));
        if (ctx.joinRestriction() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.joinRestriction()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelectClause(HqlParser.SelectClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SELECT()));
        if (HqlCountQueryTransformer.isSubquery(ctx)) {
            return this.visitSubQuerySelectClause(ctx, builder);
        }
        builder.append(QueryTokens.TOKEN_COUNT_FUNC);
        boolean usesDistinct = ctx.DISTINCT() != null;
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        if (this.countProjection == null) {
            QueryTokenStream selection = (QueryTokenStream)this.visit((ParseTree)ctx.selectionList());
            if (usesDistinct) {
                nested.append(QueryTokens.expression(ctx.DISTINCT()));
                nested.append(this.getDistinctCountSelection(selection));
            } else if (this.containsCTE) {
                nested.append(QueryTokens.token("*"));
            } else if (selection.size() == 1) {
                nested.append(selection);
            } else if (this.primaryFromAlias != null) {
                nested.append(QueryTokens.token(this.primaryFromAlias));
            } else {
                nested.append(QueryTokens.token("*"));
            }
        } else {
            builder.append(QueryTokens.token(this.countProjection));
            if (usesDistinct) {
                nested.append(QueryTokens.expression(ctx.DISTINCT()));
            }
        }
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitSelection(HqlParser.SelectionContext ctx) {
        if (HqlCountQueryTransformer.isSubquery(ctx)) {
            return super.visitSelection(ctx);
        }
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.selectExpression()));
        return builder;
    }

    @Override
    public QueryRenderer.QueryRendererBuilder visitQueryOrder(HqlParser.QueryOrderContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.limitClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.limitClause()));
        }
        if (ctx.offsetClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.offsetClause()));
        }
        if (ctx.fetchClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.fetchClause()));
        }
        return builder;
    }

    private QueryRenderer.QueryRendererBuilder visitSubQuerySelectClause(HqlParser.SelectClauseContext ctx, QueryRenderer.QueryRendererBuilder builder) {
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.selectionList()));
        return builder;
    }

    private QueryRenderer.QueryRendererBuilder getDistinctCountSelection(QueryTokenStream selectionListbuilder) {
        QueryRenderer.QueryRendererBuilder nested = new QueryRenderer.QueryRendererBuilder();
        QueryTransformers.CountSelectionTokenStream countSelection = QueryTransformers.CountSelectionTokenStream.create(selectionListbuilder);
        if (countSelection.requiresPrimaryAlias()) {
            if (this.primaryFromAlias != null) {
                nested.append(QueryTokens.token(this.primaryFromAlias));
            } else {
                nested.append(countSelection.withoutConstructorExpression());
            }
        } else {
            nested.append(selectionListbuilder);
        }
        return nested;
    }
}

