/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbPooledConnection$1;
import dm.jdbc.driver.DmdbPooledConnection$2;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class DmdbPooledConnection
implements PooledConnection {
    private List connectionEventListeners = new ArrayList(2);
    private List statementEventListeners = new ArrayList(2);
    protected Connection connection;
    private Connection logicConnection;

    public DmdbPooledConnection(Connection connection) {
        this.connection = connection;
        this.logicConnection = this.createConnectionProxy(connection);
    }

    @Override
    public Connection getConnection() {
        return this.logicConnection;
    }

    @Override
    public synchronized void close() {
        this.connection.close();
        this.connection = null;
        this.logicConnection = null;
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.connectionEventListeners.add(connectionEventListener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.connectionEventListeners.remove(connectionEventListener);
    }

    @Override
    public synchronized void addStatementEventListener(StatementEventListener statementEventListener) {
        this.statementEventListeners.add(statementEventListener);
    }

    @Override
    public synchronized void removeStatementEventListener(StatementEventListener statementEventListener) {
        this.statementEventListeners.remove(statementEventListener);
    }

    private synchronized void fireConnectionEvent(boolean bl, SQLException sQLException) {
        for (ConnectionEventListener connectionEventListener : this.connectionEventListeners) {
            if (bl) {
                connectionEventListener.connectionClosed(new ConnectionEvent(this, sQLException));
                continue;
            }
            connectionEventListener.connectionErrorOccurred(new ConnectionEvent(this, sQLException));
        }
    }

    private synchronized void fireStatementEvent(PreparedStatement preparedStatement, boolean bl, SQLException sQLException) {
        for (StatementEventListener statementEventListener : this.statementEventListeners) {
            if (bl) {
                statementEventListener.statementClosed(new StatementEvent(this, preparedStatement));
                continue;
            }
            statementEventListener.statementErrorOccurred(new StatementEvent(this, preparedStatement, sQLException));
        }
    }

    private Connection createConnectionProxy(Connection connection) {
        return (Connection)Proxy.newProxyInstance(connection.getClass().getClassLoader(), connection.getClass().getInterfaces(), (InvocationHandler)new DmdbPooledConnection$1(this, connection));
    }

    private PreparedStatement createPreparedStatamentProxy(PreparedStatement preparedStatement) {
        return (PreparedStatement)Proxy.newProxyInstance(preparedStatement.getClass().getClassLoader(), preparedStatement.getClass().getInterfaces(), (InvocationHandler)new DmdbPooledConnection$2(this, preparedStatement));
    }

    static /* synthetic */ void access$0(DmdbPooledConnection dmdbPooledConnection, boolean bl, SQLException sQLException) {
        dmdbPooledConnection.fireConnectionEvent(bl, sQLException);
    }

    static /* synthetic */ PreparedStatement access$1(DmdbPooledConnection dmdbPooledConnection, PreparedStatement preparedStatement) {
        return dmdbPooledConnection.createPreparedStatamentProxy(preparedStatement);
    }

    static /* synthetic */ void access$2(DmdbPooledConnection dmdbPooledConnection, PreparedStatement preparedStatement, boolean bl, SQLException sQLException) {
        dmdbPooledConnection.fireStatementEvent(preparedStatement, bl, sQLException);
    }
}

