/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HFileInputFormat
extends FileInputFormat<NullWritable, Cell> {
    private static final Logger LOG = LoggerFactory.getLogger(HFileInputFormat.class);
    static final PathFilter HIDDEN_FILE_FILTER = new PathFilter(){

        @Override
        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        for (FileStatus status : super.listStatus(job)) {
            if (status.isDirectory()) {
                FileSystem fs = status.getPath().getFileSystem(job.getConfiguration());
                for (FileStatus match : fs.listStatus(status.getPath(), HIDDEN_FILE_FILTER)) {
                    result.add(match);
                }
                continue;
            }
            result.add(status);
        }
        return result;
    }

    public RecordReader<NullWritable, Cell> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new HFileRecordReader();
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }

    private static class HFileRecordReader
    extends RecordReader<NullWritable, Cell> {
        private HFile.Reader in;
        protected Configuration conf;
        private HFileScanner scanner;
        private Cell value = null;
        private long count;
        private boolean seeked = false;

        private HFileRecordReader() {
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            FileSplit fileSplit = (FileSplit)split;
            this.conf = context.getConfiguration();
            Path path = fileSplit.getPath();
            FileSystem fs = path.getFileSystem(this.conf);
            LOG.info("Initialize HFileRecordReader for {}", (Object)path);
            this.in = HFile.createReader((FileSystem)fs, (Path)path, (Configuration)this.conf);
            this.in.loadFileInfo();
            this.scanner = this.in.getScanner(false, false);
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            boolean hasNext;
            if (!this.seeked) {
                LOG.info("Seeking to start");
                hasNext = this.scanner.seekTo();
                this.seeked = true;
            } else {
                hasNext = this.scanner.next();
            }
            if (!hasNext) {
                return false;
            }
            this.value = this.scanner.getCell();
            ++this.count;
            return true;
        }

        public NullWritable getCurrentKey() throws IOException, InterruptedException {
            return NullWritable.get();
        }

        public Cell getCurrentValue() throws IOException, InterruptedException {
            return this.value;
        }

        public float getProgress() throws IOException, InterruptedException {
            return 1.0f * (float)this.count / (float)this.in.getEntries();
        }

        public void close() throws IOException {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
    }
}

