/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.jets3t.service.multithread;

import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.S3Object;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.multithread.ServiceEvent;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.multithread.ThreadWatcher;

public class LookupACLEvent
extends ServiceEvent {
    private S3Object[] objects = null;

    private LookupACLEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static LookupACLEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        LookupACLEvent event = new LookupACLEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static LookupACLEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        LookupACLEvent event = new LookupACLEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static LookupACLEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Object[] completedObjects, Object uniqueOperationId) {
        LookupACLEvent event = new LookupACLEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static LookupACLEvent newCompletedEvent(Object uniqueOperationId) {
        LookupACLEvent event = new LookupACLEvent(2, uniqueOperationId);
        return event;
    }

    public static LookupACLEvent newCancelledEvent(S3Object[] incompletedObjects, Object uniqueOperationId) {
        LookupACLEvent event = new LookupACLEvent(4, uniqueOperationId);
        event.setObjects(incompletedObjects);
        return event;
    }

    public static LookupACLEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        LookupACLEvent event = new LookupACLEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setObjects(S3Object[] objects) {
        this.objects = objects;
    }

    public S3Object[] getObjectsWithACL() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Completed Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

