/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.jets3t.service.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.shaded.org.apache.commons.httpclient.contrib.proxy.PluginProxyUtil;
import org.apache.hadoop.hbase.shaded.org.apache.http.Header;
import org.apache.hadoop.hbase.shaded.org.apache.http.HttpConnection;
import org.apache.hadoop.hbase.shaded.org.apache.http.HttpHost;
import org.apache.hadoop.hbase.shaded.org.apache.http.HttpRequest;
import org.apache.hadoop.hbase.shaded.org.apache.http.HttpRequestInterceptor;
import org.apache.hadoop.hbase.shaded.org.apache.http.HttpResponse;
import org.apache.hadoop.hbase.shaded.org.apache.http.HttpVersion;
import org.apache.hadoop.hbase.shaded.org.apache.http.auth.AuthScope;
import org.apache.hadoop.hbase.shaded.org.apache.http.auth.AuthState;
import org.apache.hadoop.hbase.shaded.org.apache.http.auth.Credentials;
import org.apache.hadoop.hbase.shaded.org.apache.http.auth.NTCredentials;
import org.apache.hadoop.hbase.shaded.org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.hadoop.hbase.shaded.org.apache.http.client.CredentialsProvider;
import org.apache.hadoop.hbase.shaded.org.apache.http.client.HttpClient;
import org.apache.hadoop.hbase.shaded.org.apache.http.client.methods.HttpGet;
import org.apache.hadoop.hbase.shaded.org.apache.http.client.methods.HttpRequestBase;
import org.apache.hadoop.hbase.shaded.org.apache.http.conn.ClientConnectionManager;
import org.apache.hadoop.hbase.shaded.org.apache.http.conn.ClientConnectionManagerFactory;
import org.apache.hadoop.hbase.shaded.org.apache.http.conn.params.ConnManagerParams;
import org.apache.hadoop.hbase.shaded.org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.hadoop.hbase.shaded.org.apache.http.impl.auth.BasicScheme;
import org.apache.hadoop.hbase.shaded.org.apache.http.impl.client.AbstractHttpClient;
import org.apache.hadoop.hbase.shaded.org.apache.http.impl.client.DefaultHttpClient;
import org.apache.hadoop.hbase.shaded.org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.hadoop.hbase.shaded.org.apache.http.impl.client.RequestWrapper;
import org.apache.hadoop.hbase.shaded.org.apache.http.impl.conn.tsccm.AbstractConnPool;
import org.apache.hadoop.hbase.shaded.org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.hadoop.hbase.shaded.org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.hadoop.hbase.shaded.org.apache.http.params.HttpConnectionParams;
import org.apache.hadoop.hbase.shaded.org.apache.http.params.HttpParams;
import org.apache.hadoop.hbase.shaded.org.apache.http.params.HttpProtocolParams;
import org.apache.hadoop.hbase.shaded.org.apache.http.params.SyncBasicHttpParams;
import org.apache.hadoop.hbase.shaded.org.apache.http.protocol.HttpContext;
import org.apache.hadoop.hbase.shaded.org.apache.http.util.VersionInfo;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.Constants;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.Jets3tProperties;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.S3ServiceException;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.ServiceException;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.impl.rest.httpclient.JetS3tRequestAuthorizer;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.io.UnrecoverableIOException;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.utils.ServiceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestUtils {
    private static final Log log = LogFactory.getLog(RestUtils.class);
    public static final List<String> HTTP_HEADER_METADATA_NAMES = Arrays.asList("content-type", "content-md5", "content-length", "content-language", "expires", "cache-control", "content-disposition", "content-encoding");

    public static String encodeUrlString(String path) throws ServiceException {
        try {
            String encodedPath = URLEncoder.encode(path, Constants.DEFAULT_ENCODING);
            encodedPath = encodedPath.replaceAll("\\+", "%20");
            encodedPath = encodedPath.replaceAll("%40", "@");
            return encodedPath;
        }
        catch (UnsupportedEncodingException uee) {
            throw new ServiceException("Unable to encode path: " + path, uee);
        }
    }

    public static String encodeUrlPath(String path, String delimiter) throws ServiceException {
        StringBuilder result = new StringBuilder();
        String[] tokens = path.split(delimiter);
        for (int i = 0; i < tokens.length; ++i) {
            result.append(RestUtils.encodeUrlString(tokens[i]));
            if (i >= tokens.length - 1) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static String makeServiceCanonicalString(String method, String resource, Map<String, Object> headersMap, String expires, String headerPrefix, List<String> serviceResourceParameterNames) throws UnsupportedEncodingException {
        Object value;
        String key;
        StringBuilder canonicalStringBuf = new StringBuilder();
        canonicalStringBuf.append(method).append("\n");
        TreeMap<String, Object> interestingHeaders = new TreeMap<String, Object>();
        if (headersMap != null && headersMap.size() > 0) {
            for (Map.Entry<String, Object> entry : headersMap.entrySet()) {
                String lk;
                key = entry.getKey();
                value = entry.getValue();
                if (key == null || !(lk = key.toString().toLowerCase(Locale.getDefault())).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith(headerPrefix)) continue;
                interestingHeaders.put(lk, value);
            }
        }
        if (interestingHeaders.containsKey("x-amz-date") || interestingHeaders.containsKey("x-goog-date")) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        if (!interestingHeaders.containsKey("content-md5")) {
            interestingHeaders.put("content-md5", "");
        }
        for (Map.Entry<String, Object> entry : interestingHeaders.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (key.startsWith(headerPrefix)) {
                canonicalStringBuf.append(key).append(':').append(value);
            } else {
                canonicalStringBuf.append(value);
            }
            canonicalStringBuf.append("\n");
        }
        int queryIndex = resource.indexOf(63);
        if (queryIndex == -1) {
            canonicalStringBuf.append(resource);
        } else {
            canonicalStringBuf.append(resource.substring(0, queryIndex));
        }
        if (queryIndex >= 0) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            String query = resource.substring(queryIndex + 1);
            for (String paramPair : query.split("&")) {
                String[] paramNameValue = paramPair.split("=");
                String name = URLDecoder.decode(paramNameValue[0], "UTF-8");
                String value2 = null;
                if (paramNameValue.length > 1) {
                    value2 = URLDecoder.decode(paramNameValue[1], "UTF-8");
                }
                if (!serviceResourceParameterNames.contains(name)) continue;
                treeMap.put(name, value2);
            }
            if (treeMap.size() > 0) {
                canonicalStringBuf.append("?");
            }
            boolean addedParam = false;
            for (Map.Entry entry : treeMap.entrySet()) {
                if (addedParam) {
                    canonicalStringBuf.append("&");
                }
                canonicalStringBuf.append((String)entry.getKey());
                if (entry.getValue() != null) {
                    canonicalStringBuf.append("=").append((String)entry.getValue());
                }
                addedParam = true;
            }
        }
        return canonicalStringBuf.toString();
    }

    public static HttpClient initHttpConnection(JetS3tRequestAuthorizer requestAuthorizer, Jets3tProperties jets3tProperties, String userAgentDescription, CredentialsProvider credentialsProvider) {
        HttpParams params = RestUtils.createDefaultHttpParams();
        params.setParameter("org.apache.hadoop.hbase.shaded.org.jets3t.service.JetS3tProperties", jets3tProperties);
        params.setParameter("http.connection-manager.factory-class-name", jets3tProperties.getStringProperty("http.connection-manager.factory-class-name", ConnManagerFactory.class.getName()));
        HttpConnectionParams.setConnectionTimeout(params, jets3tProperties.getIntProperty("httpclient.connection-timeout-ms", 60000));
        HttpConnectionParams.setSoTimeout(params, jets3tProperties.getIntProperty("httpclient.socket-timeout-ms", 60000));
        HttpConnectionParams.setStaleCheckingEnabled(params, jets3tProperties.getBoolProperty("httpclient.stale-checking-enabled", true));
        if (jets3tProperties.containsKey("httpclient.socket-receive-buffer")) {
            HttpConnectionParams.setSocketBufferSize(params, jets3tProperties.getIntProperty("httpclient.socket-receive-buffer", 0));
        }
        HttpConnectionParams.setTcpNoDelay(params, true);
        String userAgent = jets3tProperties.getStringProperty("httpclient.useragent", null);
        if (userAgent == null) {
            userAgent = ServiceUtils.getUserAgentDescription(userAgentDescription);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting user agent string: " + userAgent));
        }
        HttpProtocolParams.setUserAgent(params, userAgent);
        boolean expectContinue = jets3tProperties.getBoolProperty("http.protocol.expect-continue", true);
        HttpProtocolParams.setUseExpectContinue(params, expectContinue);
        long connectionManagerTimeout = jets3tProperties.getLongProperty("httpclient.connection-manager-timeout", 0L);
        ConnManagerParams.setTimeout(params, connectionManagerTimeout);
        DefaultHttpClient httpClient = new DefaultHttpClient(params);
        httpClient.setHttpRequestRetryHandler(new JetS3tRetryHandler(jets3tProperties.getIntProperty("httpclient.retry-max", 5), requestAuthorizer));
        if (credentialsProvider != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using credentials provider class: " + credentialsProvider.getClass().getName()));
            }
            httpClient.setCredentialsProvider(credentialsProvider);
            if (jets3tProperties.getBoolProperty("httpclient.authentication-preemptive", false)) {
                httpClient.addRequestInterceptor(new PreemptiveInterceptor(), 0);
            }
        }
        return httpClient;
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties) {
        RestUtils.initHttpProxy(httpClient, jets3tProperties, true, null, -1, null, null, null);
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties, String endpoint) {
        RestUtils.initHttpProxy(httpClient, jets3tProperties, true, null, -1, null, null, null, endpoint);
    }

    public static void initHttpProxy(HttpClient httpClient, String proxyHostAddress, int proxyPort, Jets3tProperties jets3tProperties) {
        RestUtils.initHttpProxy(httpClient, jets3tProperties, false, proxyHostAddress, proxyPort, null, null, null);
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties, String proxyHostAddress, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain) {
        RestUtils.initHttpProxy(httpClient, jets3tProperties, false, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain);
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties, boolean proxyAutodetect, String proxyHostAddress, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain) {
        String s3Endpoint = jets3tProperties.getStringProperty("s3service.s3-endpoint", Constants.S3_DEFAULT_HOSTNAME);
        RestUtils.initHttpProxy(httpClient, jets3tProperties, proxyAutodetect, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain, s3Endpoint);
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties, boolean proxyAutodetect, String proxyHostAddress, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain, String endpoint) {
        block11: {
            if (proxyHostAddress != null && proxyPort != -1) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Using Proxy: " + proxyHostAddress + ":" + proxyPort));
                }
                HttpHost proxy = new HttpHost(proxyHostAddress, proxyPort);
                httpClient.getParams().setParameter("http.route.default-proxy", proxy);
                if (proxyUser != null && !proxyUser.trim().equals("") && httpClient instanceof AbstractHttpClient) {
                    if (proxyDomain != null) {
                        ((AbstractHttpClient)httpClient).getCredentialsProvider().setCredentials(new AuthScope(proxyHostAddress, proxyPort), new NTCredentials(proxyUser, proxyPassword, proxyHostAddress, proxyDomain));
                    } else {
                        ((AbstractHttpClient)httpClient).getCredentialsProvider().setCredentials(new AuthScope(proxyHostAddress, proxyPort), new UsernamePasswordCredentials(proxyUser, proxyPassword));
                    }
                }
            } else if (proxyAutodetect) {
                HttpHost proxyHost = null;
                try {
                    proxyHost = PluginProxyUtil.detectProxy(new URL("http://" + endpoint));
                    if (proxyHost != null) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Using Proxy: " + proxyHost.getHostName() + ":" + proxyHost.getPort()));
                        }
                        httpClient.getParams().setParameter("http.route.default-proxy", proxyHost);
                    }
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block11;
                    log.debug((Object)"Unable to set proxy configuration", t);
                }
            }
        }
    }

    public static long getAWSTimeAdjustment() throws IOException, S3ServiceException, ParseException {
        RestS3Service restService = new RestS3Service(null);
        HttpClient client = restService.getHttpClient();
        long timeOffset = 0L;
        HttpGet getMethod = new HttpGet("http://aws.amazon.com/");
        HttpResponse result = client.execute(getMethod);
        if (result.getStatusLine().getStatusCode() == 200) {
            Header dateHeader = result.getHeaders("Date")[0];
            Date awsTime = ServiceUtils.parseRfc822Date(dateHeader.getValue());
            Date localTime = new Date();
            timeOffset = awsTime.getTime() - localTime.getTime();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calculated time offset value of " + timeOffset + " milliseconds between the local machine and an AWS server"));
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Unable to calculate value of time offset between the local machine and AWS server");
        }
        return timeOffset;
    }

    public static Map<String, String> convertHeadersToMap(Header[] headers) {
        HashMap<String, String> s3Headers = new HashMap<String, String>();
        for (Header header : headers) {
            s3Headers.put(header.getName(), header.getValue());
        }
        return s3Headers;
    }

    public static HttpParams createDefaultHttpParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset(params, "ISO-8859-1");
        HttpConnectionParams.setTcpNoDelay(params, true);
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        VersionInfo vi = VersionInfo.loadVersionInfo("org.apache.hadoop.hbase.shaded.org.apache.http.client", HttpClient.class.getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        HttpProtocolParams.setUserAgent(params, "Apache-HttpClient/" + release + " (java 1.5)");
        return params;
    }

    private static class PreemptiveInterceptor
    implements HttpRequestInterceptor {
        private PreemptiveInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) {
            AuthScope authScope;
            Credentials creds;
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
            if (authState.getAuthScheme() == null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                authState.setAuthScheme(new BasicScheme());
                authState.setCredentials(creds);
            }
        }
    }

    public static class JetS3tRetryHandler
    extends DefaultHttpRequestRetryHandler {
        private final JetS3tRequestAuthorizer requestAuthorizer;

        public JetS3tRetryHandler(int pRetryMaxCount, JetS3tRequestAuthorizer requestAuthorizer) {
            super(pRetryMaxCount, false);
            this.requestAuthorizer = requestAuthorizer;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            block11: {
                if (super.retryRequest(exception, executionCount, context)) {
                    if (exception instanceof UnrecoverableIOException) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Deliberate interruption, will not retry");
                        }
                        return false;
                    }
                    HttpRequest request = (HttpRequest)context.getAttribute("http.request");
                    if (request instanceof RequestWrapper) {
                        request = ((RequestWrapper)request).getOriginal();
                    }
                    if (!(request instanceof HttpRequestBase)) {
                        return false;
                    }
                    HttpRequestBase method = (HttpRequestBase)request;
                    HttpConnection conn = (HttpConnection)context.getAttribute("http.connection");
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Retrying " + method.getMethod() + " request with path '" + method.getURI() + "' - attempt " + executionCount + " of " + this.getRetryCount()));
                    }
                    try {
                        if (this.requestAuthorizer != null) {
                            this.requestAuthorizer.authorizeHttpRequest(method, context);
                        }
                        return true;
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block11;
                        log.warn((Object)"Unable to generate updated authorization string for retried request", (Throwable)e);
                    }
                }
            }
            return false;
        }
    }

    public static class ThreadSafeConnManager
    extends ThreadSafeClientConnManager {
        public ThreadSafeConnManager(HttpParams params, SchemeRegistry schreg) {
            super(params, schreg);
        }

        protected AbstractConnPool createConnectionPool(HttpParams params) {
            Jets3tProperties props = (Jets3tProperties)params.getParameter("org.apache.hadoop.hbase.shaded.org.jets3t.service.JetS3tProperties");
            int maxConn = 20;
            int maxConnectionsPerHost = 0;
            if (props != null) {
                maxConn = props.getIntProperty("httpclient.max-connections", 20);
                maxConnectionsPerHost = props.getIntProperty("httpclient.max-connections-per-host", 0);
            }
            if (maxConnectionsPerHost == 0) {
                maxConnectionsPerHost = maxConn;
            }
            this.connPerRoute.setDefaultMaxPerRoute(maxConnectionsPerHost);
            return new ConnPoolByRoute(this.connOperator, this.connPerRoute, maxConn);
        }
    }

    public static class ConnManagerFactory
    implements ClientConnectionManagerFactory {
        public ClientConnectionManager newInstance(HttpParams params, SchemeRegistry schemeRegistry) {
            return new ThreadSafeConnManager(params, schemeRegistry);
        }
    }
}

