/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.mortbay.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.apache.hadoop.hbase.shaded.org.mortbay.io.Buffer;
import org.apache.hadoop.hbase.shaded.org.mortbay.io.BufferCache;
import org.apache.hadoop.hbase.shaded.org.mortbay.io.Connection;
import org.apache.hadoop.hbase.shaded.org.mortbay.io.EndPoint;
import org.apache.hadoop.hbase.shaded.org.mortbay.io.RuntimeIOException;
import org.apache.hadoop.hbase.shaded.org.mortbay.io.nio.SelectChannelEndPoint;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.AbstractGenerator;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.Connector;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.EncodedHttpURI;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.EofException;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.Generator;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.HttpContent;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.HttpException;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.HttpFields;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.HttpGenerator;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.HttpHeaderValues;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.HttpHeaders;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.HttpMethods;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.HttpParser;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.HttpURI;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.HttpVersions;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.MimeTypes;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.Parser;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.Request;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.Response;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.RetryRequest;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.Server;
import org.apache.hadoop.hbase.shaded.org.mortbay.log.Log;
import org.apache.hadoop.hbase.shaded.org.mortbay.resource.Resource;
import org.apache.hadoop.hbase.shaded.org.mortbay.util.QuotedStringTokenizer;
import org.apache.hadoop.hbase.shaded.org.mortbay.util.URIUtil;

public class HttpConnection
implements Connection {
    private static int UNKNOWN = -2;
    private static ThreadLocal __currentConnection = new ThreadLocal();
    private long _timeStamp = System.currentTimeMillis();
    private int _requests;
    private boolean _handling;
    private boolean _destroy;
    protected final Connector _connector;
    protected final EndPoint _endp;
    protected final Server _server;
    protected final HttpURI _uri;
    protected final Parser _parser;
    protected final HttpFields _requestFields;
    protected final Request _request;
    protected ServletInputStream _in;
    protected final Generator _generator;
    protected final HttpFields _responseFields;
    protected final Response _response;
    protected Output _out;
    protected OutputWriter _writer;
    protected PrintWriter _printWriter;
    int _include;
    private Object _associatedObject;
    private transient int _expect = UNKNOWN;
    private transient int _version = UNKNOWN;
    private transient boolean _head = false;
    private transient boolean _host = false;
    private transient boolean _delayedHandling = false;

    public static HttpConnection getCurrentConnection() {
        return (HttpConnection)__currentConnection.get();
    }

    protected static void setCurrentConnection(HttpConnection connection) {
        __currentConnection.set(connection);
    }

    public HttpConnection(Connector connector, EndPoint endpoint, Server server) {
        this._uri = URIUtil.__CHARSET == "UTF-8" ? new HttpURI() : new EncodedHttpURI(URIUtil.__CHARSET);
        this._connector = connector;
        this._endp = endpoint;
        this._parser = new HttpParser(this._connector, endpoint, new RequestHandler(), this._connector.getHeaderBufferSize(), this._connector.getRequestBufferSize());
        this._requestFields = new HttpFields();
        this._responseFields = new HttpFields();
        this._request = new Request(this);
        this._response = new Response(this);
        this._generator = new HttpGenerator(this._connector, this._endp, this._connector.getHeaderBufferSize(), this._connector.getResponseBufferSize());
        this._generator.setSendServerVersion(server.getSendServerVersion());
        this._server = server;
    }

    protected HttpConnection(Connector connector, EndPoint endpoint, Server server, Parser parser, Generator generator, Request request) {
        this._uri = URIUtil.__CHARSET == "UTF-8" ? new HttpURI() : new EncodedHttpURI(URIUtil.__CHARSET);
        this._connector = connector;
        this._endp = endpoint;
        this._parser = parser;
        this._requestFields = new HttpFields();
        this._responseFields = new HttpFields();
        this._request = request;
        this._response = new Response(this);
        this._generator = generator;
        this._generator.setSendServerVersion(server.getSendServerVersion());
        this._server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            this._destroy = true;
            if (!this._handling) {
                if (this._parser != null) {
                    this._parser.reset(true);
                }
                if (this._generator != null) {
                    this._generator.reset(true);
                }
                if (this._requestFields != null) {
                    this._requestFields.destroy();
                }
                if (this._responseFields != null) {
                    this._responseFields.destroy();
                }
            }
        }
    }

    public Parser getParser() {
        return this._parser;
    }

    public int getRequests() {
        return this._requests;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public Object getAssociatedObject() {
        return this._associatedObject;
    }

    public void setAssociatedObject(Object associatedObject) {
        this._associatedObject = associatedObject;
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpFields getRequestFields() {
        return this._requestFields;
    }

    public HttpFields getResponseFields() {
        return this._responseFields;
    }

    public boolean isConfidential(Request request) {
        if (this._connector != null) {
            return this._connector.isConfidential(request);
        }
        return false;
    }

    public boolean isIntegral(Request request) {
        if (this._connector != null) {
            return this._connector.isIntegral(request);
        }
        return false;
    }

    public EndPoint getEndPoint() {
        return this._endp;
    }

    public boolean getResolveNames() {
        return this._connector.getResolveNames();
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public ServletInputStream getInputStream() {
        if (this._in == null) {
            this._in = new HttpParser.Input((HttpParser)this._parser, this._connector.getMaxIdleTime());
        }
        return this._in;
    }

    public ServletOutputStream getOutputStream() {
        if (this._out == null) {
            this._out = new Output();
        }
        return this._out;
    }

    public PrintWriter getPrintWriter(String encoding) {
        this.getOutputStream();
        if (this._writer == null) {
            this._writer = new OutputWriter();
            this._printWriter = new PrintWriter(this._writer){

                public void close() {
                    try {
                        this.out.close();
                    }
                    catch (IOException e) {
                        Log.debug(e);
                        this.setError();
                    }
                }
            };
        }
        this._writer.setCharacterEncoding(encoding);
        return this._printWriter;
    }

    public boolean isResponseCommitted() {
        return this._generator.isCommitted();
    }

    /*
     * Exception decompiling
     */
    public void handle() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void reset(boolean returnBuffers) {
        this._parser.reset(returnBuffers);
        this._requestFields.clear();
        this._request.recycle();
        this._generator.reset(returnBuffers);
        this._responseFields.clear();
        this._response.recycle();
        this._uri.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleRequest() throws IOException {
        boolean error;
        block57: {
            if (!this._server.isRunning()) return;
            boolean retrying = false;
            error = false;
            String threadName = null;
            String info = null;
            try {
                try {
                    info = URIUtil.canonicalPath(this._uri.getDecodedPath());
                    if (info == null) {
                        throw new HttpException(400);
                    }
                    this._request.setPathInfo(info);
                    if (this._out != null) {
                        this._out.reopen();
                    }
                    if (Log.isDebugEnabled()) {
                        threadName = Thread.currentThread().getName();
                        Thread.currentThread().setName(threadName + " - " + this._uri);
                    }
                    this._connector.customize(this._endp, this._request);
                    this._server.handle(this);
                }
                catch (RetryRequest r) {
                    if (Log.isDebugEnabled()) {
                        Log.ignore(r);
                    }
                    retrying = true;
                    Object var7_6 = null;
                    if (threadName != null) {
                        Thread.currentThread().setName(threadName);
                    }
                    if (retrying) return;
                    if (this._request.getContinuation() != null) {
                        Log.debug("continuation still pending {}");
                        this._request.getContinuation().reset();
                    }
                    if (!this._endp.isOpen()) {
                        this._response.complete();
                        return;
                    }
                    if (this._generator.isPersistent()) {
                        this._connector.persist(this._endp);
                    }
                    if (error) {
                        this._endp.close();
                        return;
                    }
                    if (!this._response.isCommitted() && !this._request.isHandled()) {
                        this._response.sendError(404);
                    }
                    this._response.complete();
                    return;
                }
                catch (EofException e) {
                    Log.ignore(e);
                    error = true;
                    Object var7_7 = null;
                    if (threadName != null) {
                        Thread.currentThread().setName(threadName);
                    }
                    if (retrying) return;
                    if (this._request.getContinuation() != null) {
                        Log.debug("continuation still pending {}");
                        this._request.getContinuation().reset();
                    }
                    if (!this._endp.isOpen()) {
                        this._response.complete();
                        return;
                    }
                    if (this._generator.isPersistent()) {
                        this._connector.persist(this._endp);
                    }
                    if (error) {
                        this._endp.close();
                        return;
                    }
                    if (!this._response.isCommitted() && !this._request.isHandled()) {
                        this._response.sendError(404);
                    }
                    this._response.complete();
                    return;
                }
                catch (HttpException e) {
                    Log.debug(e);
                    this._request.setHandled(true);
                    this._response.sendError(e.getStatus(), e.getReason());
                    error = true;
                    Object var7_8 = null;
                    if (threadName != null) {
                        Thread.currentThread().setName(threadName);
                    }
                    if (retrying) return;
                    if (this._request.getContinuation() != null) {
                        Log.debug("continuation still pending {}");
                        this._request.getContinuation().reset();
                    }
                    if (!this._endp.isOpen()) {
                        this._response.complete();
                        return;
                    }
                    if (this._generator.isPersistent()) {
                        this._connector.persist(this._endp);
                    }
                    if (error) {
                        this._endp.close();
                        return;
                    }
                    if (!this._response.isCommitted() && !this._request.isHandled()) {
                        this._response.sendError(404);
                    }
                    this._response.complete();
                    return;
                }
                catch (RuntimeIOException e) {
                    Log.debug(e);
                    this._request.setHandled(true);
                    error = true;
                    Object var7_9 = null;
                    if (threadName != null) {
                        Thread.currentThread().setName(threadName);
                    }
                    if (retrying) return;
                    if (this._request.getContinuation() != null) {
                        Log.debug("continuation still pending {}");
                        this._request.getContinuation().reset();
                    }
                    if (!this._endp.isOpen()) {
                        this._response.complete();
                        return;
                    }
                    if (this._generator.isPersistent()) {
                        this._connector.persist(this._endp);
                    }
                    if (error) {
                        this._endp.close();
                        return;
                    }
                    if (!this._response.isCommitted() && !this._request.isHandled()) {
                        this._response.sendError(404);
                    }
                    this._response.complete();
                    return;
                }
                catch (Throwable e) {
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    if (info == null) {
                        Log.warn(this._uri + ": " + e);
                        Log.debug(e);
                        this._request.setHandled(true);
                        this._generator.sendError(400, null, null, true);
                    } else {
                        Log.warn("" + this._uri, e);
                        this._request.setHandled(true);
                        this._generator.sendError(500, null, null, true);
                    }
                    error = true;
                    Object var7_10 = null;
                    if (threadName != null) {
                        Thread.currentThread().setName(threadName);
                    }
                    if (retrying) return;
                    if (this._request.getContinuation() != null) {
                        Log.debug("continuation still pending {}");
                        this._request.getContinuation().reset();
                    }
                    if (!this._endp.isOpen()) {
                        this._response.complete();
                        return;
                    }
                    if (this._generator.isPersistent()) {
                        this._connector.persist(this._endp);
                    }
                    if (error) {
                        this._endp.close();
                        return;
                    }
                    if (!this._response.isCommitted() && !this._request.isHandled()) {
                        this._response.sendError(404);
                    }
                    this._response.complete();
                    return;
                }
                Object var7_5 = null;
                if (threadName != null) {
                    Thread.currentThread().setName(threadName);
                }
                if (retrying) return;
                if (this._request.getContinuation() == null) break block57;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                if (threadName != null) {
                    Thread.currentThread().setName(threadName);
                }
                if (retrying) throw throwable;
                if (this._request.getContinuation() != null) {
                    Log.debug("continuation still pending {}");
                    this._request.getContinuation().reset();
                }
                if (!this._endp.isOpen()) {
                    this._response.complete();
                    throw throwable;
                }
                if (this._generator.isPersistent()) {
                    this._connector.persist(this._endp);
                }
                if (error) {
                    this._endp.close();
                    throw throwable;
                }
                if (!this._response.isCommitted() && !this._request.isHandled()) {
                    this._response.sendError(404);
                }
                this._response.complete();
                throw throwable;
            }
            Log.debug("continuation still pending {}");
            this._request.getContinuation().reset();
        }
        if (this._endp.isOpen()) {
            if (this._generator.isPersistent()) {
                this._connector.persist(this._endp);
            }
            if (error) {
                this._endp.close();
                return;
            }
            if (!this._response.isCommitted() && !this._request.isHandled()) {
                this._response.sendError(404);
            }
            this._response.complete();
            return;
        }
        this._response.complete();
    }

    public void commitResponse(boolean last) throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            try {
                this._generator.completeHeader(this._responseFields, last);
            }
            catch (IOException io) {
                throw io;
            }
            catch (RuntimeException e) {
                Log.warn("header full: " + e);
                if (Log.isDebugEnabled() && this._generator instanceof HttpGenerator) {
                    Log.debug(((HttpGenerator)this._generator)._header.toDetailString(), e);
                }
                this._response.reset();
                this._generator.reset(true);
                this._generator.setResponse(500, null);
                this._generator.completeHeader(this._responseFields, true);
                this._generator.complete();
                throw e;
            }
        }
        if (last) {
            this._generator.complete();
        }
    }

    public void completeResponse() throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            try {
                this._generator.completeHeader(this._responseFields, true);
            }
            catch (IOException io) {
                throw io;
            }
            catch (RuntimeException e) {
                Log.warn("header full: " + e);
                Log.debug(e);
                this._response.reset();
                this._generator.reset(true);
                this._generator.setResponse(500, null);
                this._generator.completeHeader(this._responseFields, true);
                this._generator.complete();
                throw e;
            }
        }
        this._generator.complete();
    }

    public void flushResponse() throws IOException {
        try {
            this.commitResponse(false);
            this._generator.flush();
        }
        catch (IOException e) {
            throw e instanceof EofException ? e : new EofException(e);
        }
    }

    public Generator getGenerator() {
        return this._generator;
    }

    public boolean isIncluding() {
        return this._include > 0;
    }

    public void include() {
        ++this._include;
    }

    public void included() {
        --this._include;
        if (this._out != null) {
            this._out.reopen();
        }
    }

    public boolean isIdle() {
        return this._generator.isIdle() && (this._parser.isIdle() || this._delayedHandling);
    }

    public class OutputWriter
    extends AbstractGenerator.OutputWriter {
        OutputWriter() {
            super(HttpConnection.this._out);
        }
    }

    public class Output
    extends AbstractGenerator.Output {
        Output() {
            super((AbstractGenerator)HttpConnection.this._generator, HttpConnection.this._connector.getMaxIdleTime());
        }

        public void close() throws IOException {
            if (this._closed) {
                return;
            }
            if (!HttpConnection.this.isIncluding() && !this._generator.isCommitted()) {
                HttpConnection.this.commitResponse(true);
            } else {
                HttpConnection.this.flushResponse();
            }
            super.close();
        }

        public void flush() throws IOException {
            if (!this._generator.isCommitted()) {
                HttpConnection.this.commitResponse(false);
            }
            super.flush();
        }

        public void print(String s) throws IOException {
            if (this._closed) {
                throw new IOException("Closed");
            }
            PrintWriter writer = HttpConnection.this.getPrintWriter(null);
            writer.print(s);
        }

        public void sendResponse(Buffer response) throws IOException {
            ((HttpGenerator)this._generator).sendResponse(response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendContent(Object content) throws IOException {
            Resource resource = null;
            if (this._closed) {
                throw new IOException("Closed");
            }
            if (this._generator.getContentWritten() > 0L) {
                throw new IllegalStateException("!empty");
            }
            if (content instanceof HttpContent) {
                HttpContent c = (HttpContent)content;
                Buffer contentType = c.getContentType();
                if (contentType != null && !HttpConnection.this._responseFields.containsKey(HttpHeaders.CONTENT_TYPE_BUFFER)) {
                    String enc = HttpConnection.this._response.getSetCharacterEncoding();
                    if (enc == null) {
                        HttpConnection.this._responseFields.add(HttpHeaders.CONTENT_TYPE_BUFFER, contentType);
                    } else if (contentType instanceof BufferCache.CachedBuffer) {
                        BufferCache.CachedBuffer content_type = ((BufferCache.CachedBuffer)contentType).getAssociate(enc);
                        if (content_type != null) {
                            HttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, content_type);
                        } else {
                            HttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, contentType + ";charset=" + QuotedStringTokenizer.quote(enc, ";= "));
                        }
                    } else {
                        HttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, contentType + ";charset=" + QuotedStringTokenizer.quote(enc, ";= "));
                    }
                }
                if (c.getContentLength() > 0L) {
                    HttpConnection.this._responseFields.putLongField(HttpHeaders.CONTENT_LENGTH_BUFFER, c.getContentLength());
                }
                Buffer lm = c.getLastModified();
                long lml = c.getResource().lastModified();
                if (lm != null) {
                    HttpConnection.this._responseFields.put(HttpHeaders.LAST_MODIFIED_BUFFER, lm, lml);
                } else if (c.getResource() != null && lml != -1L) {
                    HttpConnection.this._responseFields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, lml);
                }
                content = c.getBuffer();
                if (content == null) {
                    content = c.getInputStream();
                }
            } else if (content instanceof Resource) {
                resource = (Resource)content;
                HttpConnection.this._responseFields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, resource.lastModified());
                content = resource.getInputStream();
            }
            if (content instanceof Buffer) {
                this._generator.addContent((Buffer)content, true);
                HttpConnection.this.commitResponse(true);
            } else if (content instanceof InputStream) {
                InputStream in = (InputStream)content;
                try {
                    int max = this._generator.prepareUncheckedAddContent();
                    Buffer buffer = this._generator.getUncheckedBuffer();
                    int len = buffer.readFrom(in, max);
                    while (len >= 0) {
                        this._generator.completeUncheckedAddContent();
                        HttpConnection.this._out.flush();
                        max = this._generator.prepareUncheckedAddContent();
                        buffer = this._generator.getUncheckedBuffer();
                        len = buffer.readFrom(in, max);
                    }
                    this._generator.completeUncheckedAddContent();
                    HttpConnection.this._out.flush();
                }
                finally {
                    if (resource != null) {
                        resource.release();
                    } else {
                        in.close();
                    }
                }
            } else {
                throw new IllegalArgumentException("unknown content type?");
            }
        }
    }

    private class RequestHandler
    extends HttpParser.EventHandler {
        private String _charset;

        private RequestHandler() {
        }

        public void startRequest(Buffer method, Buffer uri, Buffer version) throws IOException {
            HttpConnection.this._host = false;
            HttpConnection.this._expect = UNKNOWN;
            HttpConnection.this._delayedHandling = false;
            this._charset = null;
            if (HttpConnection.this._request.getTimeStamp() == 0L) {
                HttpConnection.this._request.setTimeStamp(System.currentTimeMillis());
            }
            HttpConnection.this._request.setMethod(method.toString());
            try {
                HttpConnection.this._uri.parse(uri.array(), uri.getIndex(), uri.length());
                HttpConnection.this._request.setUri(HttpConnection.this._uri);
                if (version == null) {
                    HttpConnection.this._request.setProtocol("");
                    HttpConnection.this._version = 9;
                } else {
                    version = HttpVersions.CACHE.get(version);
                    HttpConnection.this._version = HttpVersions.CACHE.getOrdinal(version);
                    if (HttpConnection.this._version <= 0) {
                        HttpConnection.this._version = 10;
                    }
                    HttpConnection.this._request.setProtocol(version.toString());
                }
                HttpConnection.this._head = method == HttpMethods.HEAD_BUFFER;
            }
            catch (Exception e) {
                Log.debug(e);
                throw new HttpException(400, null, e);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void parsedHeader(Buffer name, Buffer value) {
            int ho = HttpHeaders.CACHE.getOrdinal(name);
            switch (ho) {
                case 27: {
                    HttpConnection.this._host = true;
                    break;
                }
                case 24: {
                    value = HttpHeaderValues.CACHE.lookup(value);
                    HttpConnection.this._expect = HttpHeaderValues.CACHE.getOrdinal(value);
                    break;
                }
                case 21: 
                case 40: {
                    value = HttpHeaderValues.CACHE.lookup(value);
                    break;
                }
                case 16: {
                    value = MimeTypes.CACHE.lookup(value);
                    this._charset = MimeTypes.getCharsetFromContentType(value);
                    break;
                }
                case 1: {
                    int ordinal = HttpHeaderValues.CACHE.getOrdinal(value);
                    switch (ordinal) {
                        case -1: {
                            QuotedStringTokenizer tok = new QuotedStringTokenizer(value.toString(), ",");
                            block16: while (tok.hasMoreTokens()) {
                                BufferCache.CachedBuffer cb = HttpHeaderValues.CACHE.get(tok.nextToken().trim());
                                if (cb == null) continue;
                                switch (cb.getOrdinal()) {
                                    case 1: {
                                        HttpConnection.this._responseFields.add(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                                        HttpConnection.this._generator.setPersistent(false);
                                        break;
                                    }
                                    case 5: {
                                        if (HttpConnection.this._version != 10) break;
                                        HttpConnection.this._responseFields.add(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.KEEP_ALIVE_BUFFER);
                                        continue block16;
                                    }
                                }
                            }
                            break;
                        }
                        case 1: {
                            HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                            HttpConnection.this._generator.setPersistent(false);
                            break;
                        }
                        case 5: {
                            if (HttpConnection.this._version != 10) break;
                            HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.KEEP_ALIVE_BUFFER);
                        }
                    }
                    break;
                }
            }
            HttpConnection.this._requestFields.add(name, value);
        }

        public void headerComplete() throws IOException {
            if (HttpConnection.this._endp instanceof SelectChannelEndPoint) {
                ((SelectChannelEndPoint)HttpConnection.this._endp).scheduleIdle();
            }
            HttpConnection.this._requests++;
            HttpConnection.this._generator.setVersion(HttpConnection.this._version);
            switch (HttpConnection.this._version) {
                case 9: {
                    break;
                }
                case 10: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    break;
                }
                case 11: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    if (HttpConnection.this._server.getSendDateHeader()) {
                        HttpConnection.this._responseFields.put(HttpHeaders.DATE_BUFFER, HttpConnection.this._request.getTimeStampBuffer(), HttpConnection.this._request.getTimeStamp());
                    }
                    if (!HttpConnection.this._host) {
                        HttpConnection.this._generator.setResponse(400, null);
                        HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                        HttpConnection.this._generator.completeHeader(HttpConnection.this._responseFields, true);
                        HttpConnection.this._generator.complete();
                        return;
                    }
                    if (HttpConnection.this._expect == UNKNOWN) break;
                    if (HttpConnection.this._expect == 6) {
                        if (((HttpParser)HttpConnection.this._parser).getHeaderBuffer() != null && ((HttpParser)HttpConnection.this._parser).getHeaderBuffer().length() >= 2) break;
                        HttpConnection.this._generator.setResponse(100, null);
                        HttpConnection.this._generator.completeHeader(null, true);
                        HttpConnection.this._generator.complete();
                        HttpConnection.this._generator.reset(false);
                        break;
                    }
                    if (HttpConnection.this._expect == 7) break;
                    HttpConnection.this._generator.setResponse(417, null);
                    HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                    HttpConnection.this._generator.completeHeader(HttpConnection.this._responseFields, true);
                    HttpConnection.this._generator.complete();
                    return;
                }
            }
            if (this._charset != null) {
                HttpConnection.this._request.setCharacterEncodingUnchecked(this._charset);
            }
            if (((HttpParser)HttpConnection.this._parser).getContentLength() <= 0L && !((HttpParser)HttpConnection.this._parser).isChunking()) {
                HttpConnection.this.handleRequest();
            } else {
                HttpConnection.this._delayedHandling = true;
            }
        }

        public void content(Buffer ref) throws IOException {
            if (HttpConnection.this._endp instanceof SelectChannelEndPoint) {
                ((SelectChannelEndPoint)HttpConnection.this._endp).scheduleIdle();
            }
            if (HttpConnection.this._delayedHandling) {
                HttpConnection.this._delayedHandling = false;
                HttpConnection.this.handleRequest();
            }
        }

        public void messageComplete(long contentLength) throws IOException {
            if (HttpConnection.this._delayedHandling) {
                HttpConnection.this._delayedHandling = false;
                HttpConnection.this.handleRequest();
            }
        }

        public void startResponse(Buffer version, int status, Buffer reason) {
            Log.debug("Bad request!: " + version + " " + status + " " + reason);
        }
    }
}

