/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MapReduceExtendedCell
extends ByteBufferExtendedCell {
    private final Cell cell;

    public MapReduceExtendedCell(Cell cell) {
        this.cell = cell;
    }

    @Override
    public byte[] getRowArray() {
        return this.cell.getRowArray();
    }

    @Override
    public int getRowOffset() {
        return this.cell.getRowOffset();
    }

    @Override
    public short getRowLength() {
        return this.cell.getRowLength();
    }

    @Override
    public byte[] getFamilyArray() {
        return this.cell.getFamilyArray();
    }

    @Override
    public int getFamilyOffset() {
        return this.cell.getFamilyOffset();
    }

    @Override
    public byte getFamilyLength() {
        return this.cell.getFamilyLength();
    }

    @Override
    public byte[] getQualifierArray() {
        return this.cell.getQualifierArray();
    }

    @Override
    public int getQualifierOffset() {
        return this.cell.getQualifierOffset();
    }

    @Override
    public int getQualifierLength() {
        return this.cell.getQualifierLength();
    }

    @Override
    public long getTimestamp() {
        return this.cell.getTimestamp();
    }

    @Override
    public byte getTypeByte() {
        return this.cell.getTypeByte();
    }

    @Override
    public long getSequenceId() {
        return this.cell.getSequenceId();
    }

    @Override
    public byte[] getValueArray() {
        return this.cell.getValueArray();
    }

    @Override
    public int getValueOffset() {
        return this.cell.getValueOffset();
    }

    @Override
    public int getValueLength() {
        return this.cell.getValueLength();
    }

    @Override
    public byte[] getTagsArray() {
        return this.cell.getTagsArray();
    }

    @Override
    public int getTagsOffset() {
        return this.cell.getTagsOffset();
    }

    @Override
    public int getTagsLength() {
        return this.cell.getTagsLength();
    }

    @Override
    public ByteBuffer getRowByteBuffer() {
        if (this.cell instanceof ByteBufferExtendedCell) {
            return ((ByteBufferExtendedCell)this.cell).getRowByteBuffer();
        }
        return ByteBuffer.wrap(CellUtil.cloneRow(this.cell));
    }

    @Override
    public int getRowPosition() {
        if (this.cell instanceof ByteBufferExtendedCell) {
            return ((ByteBufferExtendedCell)this.cell).getRowPosition();
        }
        return 0;
    }

    @Override
    public ByteBuffer getFamilyByteBuffer() {
        if (this.cell instanceof ByteBufferExtendedCell) {
            return ((ByteBufferExtendedCell)this.cell).getFamilyByteBuffer();
        }
        return ByteBuffer.wrap(CellUtil.cloneFamily(this.cell));
    }

    @Override
    public int getFamilyPosition() {
        if (this.cell instanceof ByteBufferExtendedCell) {
            return ((ByteBufferExtendedCell)this.cell).getFamilyPosition();
        }
        return 0;
    }

    @Override
    public ByteBuffer getQualifierByteBuffer() {
        if (this.cell instanceof ByteBufferExtendedCell) {
            return ((ByteBufferExtendedCell)this.cell).getQualifierByteBuffer();
        }
        return ByteBuffer.wrap(CellUtil.cloneQualifier(this.cell));
    }

    @Override
    public int getQualifierPosition() {
        if (this.cell instanceof ByteBufferExtendedCell) {
            return ((ByteBufferExtendedCell)this.cell).getQualifierPosition();
        }
        return 0;
    }

    @Override
    public ByteBuffer getValueByteBuffer() {
        if (this.cell instanceof ByteBufferExtendedCell) {
            return ((ByteBufferExtendedCell)this.cell).getValueByteBuffer();
        }
        return ByteBuffer.wrap(CellUtil.cloneValue(this.cell));
    }

    @Override
    public int getValuePosition() {
        if (this.cell instanceof ByteBufferExtendedCell) {
            return ((ByteBufferExtendedCell)this.cell).getValuePosition();
        }
        return 0;
    }

    @Override
    public ByteBuffer getTagsByteBuffer() {
        if (this.cell instanceof ByteBufferExtendedCell) {
            return ((ByteBufferExtendedCell)this.cell).getTagsByteBuffer();
        }
        return ByteBuffer.wrap(CellUtil.cloneTags(this.cell));
    }

    @Override
    public int getTagsPosition() {
        if (this.cell instanceof ByteBufferExtendedCell) {
            return ((ByteBufferExtendedCell)this.cell).getTagsPosition();
        }
        return 0;
    }

    public String toString() {
        return this.cell.toString();
    }

    @Override
    public void setSequenceId(long seqId) throws IOException {
        PrivateCellUtil.setSequenceId(this.cell, seqId);
    }

    @Override
    public void setTimestamp(long ts) throws IOException {
        PrivateCellUtil.setTimestamp(this.cell, ts);
    }

    @Override
    public void setTimestamp(byte[] ts) throws IOException {
        PrivateCellUtil.setTimestamp(this.cell, ts);
    }

    @Override
    public long heapSize() {
        return PrivateCellUtil.estimatedSizeOfCell(this.cell);
    }

    @Override
    public int write(OutputStream out, boolean withTags) throws IOException {
        return PrivateCellUtil.writeCell(this.cell, out, withTags);
    }

    @Override
    public int getSerializedSize(boolean withTags) {
        return PrivateCellUtil.estimatedSerializedSizeOf(this.cell) - 4;
    }

    @Override
    public void write(ByteBuffer buf, int offset) {
        PrivateCellUtil.writeCellToBuffer(this.cell, buf, offset);
    }

    @Override
    public ExtendedCell deepClone() {
        try {
            return (ExtendedCell)PrivateCellUtil.deepClone(this.cell);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

