/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DeletionListener
extends ZKListener {
    private static final Logger LOG = LoggerFactory.getLogger(DeletionListener.class);
    private final String pathToWatch;
    private final CountDownLatch deletedLatch;
    private volatile Throwable exception;

    public DeletionListener(ZKWatcher zkWatcher, String pathToWatch, CountDownLatch deletedLatch) {
        super(zkWatcher);
        this.pathToWatch = pathToWatch;
        this.deletedLatch = deletedLatch;
        this.exception = null;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public void nodeDataChanged(String path) {
        if (!path.equals(this.pathToWatch)) {
            return;
        }
        try {
            if (!ZKUtil.setWatchIfNodeExists(this.watcher, this.pathToWatch)) {
                this.deletedLatch.countDown();
            }
        }
        catch (KeeperException ex) {
            this.exception = ex;
            this.deletedLatch.countDown();
            LOG.error("Error when re-setting the watch on " + this.pathToWatch, (Throwable)ex);
        }
    }

    @Override
    public void nodeDeleted(String path) {
        if (!path.equals(this.pathToWatch)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing delete on " + this.pathToWatch);
        }
        this.deletedLatch.countDown();
    }
}

