/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.ComparatorHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.Seedable;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.CollectingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.ProjectedTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.MultiComparator;
import org.javatuples.Pair;

public final class OrderGlobalStep<S, C extends Comparable>
extends CollectingBarrierStep<S>
implements ComparatorHolder<S, C>,
TraversalParent,
ByModulating,
Seedable {
    private List<Pair<Traversal.Admin<S, C>, Comparator<C>>> comparators = new ArrayList<Pair<Traversal.Admin<S, C>, Comparator<C>>>();
    private MultiComparator<C> multiComparator = null;
    private long limit = Long.MAX_VALUE;
    private final Random random = new Random();

    public OrderGlobalStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    public void resetSeed(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    public void barrierConsumer(TraverserSet<S> traverserSet) {
        if (null == this.multiComparator) {
            this.multiComparator = this.createMultiComparator();
        }
        if (this.multiComparator.isShuffle()) {
            traverserSet.shuffle(this.random);
        } else {
            traverserSet.sort(this.multiComparator);
        }
    }

    @Override
    public void processAllStarts() {
        while (this.starts.hasNext()) {
            this.traverserSet.add(this.createProjectedTraverser((Traverser.Admin<S>)this.starts.next()));
        }
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public void addComparator(Traversal.Admin<S, C> traversal, Comparator<C> comparator) {
        this.comparators.add(new Pair(this.integrateChild(traversal), comparator));
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> traversal) {
        this.modulateBy(traversal, (Comparator)Order.asc);
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> traversal, Comparator comparator) {
        this.addComparator(traversal, comparator);
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        int i = 0;
        for (Pair<Traversal.Admin<S, C>, Comparator<C>> pair : this.comparators) {
            Traversal.Admin traversal = (Traversal.Admin)pair.getValue0();
            if (null != traversal && traversal.equals((Object)oldTraversal)) {
                this.comparators.set(i, Pair.with(this.integrateChild(newTraversal), (Object)pair.getValue1()));
                break;
            }
            ++i;
        }
    }

    @Override
    public List<Pair<Traversal.Admin<S, C>, Comparator<C>>> getComparators() {
        return this.comparators.isEmpty() ? Collections.singletonList(new Pair(new IdentityTraversal(), (Object)Order.asc)) : Collections.unmodifiableList(this.comparators);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.comparators);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        for (int i = 0; i < this.comparators.size(); ++i) {
            result ^= this.comparators.get(i).hashCode() * (i + 1);
        }
        return result;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.BULK, TraverserRequirement.OBJECT);
    }

    public List<Traversal.Admin<S, C>> getLocalChildren() {
        return this.comparators.stream().map(Pair::getValue0).collect(Collectors.toList());
    }

    @Override
    public OrderGlobalStep<S, C> clone() {
        OrderGlobalStep clone = (OrderGlobalStep)super.clone();
        clone.comparators = new ArrayList<Pair<Traversal.Admin<S, C>, Comparator<C>>>();
        for (Pair<Traversal.Admin<S, C>, Comparator<C>> comparator : this.comparators) {
            clone.comparators.add(new Pair(((Traversal.Admin)comparator.getValue0()).clone(), comparator.getValue1()));
        }
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.comparators.stream().map(Pair::getValue0).forEach(x$0 -> TraversalParent.super.integrateChild((Traversal.Admin<?, ?>)x$0));
    }

    @Override
    public MemoryComputeKey<TraverserSet<S>> getMemoryComputeKey() {
        if (null == this.multiComparator) {
            this.multiComparator = this.createMultiComparator();
        }
        return MemoryComputeKey.of(this.getId(), new OrderBiOperator(this.limit, this.multiComparator, this.random), false, true);
    }

    private final ProjectedTraverser<S, Object> createProjectedTraverser(Traverser.Admin<S> traverser) {
        ArrayList projections = new ArrayList(this.comparators.size());
        for (Pair<Traversal.Admin<S, C>, Comparator<C>> pair : this.comparators) {
            projections.add(TraversalUtil.apply(traverser, (Traversal.Admin)pair.getValue0()));
        }
        return new ProjectedTraverser(traverser, projections);
    }

    private final MultiComparator<C> createMultiComparator() {
        ArrayList list = new ArrayList(this.comparators.size());
        for (Pair<Traversal.Admin<S, C>, Comparator<C>> pair : this.comparators) {
            list.add(pair.getValue1());
        }
        return new MultiComparator(list);
    }

    public static final class OrderBiOperator<S>
    implements BinaryOperator<TraverserSet<S>>,
    Serializable {
        private long limit;
        private MultiComparator comparator;
        private Random random;

        private OrderBiOperator() {
        }

        public OrderBiOperator(long limit, MultiComparator multiComparator, Random random) {
            this.limit = limit;
            this.comparator = multiComparator;
            this.random = random;
        }

        @Override
        public TraverserSet<S> apply(TraverserSet<S> setA, TraverserSet<S> setB) {
            setA.addAll(setB);
            if (this.limit != -1L && setA.bulkSize() > this.limit) {
                if (this.comparator.isShuffle()) {
                    setA.shuffle(this.random);
                } else {
                    setA.sort(this.comparator);
                }
                long counter = 0L;
                Iterator<Traverser.Admin<S>> traversers = setA.iterator();
                while (traversers.hasNext()) {
                    Traverser.Admin<S> traverser = traversers.next();
                    if (counter > this.limit) {
                        traversers.remove();
                    }
                    counter += traverser.bulk();
                }
            }
            return setA;
        }
    }
}

