/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.segmenter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.lionsoul.jcseg.IWord;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.segmenter.Segmenter;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;
import org.lionsoul.jcseg.segmenter.Word;
import org.lionsoul.jcseg.util.IStringBuffer;

public class MostSeg
extends Segmenter {
    public MostSeg(SegmenterConfig config, ADictionary dic) {
        super(config, dic);
        config.setKeepEnSecOriginalWord(true);
    }

    @Override
    protected IWord getNextCJKWord(int c, int pos) throws IOException {
        String key = null;
        char[] chars = this.nextCJKSentence(c);
        int ignidx = 0;
        boolean mnum = false;
        IWord word = null;
        ArrayList<IWord> mList = new ArrayList<IWord>(8);
        for (int cjkidx = 0; cjkidx < chars.length; ++cjkidx) {
            String temp;
            String sstr = String.valueOf(chars[cjkidx]);
            if (this.dic.match(0, sstr)) {
                IWord sWord = this.dic.get(0, sstr).clone();
                sWord.setPosition(pos + cjkidx);
                mList.add(sWord);
            }
            mnum = false;
            this.isb.clear().append(chars[cjkidx]);
            for (int j = 1; j < this.config.MAX_LENGTH && cjkidx + j < chars.length; ++j) {
                this.isb.append(chars[cjkidx + j]);
                key = this.isb.toString();
                if (!this.dic.match(0, key)) continue;
                mnum = true;
                ignidx = Math.max(ignidx, cjkidx + j);
                word = this.dic.get(0, key).clone();
                word.setPosition(pos + cjkidx);
                mList.add(word);
            }
            if (mnum || cjkidx != 0 && cjkidx <= ignidx || this.dic.match(0, temp = String.valueOf(chars[cjkidx]))) continue;
            word = new Word(temp, 17);
            word.setPartSpeech(IWord.UNRECOGNIZE);
            word.setPosition(pos + cjkidx);
            mList.add(word);
        }
        for (IWord w : mList) {
            key = w.getValue();
            if (this.config.CLEAR_STOPWORD && this.dic.match(7, key)) continue;
            this.wordPool.add(w);
            this.appendCJKWordFeatures(w);
        }
        mList.clear();
        mList = null;
        return this.wordPool.size() == 0 ? null : (IWord)this.wordPool.remove();
    }

    @Override
    protected boolean enSecondSegFilter(IWord w) {
        return true;
    }

    @Override
    protected LinkedList<IWord> enWordSeg(IWord w, LinkedList<IWord> wList) {
        int pos = w.getPosition();
        int len = w.getValue().length();
        IWord tw = null;
        String str = null;
        int ignidx = 0;
        boolean mnum = false;
        boolean ignore = false;
        wList.add(w);
        IStringBuffer sb = new IStringBuffer(this.config.EN_MAX_LEN);
        char[] chars = w.getValue().toCharArray();
        for (int curidx = 0; curidx < chars.length; ++curidx) {
            String temp;
            str = String.valueOf(chars[curidx]);
            boolean bl = ignore = curidx == 0 && str.length() == len;
            if (!ignore && this.dic.match(0, str)) {
                tw = this.dic.get(0, str).clone();
                tw.setPosition(pos + curidx);
                wList.add(tw);
            }
            sb.clear().append(chars[curidx]);
            for (int j = 1; j < this.config.EN_MAX_LEN && curidx + j < chars.length; ++j) {
                sb.append(chars[curidx + j]);
                str = sb.toString();
                if (curidx == 0 && str.length() == len || !this.dic.match(0, str)) continue;
                mnum = true;
                ignidx = Math.max(ignidx, curidx + j);
                tw = this.dic.get(0, str).clone();
                tw.setPosition(pos + curidx);
                wList.add(tw);
            }
            if (ignore || mnum || curidx != 0 && curidx <= ignidx || this.dic.match(0, temp = String.valueOf(chars[curidx]))) continue;
            tw = new Word(temp, 17);
            tw.setPartSpeech(IWord.UNRECOGNIZE);
            tw.setPosition(pos + curidx);
            wList.add(tw);
        }
        sb.clear();
        return wList;
    }
}

