/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.query.serializer;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.serializer.AbstractSerializerAdapter;
import org.apache.hugegraph.type.define.Directions;

public class QueryAdapter
extends AbstractSerializerAdapter<Condition> {
    static ImmutableMap<String, Type> cls = ImmutableMap.builder().put((Object)"N", Condition.Not.class).put((Object)"A", Condition.And.class).put((Object)"O", Condition.Or.class).put((Object)"S", Condition.SyspropRelation.class).put((Object)"U", Condition.UserpropRelation.class).build();

    static boolean isPrimitive(Class clz) {
        try {
            return clz == Date.class || ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Map<String, Type> validType() {
        return cls;
    }

    @Override
    public Condition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object;
        Condition condition = (Condition)super.deserialize(json, typeOfT, context);
        if (condition instanceof Condition.Relation && (object = json.getAsJsonObject()).has("el")) {
            JsonElement elElement = object.get("el");
            JsonElement valueElement = elElement.getAsJsonObject().get("value");
            if (valueElement.isJsonObject()) {
                String cls = valueElement.getAsJsonObject().get("cls").getAsString();
                try {
                    Class<?> actualClass = Class.forName(cls);
                    Object obj = context.deserialize(valueElement, actualClass);
                    ((Condition.Relation)condition).value(obj);
                }
                catch (ClassNotFoundException e) {
                    throw new JsonParseException(e.getMessage());
                }
            } else if (elElement.getAsJsonObject().has("valuecls")) {
                if (valueElement.isJsonArray()) {
                    String cls = elElement.getAsJsonObject().get("valuecls").getAsString();
                    try {
                        Class<?> actualClass = Class.forName(cls);
                        Type type = TypeToken.getParameterized(ArrayList.class, (Type[])new Type[]{actualClass}).getType();
                        Object value = context.deserialize(valueElement, type);
                        ((Condition.Relation)condition).value(value);
                    }
                    catch (ClassNotFoundException e) {
                        throw new JsonParseException(e.getMessage());
                    }
                } else {
                    String cls = elElement.getAsJsonObject().get("valuecls").getAsString();
                    try {
                        Class<?> actualClass = Class.forName(cls);
                        Object obj = context.deserialize(valueElement, actualClass);
                        ((Condition.Relation)condition).value(obj);
                    }
                    catch (ClassNotFoundException e) {
                        throw new JsonParseException(e.getMessage());
                    }
                }
            } else if (valueElement.isJsonPrimitive() && valueElement.getAsJsonPrimitive().isString()) {
                switch ((String)((Condition.Relation)condition).value()) {
                    case "OUT": {
                        ((Condition.Relation)condition).value(Directions.OUT);
                        break;
                    }
                    case "IN": {
                        ((Condition.Relation)condition).value(Directions.IN);
                        break;
                    }
                }
            }
        }
        return condition;
    }

    @Override
    public JsonElement serialize(Condition src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement result = super.serialize(src, typeOfSrc, context);
        if (src instanceof Condition.Relation) {
            JsonObject object = result.getAsJsonObject();
            JsonElement valueElement = object.get("el").getAsJsonObject().get("value");
            if (valueElement.isJsonObject()) {
                valueElement.getAsJsonObject().add("cls", (JsonElement)new JsonPrimitive(((Condition.Relation)src).value().getClass().getName()));
            } else if (QueryAdapter.isPrimitive(((Condition.Relation)src).value().getClass())) {
                object.get("el").getAsJsonObject().add("valuecls", (JsonElement)new JsonPrimitive(((Condition.Relation)src).value().getClass().getName()));
            } else if (valueElement.isJsonArray() && ((Condition.Relation)src).value() instanceof List) {
                String valueCls = ((List)((Condition.Relation)src).value()).get(0).getClass().getName();
                object.get("el").getAsJsonObject().add("valuecls", (JsonElement)new JsonPrimitive(valueCls));
            }
        }
        return result;
    }
}

