/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.cent;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.cent.AbstractCentAlgorithm;
import org.apache.hugegraph.type.define.Directions;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class ClosenessCentralityAlgorithm
extends AbstractCentAlgorithm {
    public static final long DEFAULT_DEGREE = 100L;
    public static final long DEFAULT_SAMPLE = 1L;

    @Override
    public String name() {
        return "closeness_centrality";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        ClosenessCentralityAlgorithm.depth(parameters);
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        try (Traverser traverser = new Traverser(job);){
            Object object = traverser.closenessCentrality(ClosenessCentralityAlgorithm.direction(parameters), ClosenessCentralityAlgorithm.edgeLabel(parameters), ClosenessCentralityAlgorithm.depth(parameters), ClosenessCentralityAlgorithm.degree(parameters), ClosenessCentralityAlgorithm.sample(parameters), ClosenessCentralityAlgorithm.sourceLabel(parameters), ClosenessCentralityAlgorithm.sourceSample(parameters), ClosenessCentralityAlgorithm.sourceCLabel(parameters), ClosenessCentralityAlgorithm.top(parameters));
            return object;
        }
    }

    private static class Traverser
    extends AbstractCentAlgorithm.Traverser {
        public Traverser(UserJob<Object> job) {
            super(job);
        }

        public Object closenessCentrality(Directions direction, String label, int depth, long degree, long sample, String sourceLabel, long sourceSample, String sourceCLabel, long topN) {
            assert (depth > 0);
            assert (degree > 0L || degree == -1L);
            assert (topN >= 0L || topN == -1L);
            GraphTraversal t = this.constructSource(sourceLabel, sourceSample, sourceCLabel);
            t = this.constructPath(t, direction, label, degree, sample, sourceLabel, sourceCLabel);
            t = t.emit().until((Traversal)__.loops().is(P.gte((Object)depth)));
            t = this.filterNonShortestPath(t, true);
            GraphTraversal tg = t.group().by((Traversal)__.select((Pop)Pop.first, (String)"v").id()).by((Traversal)__.select((Pop)Pop.all, (String)"v").count(Scope.local).math("_-1").sack((BiFunction)Operator.div).sack().sum());
            GraphTraversal<Vertex, ?> tLimit = this.topN(tg, topN);
            return this.execute(tLimit, () -> tLimit.next());
        }
    }
}

