/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.computer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hugegraph.job.computer.AbstractComputer;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.ParameterUtil;

public class PageRankComputer
extends AbstractComputer {
    public static final String PAGE_RANK = "page_rank";
    public static final String ALPHA = "alpha";
    public static final double DEFAULT_ALPHA = 0.15;

    @Override
    public String name() {
        return PAGE_RANK;
    }

    @Override
    public String category() {
        return "rank";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        PageRankComputer.maxSteps(parameters);
        PageRankComputer.alpha(parameters);
        PageRankComputer.precision(parameters);
    }

    @Override
    protected Map<String, Object> checkAndCollectParameters(Map<String, Object> parameters) {
        return ImmutableMap.of((Object)"max_steps", (Object)PageRankComputer.maxSteps(parameters), (Object)ALPHA, (Object)PageRankComputer.alpha(parameters), (Object)"precision", (Object)PageRankComputer.precision(parameters));
    }

    private static double alpha(Map<String, Object> parameters) {
        if (!parameters.containsKey(ALPHA)) {
            return 0.15;
        }
        double alpha = ParameterUtil.parameterDouble(parameters, ALPHA);
        E.checkArgument((alpha > 0.0 && alpha < 1.0 ? 1 : 0) != 0, (String)"The value of %s must be (0, 1), but got %s", (Object[])new Object[]{ALPHA, alpha});
        return alpha;
    }
}

