/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.meta;

import com.google.common.base.Strings;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.watch.WatchEvent;
import io.etcd.jetcd.watch.WatchResponse;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.meta.MetaDriver;
import org.apache.hugegraph.meta.lock.EtcdDistributedLock;
import org.apache.hugegraph.meta.lock.LockResult;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.collection.CollectionFactory;

public class EtcdMetaDriver
implements MetaDriver {
    private final Client client;
    private final EtcdDistributedLock lock;

    public EtcdMetaDriver(String trustFile, String clientCertFile, String clientKeyFile, Object ... endpoints) {
        ClientBuilder builder = this.etcdMetaDriverBuilder(endpoints);
        SslContext sslContext = EtcdMetaDriver.openSslContext(trustFile, clientCertFile, clientKeyFile);
        this.client = builder.sslContext(sslContext).build();
        this.lock = EtcdDistributedLock.getInstance(this.client);
    }

    public EtcdMetaDriver(Object ... endpoints) {
        ClientBuilder builder = this.etcdMetaDriverBuilder(endpoints);
        this.client = builder.build();
        this.lock = EtcdDistributedLock.getInstance(this.client);
    }

    private static ByteSequence toByteSequence(String content) {
        return ByteSequence.from((byte[])content.getBytes());
    }

    private static boolean isEtcdPut(WatchEvent event) {
        return event.getEventType() == WatchEvent.EventType.PUT;
    }

    public static SslContext openSslContext(String trustFile, String clientCertFile, String clientKeyFile) {
        SslContext ssl;
        try {
            File trustManagerFile = FileUtils.getFile((String[])new String[]{trustFile});
            File keyCertChainFile = FileUtils.getFile((String[])new String[]{clientCertFile});
            File KeyFile = FileUtils.getFile((String[])new String[]{clientKeyFile});
            ApplicationProtocolConfig alpn = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"});
            ssl = SslContextBuilder.forClient().applicationProtocolConfig(alpn).sslProvider(SslProvider.OPENSSL).trustManager(trustManagerFile).keyManager(keyCertChainFile, KeyFile).build();
        }
        catch (Exception e) {
            throw new HugeException("Failed to open ssl context", e);
        }
        return ssl;
    }

    public ClientBuilder etcdMetaDriverBuilder(Object ... endpoints) {
        int length = endpoints.length;
        ClientBuilder builder = null;
        if (endpoints[0] instanceof List && endpoints.length == 1) {
            builder = Client.builder().endpoints(((List)endpoints[0]).toArray(new String[0]));
        } else if (endpoints[0] instanceof String) {
            for (int i = 1; i < length; ++i) {
                E.checkArgument((boolean)(endpoints[i] instanceof String), (String)"Inconsistent endpoint %s(%s) with %s(%s)", (Object[])new Object[]{endpoints[i], endpoints[i].getClass(), endpoints[0], endpoints[0].getClass()});
            }
            builder = Client.builder().endpoints((String[])endpoints);
        } else if (endpoints[0] instanceof URI) {
            for (int i = 1; i < length; ++i) {
                E.checkArgument((boolean)(endpoints[i] instanceof String), (String)"Invalid endpoint %s(%s)", (Object[])new Object[]{endpoints[i], endpoints[i].getClass(), endpoints[0], endpoints[0].getClass()});
            }
            builder = Client.builder().endpoints((URI[])endpoints);
        } else {
            E.checkArgument((boolean)false, (String)"Invalid endpoint %s(%s)", (Object[])new Object[]{endpoints[0], endpoints[0].getClass()});
        }
        return builder;
    }

    @Override
    public long keepAlive(String key, long leaseId) {
        try {
            LeaseKeepAliveResponse response = (LeaseKeepAliveResponse)this.client.getLeaseClient().keepAliveOnce(leaseId).get();
            return response.getID();
        }
        catch (InterruptedException | ExecutionException e) {
            return 0L;
        }
    }

    @Override
    public String get(String key) {
        List keyValues;
        KV kvClient = this.client.getKVClient();
        try {
            keyValues = ((GetResponse)kvClient.get(EtcdMetaDriver.toByteSequence(key)).get()).getKvs();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HugeException("Failed to get key '%s' from etcd", (Throwable)e, key);
        }
        if (!keyValues.isEmpty()) {
            return ((KeyValue)keyValues.get(0)).getValue().toString(Charset.defaultCharset());
        }
        return null;
    }

    @Override
    public void put(String key, String value) {
        KV kvClient = this.client.getKVClient();
        try {
            kvClient.put(EtcdMetaDriver.toByteSequence(key), EtcdMetaDriver.toByteSequence(value)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            try {
                kvClient.delete(EtcdMetaDriver.toByteSequence(key)).get();
            }
            catch (Throwable t) {
                throw new HugeException("Failed to put '%s:%s' to etcd", (Throwable)e, key, value);
            }
        }
    }

    @Override
    public void delete(String key) {
        KV kvClient = this.client.getKVClient();
        try {
            kvClient.delete(EtcdMetaDriver.toByteSequence(key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HugeException("Failed to delete key '%s' from etcd", (Throwable)e, key);
        }
    }

    @Override
    public void deleteWithPrefix(String prefix) {
        KV kvClient = this.client.getKVClient();
        try {
            DeleteOption option = DeleteOption.newBuilder().isPrefix(true).build();
            kvClient.delete(EtcdMetaDriver.toByteSequence(prefix), option);
        }
        catch (Throwable e) {
            throw new HugeException("Failed to delete prefix '%s' from etcd", e, prefix);
        }
    }

    @Override
    public Map<String, String> scanWithPrefix(String prefix) {
        GetResponse response;
        GetOption getOption = GetOption.newBuilder().isPrefix(true).build();
        try {
            response = (GetResponse)this.client.getKVClient().get(EtcdMetaDriver.toByteSequence(prefix), getOption).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HugeException("Failed to scan etcd with prefix '%s'", (Throwable)e, prefix);
        }
        int size = (int)response.getCount();
        Map<String, String> keyValues = CollectionFactory.newMap(CollectionType.JCF, size);
        for (KeyValue kv : response.getKvs()) {
            String key = kv.getKey().toString(Charset.defaultCharset());
            String value = kv.getValue().isEmpty() ? "" : kv.getValue().toString(Charset.defaultCharset());
            keyValues.put(key, value);
        }
        return keyValues;
    }

    @Override
    public <T> List<String> extractValuesFromResponse(T response) {
        ArrayList<String> values = new ArrayList<String>();
        E.checkArgument((boolean)(response instanceof WatchResponse), (String)"Invalid response type %s", (Object[])new Object[]{response.getClass()});
        for (WatchEvent event : ((WatchResponse)response).getEvents()) {
            if (!EtcdMetaDriver.isEtcdPut(event)) {
                return null;
            }
            String value = event.getKeyValue().getValue().toString(Charset.defaultCharset());
            values.add(value);
        }
        return values;
    }

    @Override
    public <T> Map<String, String> extractKVFromResponse(T response) {
        E.checkArgument((boolean)(response instanceof WatchResponse), (String)"Invalid response type %s", (Object[])new Object[]{response.getClass()});
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (WatchEvent event : ((WatchResponse)response).getEvents()) {
            if (!EtcdMetaDriver.isEtcdPut(event)) continue;
            String key = event.getKeyValue().getKey().toString(Charset.defaultCharset());
            String value = event.getKeyValue().getValue().toString(Charset.defaultCharset());
            if (Strings.isNullOrEmpty((String)key)) continue;
            resultMap.put(key, value);
        }
        return resultMap;
    }

    @Override
    public LockResult tryLock(String key, long ttl, long timeout) {
        return this.lock.tryLock(key, ttl, timeout);
    }

    @Override
    public boolean isLocked(String key) {
        try {
            long size = ((GetResponse)this.client.getKVClient().get(EtcdMetaDriver.toByteSequence(key)).get()).getCount();
            return size > 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HugeException("Failed to check is locked '%s'", (Throwable)e, key);
        }
    }

    @Override
    public void unlock(String key, LockResult lockResult) {
        this.lock.unLock(key, lockResult);
    }

    @Override
    public <T> void listen(String key, Consumer<T> consumer) {
        this.client.getWatchClient().watch(EtcdMetaDriver.toByteSequence(key), consumer);
    }

    @Override
    public <T> void listenPrefix(String prefix, Consumer<T> consumer) {
        ByteSequence sequence = EtcdMetaDriver.toByteSequence(prefix);
        WatchOption option = WatchOption.newBuilder().isPrefix(true).build();
        this.client.getWatchClient().watch(sequence, option, consumer);
    }
}

