/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.PathTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.traversal.algorithm.strategy.TraverseStrategy;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class CollectionPathsTraverser
extends HugeTraverser {
    public CollectionPathsTraverser(HugeGraph graph) {
        super(graph);
    }

    public WrappedPathCollection paths(Iterator<Vertex> sources, Iterator<Vertex> targets, EdgeStep step, int depth, boolean nearest, long capacity, long limit) {
        CollectionPathsTraverser.checkCapacity(capacity);
        CollectionPathsTraverser.checkLimit(limit);
        List<Id> sourceList = CollectionPathsTraverser.newList();
        while (sources.hasNext()) {
            sourceList.add(((HugeVertex)sources.next()).id());
        }
        int sourceSize = sourceList.size();
        E.checkState((sourceSize >= 1 && sourceSize <= 10 ? 1 : 0) != 0, (String)"The number of source vertices must in [1, %s], but got: %s", (Object[])new Object[]{10, sourceList.size()});
        List<Id> targetList = CollectionPathsTraverser.newList();
        while (targets.hasNext()) {
            targetList.add(((HugeVertex)targets.next()).id());
        }
        int targetSize = targetList.size();
        E.checkState((targetSize >= 1 && targetSize <= 10 ? 1 : 0) != 0, (String)"The number of target vertices must in [1, %s], but got: %s", (Object[])new Object[]{10, sourceList.size()});
        CollectionPathsTraverser.checkPositive(depth, "max depth");
        boolean concurrent = depth >= this.concurrentDepth();
        TraverseStrategy strategy = TraverseStrategy.create(concurrent, this.graph());
        Traverser traverser = nearest ? new NearestTraverser(this, strategy, sourceList, targetList, step, depth, capacity, limit, concurrent) : new Traverser(this, strategy, sourceList, targetList, step, depth, capacity, limit, concurrent);
        do {
            traverser.forward();
            if (traverser.finished()) {
                Set<HugeTraverser.Path> paths = traverser.paths();
                return new WrappedPathCollection(paths, traverser.edgeResults.getEdges(paths));
            }
            traverser.backward();
        } while (!traverser.finished());
        Set<HugeTraverser.Path> paths = traverser.paths();
        return new WrappedPathCollection(paths, traverser.edgeResults.getEdges(paths));
    }

    public static class WrappedPathCollection {
        private final Collection<HugeTraverser.Path> paths;
        private final Set<Edge> edges;

        public WrappedPathCollection(Collection<HugeTraverser.Path> paths, Set<Edge> edges) {
            this.paths = paths;
            this.edges = edges;
        }

        public Collection<HugeTraverser.Path> paths() {
            return this.paths;
        }

        public Set<Edge> edges() {
            return this.edges;
        }
    }

    private static class NearestTraverser
    extends Traverser {
        public NearestTraverser(HugeTraverser traverser, TraverseStrategy strategy, Collection<Id> sources, Collection<Id> targets, EdgeStep step, int depth, long capacity, long limit, boolean concurrent) {
            super(traverser, strategy, sources, targets, step, depth, capacity, limit, concurrent);
        }

        @Override
        protected void processOneForForward(Id sourceV, Id targetV) {
            HugeTraverser.Node node;
            List<Id> path;
            HugeTraverser.Node source = (HugeTraverser.Node)((List)this.sources.get(sourceV)).get(0);
            if (source.contains(targetV)) {
                return;
            }
            if (this.targetsAll.containsKey(targetV) && !(path = source.joinPath(node = (HugeTraverser.Node)((List)this.targetsAll.get(targetV)).get(0))).isEmpty()) {
                this.paths.add(new HugeTraverser.Path(targetV, path));
                if (this.reachLimit()) {
                    return;
                }
            }
            this.addNodeToNewVertices(targetV, new HugeTraverser.Node(targetV, source));
        }

        @Override
        protected void processOneForBackward(Id sourceV, Id targetV) {
            HugeTraverser.Node node;
            List<Id> path;
            HugeTraverser.Node sourcee = (HugeTraverser.Node)((List)this.targets.get(sourceV)).get(0);
            if (sourcee.contains(targetV)) {
                return;
            }
            if (this.sourcesAll.containsKey(targetV) && !(path = sourcee.joinPath(node = (HugeTraverser.Node)((List)this.sourcesAll.get(targetV)).get(0))).isEmpty()) {
                HugeTraverser.Path newPath = new HugeTraverser.Path(targetV, path);
                newPath.reverse();
                this.paths.add(newPath);
                if (this.reachLimit()) {
                    return;
                }
            }
            this.addNodeToNewVertices(targetV, new HugeTraverser.Node(targetV, sourcee));
        }

        @Override
        protected void reInitCurrentStepIfNeeded(EdgeStep step, boolean forward) {
            if (forward) {
                this.sources = this.newVertices;
                this.addNewVerticesToAll(this.sourcesAll);
            } else {
                this.targets = this.newVertices;
                this.addNewVerticesToAll(this.targetsAll);
            }
        }

        @Override
        public void addNodeToNewVertices(Id id, HugeTraverser.Node node) {
            this.newVertices.putIfAbsent(id, ImmutableList.of((Object)node));
        }

        @Override
        public void addNewVerticesToAll(Map<Id, List<HugeTraverser.Node>> targets) {
            for (Map.Entry entry : this.newVertices.entrySet()) {
                targets.putIfAbsent((Id)entry.getKey(), (List)entry.getValue());
            }
        }

        @Override
        protected int accessedNodes() {
            return this.sourcesAll.size() + this.targetsAll.size();
        }
    }

    private static class Traverser
    extends PathTraverser {
        protected final EdgeStep step;

        public Traverser(HugeTraverser traverser, TraverseStrategy strategy, Collection<Id> sources, Collection<Id> targets, EdgeStep step, int depth, long capacity, long limit, boolean concurrent) {
            super(traverser, strategy, sources, targets, capacity, limit, concurrent);
            this.step = step;
            this.totalSteps = depth;
        }

        @Override
        public EdgeStep nextStep(boolean forward) {
            return this.step;
        }

        @Override
        protected void processOneForForward(Id sourceV, Id targetV) {
            for (HugeTraverser.Node source : (List)this.sources.get(sourceV)) {
                if (source.contains(targetV)) continue;
                if (this.targetsAll.containsKey(targetV)) {
                    for (HugeTraverser.Node target : (List)this.targetsAll.get(targetV)) {
                        List<Id> path = source.joinPath(target);
                        if (path.isEmpty()) continue;
                        this.paths.add(new HugeTraverser.Path(targetV, path));
                        if (!this.reachLimit()) continue;
                        return;
                    }
                }
                this.addNodeToNewVertices(targetV, new HugeTraverser.Node(targetV, source));
            }
        }

        @Override
        protected void processOneForBackward(Id sourceV, Id targetV) {
            for (HugeTraverser.Node source : (List)this.targets.get(sourceV)) {
                if (source.contains(targetV)) continue;
                if (this.sourcesAll.containsKey(targetV)) {
                    for (HugeTraverser.Node target : (List)this.sourcesAll.get(targetV)) {
                        List<Id> path = source.joinPath(target);
                        if (path.isEmpty()) continue;
                        HugeTraverser.Path newPath = new HugeTraverser.Path(targetV, path);
                        newPath.reverse();
                        this.paths.add(newPath);
                        if (!this.reachLimit()) continue;
                        return;
                    }
                }
                this.addNodeToNewVertices(targetV, new HugeTraverser.Node(targetV, source));
            }
        }

        @Override
        protected void reInitCurrentStepIfNeeded(EdgeStep step, boolean forward) {
            if (forward) {
                this.sources = this.newVertices;
                this.addNewVerticesToAll(this.sourcesAll);
            } else {
                this.targets = this.newVertices;
                this.addNewVerticesToAll(this.targetsAll);
            }
        }
    }
}

