/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm.strategy;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.OltpTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.traversal.algorithm.strategy.TraverseStrategy;

public class SingleTraverseStrategy
extends OltpTraverser
implements TraverseStrategy {
    public SingleTraverseStrategy(HugeGraph graph) {
        super(graph);
    }

    @Override
    public void traverseOneLayer(Map<Id, List<HugeTraverser.Node>> vertices, EdgeStep step, BiConsumer<Id, EdgeStep> biConsumer) {
        for (Id id : vertices.keySet()) {
            biConsumer.accept(id, step);
        }
    }

    @Override
    public Map<Id, List<HugeTraverser.Node>> newMultiValueMap() {
        return SingleTraverseStrategy.newMultivalueMap();
    }

    @Override
    public Set<HugeTraverser.Path> newPathSet() {
        return new HugeTraverser.PathSet();
    }

    @Override
    public void addNode(Map<Id, List<HugeTraverser.Node>> vertices, Id id, HugeTraverser.Node node) {
        ((MultivaluedMap)vertices).add((Object)id, (Object)node);
    }

    @Override
    public void addNewVerticesToAll(Map<Id, List<HugeTraverser.Node>> newVertices, Map<Id, List<HugeTraverser.Node>> targets) {
        MultivaluedMap vertices = (MultivaluedMap)targets;
        for (Map.Entry<Id, List<HugeTraverser.Node>> entry : newVertices.entrySet()) {
            vertices.addAll((Object)entry.getKey(), entry.getValue());
        }
    }
}

