/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;

public final class KryoUtil {
    private static final ThreadLocal<Kryo> KRYOS = new ThreadLocal();

    public static Kryo kryo() {
        Kryo kryo = KRYOS.get();
        if (kryo != null) {
            return kryo;
        }
        kryo = new Kryo();
        KryoUtil.registerSerializers(kryo);
        KRYOS.set(kryo);
        return kryo;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] toKryo(Object value) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (Output output = new Output((OutputStream)bos, 256);){
                KryoUtil.kryo().writeObject(output, value);
                output.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new BackendException("Failed to serialize: %s", (Throwable)e, value);
        }
    }

    public static <T> T fromKryo(byte[] value, Class<T> clazz) {
        E.checkState((value != null ? 1 : 0) != 0, (String)"Kryo value can't be null for '%s'", (Object[])new Object[]{clazz.getSimpleName()});
        return (T)KryoUtil.kryo().readObject(new Input(value), clazz);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] toKryoWithType(Object value) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (Output output = new Output((OutputStream)bos, 256);){
                KryoUtil.kryo().writeClassAndObject(output, value);
                output.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new BackendException("Failed to serialize: %s", (Throwable)e, value);
        }
    }

    public static <T> T fromKryoWithType(byte[] value) {
        E.checkState((value != null ? 1 : 0) != 0, (String)"Kryo value can't be null for object", (Object[])new Object[0]);
        return (T)KryoUtil.kryo().readClassAndObject(new Input(value));
    }

    private static void registerSerializers(Kryo kryo) {
        kryo.addDefaultSerializer(UUID.class, (Serializer)new Serializer<UUID>(){

            public UUID read(Kryo kryo, Input input, Class<UUID> c) {
                return new UUID(input.readLong(), input.readLong());
            }

            public void write(Kryo kryo, Output output, UUID uuid) {
                output.writeLong(uuid.getMostSignificantBits());
                output.writeLong(uuid.getLeastSignificantBits());
            }
        });
    }
}

