/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.analysis;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apdplat.word.analysis.EditDistanceTextSimilarity;
import org.apdplat.word.analysis.Hit;
import org.apdplat.word.analysis.Hits;
import org.apdplat.word.analysis.Similarity;

public interface SimilarityRanker
extends Similarity {
    default public Hits rank(String string, List<String> list) {
        return this.rank(string, list, Integer.MAX_VALUE);
    }

    default public Hits rank(String string, List<String> list, int n) {
        Hits hits = new Hits(n > list.size() ? list.size() : n);
        list.parallelStream().map(string2 -> {
            double d = this.similarScore(string, (String)string2);
            Hit hit = new Hit();
            hit.setText((String)string2);
            hit.setScore(d);
            return hit;
        }).sorted().limit(n).collect(Collectors.toList()).forEach(hit -> hits.addHit((Hit)hit));
        return hits;
    }

    public static void main(String[] stringArray) throws Exception {
        EditDistanceTextSimilarity editDistanceTextSimilarity = new EditDistanceTextSimilarity();
        List<String> list = Files.readAllLines(Paths.get("src/test/resources/dic.txt", new String[0])).stream().map(string -> string.trim()).filter(string -> string.length() > 1).collect(Collectors.toList());
        System.out.println("\u5f00\u59cb\u8ba1\u7b97 " + list.size() + " \u53e5\u8bdd\u7684\u6587\u672c\u76f8\u4f3c\u5ea6");
        AtomicInteger atomicInteger = new AtomicInteger();
        list.forEach(string -> {
            AtomicInteger atomicInteger2 = new AtomicInteger();
            System.out.println("****************************************************************************************************");
            System.out.println(atomicInteger.incrementAndGet() + "\u3001\u6587\u672c " + string + " \u7684\u76f8\u4f3c\u5ea6\u6587\u672c\uff1a");
            editDistanceTextSimilarity.rank((String)string, list, 15).getHits().forEach(hit -> System.out.println("\t" + atomicInteger2.incrementAndGet() + "\u3001" + hit.getScore() + " " + hit.getText()));
            System.out.println("****************************************************************************************************");
        });
    }
}

