/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.recognition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apdplat.word.segmentation.PartOfSpeech;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.tagging.PartOfSpeechTagging;
import org.apdplat.word.util.AutoDetector;
import org.apdplat.word.util.ResourceLoader;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonName {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonName.class);
    private static final Set<String> SURNAME_1 = new HashSet<String>();
    private static final Set<String> SURNAME_2 = new HashSet<String>();
    private static final Map<String, Integer> POS_SEQ = new HashMap<String, Integer>();

    public static void reload() {
        AutoDetector.loadAndWatch(new ResourceLoader(){

            @Override
            public void clear() {
                SURNAME_1.clear();
                SURNAME_2.clear();
                POS_SEQ.clear();
            }

            @Override
            public void load(List<String> list) {
                LOGGER.info("\u521d\u59cb\u5316\u767e\u5bb6\u59d3");
                for (String string : list) {
                    if (string.length() == 1) {
                        SURNAME_1.add(string);
                        continue;
                    }
                    if (string.length() == 2) {
                        SURNAME_2.add(string);
                        continue;
                    }
                    if (string.startsWith("pos_seq=")) {
                        String[] stringArray = string.split("=");
                        POS_SEQ.put(stringArray[1].trim().replaceAll("\\s", " "), Integer.parseInt(stringArray[2]));
                        continue;
                    }
                    LOGGER.error("\u9519\u8bef\u7684\u59d3\uff1a" + string);
                }
                LOGGER.info("\u767e\u5bb6\u59d3\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5355\u59d3\u4e2a\u6570\uff1a" + SURNAME_1.size() + "\uff0c\u590d\u59d3\u4e2a\u6570\uff1a" + SURNAME_2.size());
            }

            @Override
            public void add(String string) {
                if (string.length() == 1) {
                    SURNAME_1.add(string);
                } else if (string.length() == 2) {
                    SURNAME_2.add(string);
                } else if (string.startsWith("pos_seq=")) {
                    String[] stringArray = string.split("=");
                    POS_SEQ.put(stringArray[1].trim().replaceAll("\\s", " "), Integer.parseInt(stringArray[2]));
                } else {
                    LOGGER.error("\u9519\u8bef\u7684\u59d3\uff1a" + string);
                }
            }

            @Override
            public void remove(String string) {
                if (string.length() == 1) {
                    SURNAME_1.remove(string);
                } else if (string.length() == 2) {
                    SURNAME_2.remove(string);
                } else if (string.startsWith("pos_seq=")) {
                    String[] stringArray = string.split("=");
                    POS_SEQ.remove(stringArray[1].trim().replaceAll("\\s", " "));
                } else {
                    LOGGER.error("\u9519\u8bef\u7684\u59d3\uff1a" + string);
                }
            }
        }, WordConfTools.get("surname.path", "classpath:surname.txt"));
    }

    public static List<String> getSurnames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(SURNAME_1);
        arrayList.addAll(SURNAME_2);
        Collections.sort(arrayList);
        return arrayList;
    }

    public static String getSurname(String string) {
        if (PersonName.is(string)) {
            if (PersonName.isSurname(string.substring(0, 2))) {
                return string.substring(0, 2);
            }
            if (PersonName.isSurname(string.substring(0, 1))) {
                return string.substring(0, 1);
            }
        }
        return "";
    }

    public static boolean isSurname(String string) {
        return SURNAME_1.contains(string) || SURNAME_2.contains(string);
    }

    public static boolean is(String string) {
        int n = string.length();
        if (n < 2) {
            return false;
        }
        if (n == 2) {
            return SURNAME_1.contains(string.substring(0, 1));
        }
        if (n == 3) {
            return SURNAME_1.contains(string.substring(0, 1)) || SURNAME_2.contains(string.substring(0, 2));
        }
        if (n == 4) {
            return SURNAME_2.contains(string.substring(0, 2));
        }
        return false;
    }

    public static List<Word> recognize(List<Word> list) {
        int n = list.size();
        if (n < 2) {
            return list;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u4eba\u540d\u8bc6\u522b\uff1a" + list);
        }
        ArrayList<List<Word>> arrayList = new ArrayList<List<Word>>();
        ArrayList<Word> arrayList2 = new ArrayList<Word>();
        for (int i = 0; i < n - 1; ++i) {
            String string = list.get(i).getText();
            if (PersonName.isSurname(string)) {
                arrayList2.addAll(PersonName.recognizePersonName(list.subList(i, list.size())));
                arrayList.add(arrayList2);
                arrayList2 = new ArrayList<Word>(list.subList(0, i + 1));
                continue;
            }
            arrayList2.add(new Word(string));
        }
        if (arrayList.isEmpty()) {
            return list;
        }
        if (arrayList.size() == 1) {
            return (List)arrayList.get(0);
        }
        return PersonName.selectBest(arrayList);
    }

    private static List<Word> selectBest(List<List<Word>> list2) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f00\u59cb\u4ece\u591a\u4e2a\u8bc6\u522b\u7ed3\u679c\u4e2d\u9009\u62e9\u4e00\u4e2a\u6700\u4f73\u7684\u7ed3\u679c:{}", list2);
        }
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        AtomicInteger atomicInteger = new AtomicInteger();
        list2.stream().forEach(list -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(atomicInteger.incrementAndGet() + "\u3001\u5f00\u59cb\u5904\u7406\uff1a" + list);
            }
            PartOfSpeechTagging.process(list);
            StringBuilder stringBuilder = new StringBuilder();
            list.forEach(word -> stringBuilder.append(word.getPartOfSpeech().getPos().charAt(0)).append(" "));
            String string = stringBuilder.toString();
            AtomicInteger atomicInteger2 = new AtomicInteger();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8bcd\u5e8f\u5217\uff1a{} \u7684\u8bcd\u6027\u5e8f\u5217\uff1a{}", list, (Object)string);
            }
            POS_SEQ.keySet().parallelStream().forEach(string2 -> {
                if (string.contains((CharSequence)string2)) {
                    int n = POS_SEQ.get(string2);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(string2 + "\u8bcd\u5e8f\u589e\u52a0\u5206\u503c\uff1a" + n);
                    }
                    atomicInteger2.addAndGet(n);
                }
            });
            atomicInteger2.addAndGet(-list.size());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u957f\u5ea6\u7684\u8d1f\u503c\u4e5f\u4f5c\u4e3a\u5206\u503c\uff1a" + -list.size());
                LOGGER.debug("\u8bc4\u5206\u7ed3\u679c\uff1a" + atomicInteger2.get());
            }
            concurrentHashMap.put(list, atomicInteger2.get());
        });
        List list3 = (List)concurrentHashMap.entrySet().parallelStream().sorted((entry, entry2) -> ((Integer)entry2.getValue()).compareTo((Integer)entry.getValue())).map(entry -> (List)entry.getKey()).collect(Collectors.toList()).get(0);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u9009\u62e9\u7ed3\u679c\uff1a" + list3);
        }
        return list3;
    }

    private static List<Word> recognizePersonName(List<Word> list) {
        int n = list.size();
        if (n < 2) {
            return list;
        }
        ArrayList<Word> arrayList = new ArrayList<Word>();
        for (int i = 0; i < n - 1; ++i) {
            String string = list.get(i + 1).getText();
            if (string.length() > 1) {
                arrayList.add(new Word(list.get(i).getText()));
                arrayList.add(new Word(list.get(i + 1).getText()));
                if (++i != n - 2) continue;
                arrayList.add(new Word(list.get(i + 1).getText()));
                continue;
            }
            String string2 = list.get(i).getText();
            if (PersonName.isSurname(string2)) {
                String string3;
                String string4 = "";
                if (i + 2 < n && list.get(i + 2).getText().length() == 1) {
                    string4 = list.get(i + 2).getText();
                }
                if (PersonName.is(string3 = string2 + string + string4)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("\u8bc6\u522b\u5230\u4eba\u540d\uff1a" + string3);
                    }
                    Word word = new Word(string3);
                    word.setPartOfSpeech(PartOfSpeech.valueOf("nr"));
                    arrayList.add(word);
                    ++i;
                    if (!"".equals(string4)) {
                        ++i;
                    }
                } else {
                    arrayList.add(new Word(string2));
                }
            } else {
                arrayList.add(new Word(string2));
            }
            if (i != n - 2) continue;
            arrayList.add(new Word(list.get(i + 1).getText()));
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        int n = 1;
        for (String string : SURNAME_1) {
            LOGGER.info(n++ + " : " + string);
        }
        for (String string : SURNAME_2) {
            LOGGER.info(n++ + " : " + string);
        }
        LOGGER.info("\u6768\u5c1a\u5ddd\uff1a" + PersonName.is("\u6768\u5c1a\u5ddd"));
        LOGGER.info("\u6b27\u9633\u98de\u71d5\uff1a" + PersonName.is("\u6b27\u9633\u98de\u71d5"));
        LOGGER.info("\u4ee4\u72d0\u51b2\uff1a" + PersonName.is("\u4ee4\u72d0\u51b2"));
        LOGGER.info("\u6768\u5c1a\u5ddd\u7231\u8bfb\u4e66\uff1a" + PersonName.is("\u6768\u5c1a\u5ddd\u7231\u8bfb\u4e66"));
        ArrayList<Word> arrayList = new ArrayList();
        arrayList.add(new Word("\u5feb"));
        arrayList.add(new Word("\u6765"));
        arrayList.add(new Word("\u770b"));
        arrayList.add(new Word("\u6768"));
        arrayList.add(new Word("\u5c1a"));
        arrayList.add(new Word("\u5ddd"));
        arrayList.add(new Word("\u8868\u6f14"));
        arrayList.add(new Word("\u9b54\u672f"));
        arrayList.add(new Word("\u4e86"));
        LOGGER.info(PersonName.recognize((List<Word>)arrayList).toString());
        arrayList = new ArrayList<Word>();
        arrayList.add(new Word("\u674e"));
        arrayList.add(new Word("\u4e16"));
        arrayList.add(new Word("\u660e"));
        arrayList.add(new Word("\u7684"));
        arrayList.add(new Word("\u662d\u4eea"));
        arrayList.add(new Word("\u6b27\u9633"));
        arrayList.add(new Word("\u98de"));
        arrayList.add(new Word("\u71d5"));
        arrayList.add(new Word("\u5176\u5b9e"));
        arrayList.add(new Word("\u5f88"));
        arrayList.add(new Word("\u5389\u5bb3"));
        arrayList.add(new Word("\u5440"));
        arrayList.add(new Word("\uff01"));
        arrayList.add(new Word("\u6bd4"));
        arrayList.add(new Word("\u516c\u5b59"));
        arrayList.add(new Word("\u9ec4"));
        arrayList.add(new Word("\u540e"));
        arrayList.add(new Word("\u725b"));
        LOGGER.info(PersonName.recognize(arrayList).toString());
        arrayList = new ArrayList();
        arrayList.add(new Word("\u53d1\u5c55"));
        arrayList.add(new Word("\u4e2d\u56fd"));
        arrayList.add(new Word("\u5bb6\u5154"));
        arrayList.add(new Word("\u7684"));
        arrayList.add(new Word("\u8ba1\u5212"));
        LOGGER.info(PersonName.recognize(arrayList).toString());
        arrayList = new ArrayList();
        arrayList.add(new Word("\u6768\u5c1a\u5ddd"));
        arrayList.add(new Word("\u597d"));
        LOGGER.info(PersonName.recognize(arrayList).toString());
        LOGGER.info(PersonName.getSurname("\u6b27\u9633\u950b"));
        LOGGER.info(PersonName.getSurname("\u674e\u9633\u950b"));
    }

    static {
        PersonName.reload();
    }
}

