/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.tagging;

import java.util.List;
import org.apdplat.word.WordSegmenter;
import org.apdplat.word.recognition.RecognitionTool;
import org.apdplat.word.segmentation.PartOfSpeech;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.util.AutoDetector;
import org.apdplat.word.util.GenericTrie;
import org.apdplat.word.util.ResourceLoader;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartOfSpeechTagging {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartOfSpeechTagging.class);
    private static final GenericTrie<String> GENERIC_TRIE = new GenericTrie();

    private PartOfSpeechTagging() {
    }

    public static void reload() {
        AutoDetector.loadAndWatch(new ResourceLoader(){

            @Override
            public void clear() {
                GENERIC_TRIE.clear();
            }

            @Override
            public void load(List<String> list) {
                LOGGER.info("\u521d\u59cb\u5316\u8bcd\u6027\u6807\u6ce8\u5668");
                int n = 0;
                for (String string : list) {
                    try {
                        String[] stringArray = string.split(":");
                        GENERIC_TRIE.put(stringArray[0], stringArray[1]);
                        ++n;
                    }
                    catch (Exception exception) {
                        LOGGER.error("\u9519\u8bef\u7684\u8bcd\u6027\u6570\u636e\uff1a" + string);
                    }
                }
                LOGGER.info("\u8bcd\u6027\u6807\u6ce8\u5668\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u8bcd\u6027\u6570\u636e\u6761\u6570\uff1a" + n);
            }

            @Override
            public void add(String string) {
                try {
                    String[] stringArray = string.split(":");
                    GENERIC_TRIE.put(stringArray[0], stringArray[1]);
                }
                catch (Exception exception) {
                    LOGGER.error("\u9519\u8bef\u7684\u8bcd\u6027\u6570\u636e\uff1a" + string);
                }
            }

            @Override
            public void remove(String string) {
                try {
                    String[] stringArray = string.split(":");
                    GENERIC_TRIE.remove(stringArray[0]);
                }
                catch (Exception exception) {
                    LOGGER.error("\u9519\u8bef\u7684\u8bcd\u6027\u6570\u636e\uff1a" + string);
                }
            }
        }, WordConfTools.get("part.of.speech.dic.path", "classpath:part_of_speech_dic.txt"));
    }

    public static void process(List<Word> list) {
        list.parallelStream().forEach(word -> {
            if (word.getPartOfSpeech() != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u5ffd\u7565\u5df2\u7ecf\u6807\u6ce8\u8fc7\u7684\u8bcd\uff1a{}", word);
                }
                return;
            }
            String string = word.getText();
            String string2 = GENERIC_TRIE.get(string);
            if (string2 == null) {
                if (RecognitionTool.isEnglish(string)) {
                    string2 = "w";
                }
                if (RecognitionTool.isNumber(string)) {
                    string2 = "m";
                }
                if (RecognitionTool.isChineseNumber(string)) {
                    string2 = "mh";
                }
                if (RecognitionTool.isFraction(string)) {
                    if (string.contains(".") || string.contains("\uff0e") || string.contains("\u00b7")) {
                        string2 = "mx";
                    }
                    if (string.contains("/") || string.contains("\uff0f")) {
                        string2 = "mf";
                    }
                }
                if (RecognitionTool.isQuantifier(string)) {
                    string2 = string.contains("\u2030") || string.contains("%") || string.contains("\uff05") ? "mf" : (string.contains("\u65f6") || string.contains("\u5206") || string.contains("\u79d2") ? "tq" : (string.contains("\u5e74") || string.contains("\u6708") || string.contains("\u65e5") || string.contains("\u5929") || string.contains("\u53f7") ? "tdq" : "mq"));
                }
            }
            word.setPartOfSpeech(PartOfSpeech.valueOf(string2));
        });
    }

    public static void main(String[] stringArray) {
        List<Word> list = WordSegmenter.segWithStopWords("\u6211\u7231\u4e2d\u56fd\uff0c\u6211\u7231\u6768\u5c1a\u5ddd");
        System.out.println("\u672a\u6807\u6ce8\u8bcd\u6027\uff1a" + list);
        PartOfSpeechTagging.process(list);
        System.out.println("\u6807\u6ce8\u8bcd\u6027\uff1a" + list);
    }

    static {
        PartOfSpeechTagging.reload();
    }
}

