/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordConfTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(WordConfTools.class);
    private static final Map<String, String> conf = new HashMap<String, String>();

    public static void set(String string, String string2) {
        conf.put(string, string2);
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2;
        String string3 = string2 = conf.get(string) == null ? Boolean.valueOf(bl).toString() : conf.get(string);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u914d\u7f6e\u9879\uff1a" + string + "=" + string2);
        }
        return string2.contains("true");
    }

    public static boolean getBoolean(String string) {
        return WordConfTools.getBoolean(string, false);
    }

    public static int getInt(String string, int n) {
        int n2;
        int n3 = n2 = conf.get(string) == null ? n : Integer.parseInt(conf.get(string).trim());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u914d\u7f6e\u9879\uff1a" + string + "=" + n2);
        }
        return n2;
    }

    public static int getInt(String string) {
        return WordConfTools.getInt(string, -1);
    }

    public static String get(String string, String string2) {
        String string3;
        String string4 = string3 = conf.get(string) == null ? string2 : conf.get(string);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u914d\u7f6e\u9879\uff1a" + string + "=" + string3);
        }
        return string3;
    }

    public static String get(String string) {
        String string2 = conf.get(string);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u914d\u7f6e\u9879\uff1a" + string + "=" + string2);
        }
        return string2;
    }

    public static void reload() {
        conf.clear();
        LOGGER.info("\u5f00\u59cb\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6");
        long l = System.currentTimeMillis();
        WordConfTools.loadConf("word.conf");
        WordConfTools.loadConf("word.local.conf");
        WordConfTools.checkSystemProperties();
        long l2 = System.currentTimeMillis() - l;
        LOGGER.info("\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5b8c\u6bd5\uff0c\u8017\u65f6" + l2 + " \u6beb\u79d2\uff0c\u914d\u7f6e\u9879\u6570\u76ee\uff1a" + conf.size());
        LOGGER.info("\u914d\u7f6e\u4fe1\u606f\uff1a");
        AtomicInteger atomicInteger = new AtomicInteger();
        conf.keySet().stream().sorted().forEach(string -> LOGGER.info(atomicInteger.incrementAndGet() + "\u3001" + string + "=" + conf.get(string)));
    }

    public static void forceOverride(String string) {
        File file = new File(string);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Object object = null;
            try {
                LOGGER.info("\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6 " + file.getAbsolutePath() + " \u5f3a\u5236\u8986\u76d6\u9ed8\u8ba4\u914d\u7f6e");
                WordConfTools.loadConf(fileInputStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fileInputStream != null) {
                    if (object != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)fileInputStream).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("\u5f3a\u5236\u8986\u76d6\u9ed8\u8ba4\u914d\u7f6e\u5931\u8d25\uff1a", (Throwable)exception);
        }
        int n = 1;
        for (String string2 : conf.keySet()) {
            LOGGER.info(n++ + "\u3001" + string2 + "=" + conf.get(string2));
        }
    }

    private static void loadConf(String string) {
        InputStream inputStream = WordConfTools.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            LOGGER.info("\u672a\u627e\u5230\u914d\u7f6e\u6587\u4ef6\uff1a" + string);
            return;
        }
        LOGGER.info("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\uff1a" + string);
        WordConfTools.loadConf(inputStream);
    }

    private static void loadConf(InputStream inputStream) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                if ("".equals(string = string.trim()) || string.startsWith("#")) continue;
                int n = string.indexOf("=");
                if (n == -1) {
                    LOGGER.error("\u9519\u8bef\u7684\u914d\u7f6e\uff1a" + string);
                    continue;
                }
                if (n > 0 && string.length() > n + 1) {
                    string2 = string.substring(0, n).trim();
                    String string3 = string.substring(n + 1, string.length()).trim();
                    conf.put(string2, string3);
                    continue;
                }
                if (n > 0 && string.length() == n + 1) {
                    string2 = string.substring(0, n).trim();
                    conf.put(string2, "");
                    continue;
                }
                LOGGER.error("\u9519\u8bef\u7684\u914d\u7f6e\uff1a" + string);
            }
        }
        catch (IOException iOException) {
            System.err.println("\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25:" + iOException.getMessage());
            throw new RuntimeException(iOException);
        }
    }

    private static void checkSystemProperties() {
        for (String string : conf.keySet()) {
            String string2 = System.getProperty(string);
            if (string2 == null) continue;
            conf.put(string, string2);
            LOGGER.info("\u7cfb\u7edf\u5c5e\u6027\u8986\u76d6\u9ed8\u8ba4\u914d\u7f6e\uff1a" + string + "=" + string2);
        }
    }

    public static void main(String[] stringArray) {
    }

    static {
        WordConfTools.reload();
    }
}

