/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.query;

import java.util.Comparator;
import java.util.List;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.structure.BaseElement;

public class BaseElementComparator
implements Comparator<BaseElement> {
    private final List<Id> ids;
    private boolean isAsc;

    public BaseElementComparator(List<Id> list, boolean isAsc) {
        this.ids = list;
        this.isAsc = isAsc;
    }

    public void reverseOrder() {
        this.isAsc = !this.isAsc;
    }

    @Override
    public int compare(BaseElement o1, BaseElement o2) {
        if (o1 == null || o2 == null) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            return (o1 == null ? -1 : 1) * (this.isAsc ? 1 : -1);
        }
        for (Id id : this.ids) {
            int ret = this.compareProperty((Comparable)o1.getPropertyValue(id), (Comparable)o2.getPropertyValue(id));
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    private int compareProperty(Comparable a, Comparable b) {
        if (a != null && b != null) {
            return a.compareTo(b) * (this.isAsc ? 1 : -1);
        }
        if (a == null && b == null) {
            return 0;
        }
        return (a == null ? -1 : 1) * (this.isAsc ? 1 : -1);
    }
}

