/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.query.concurrent;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class AtomicFloat
extends Number
implements Serializable,
Comparable<AtomicFloat> {
    private static final AtomicIntegerFieldUpdater<AtomicFloat> FIELD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AtomicFloat.class, "intBits");
    private volatile int intBits;

    public AtomicFloat() {
        this.intBits = Float.floatToIntBits(0.0f);
    }

    public AtomicFloat(float value) {
        this.intBits = Float.floatToRawIntBits(value);
    }

    public float get() {
        return Float.intBitsToFloat(this.intBits);
    }

    public final void set(float newValue) {
        this.intBits = Float.floatToIntBits(newValue);
    }

    public final float getAndSet(float newValue) {
        return this.getAndSetFloat(newValue);
    }

    public final float getAndAdd(float delta) {
        return this.getAndAddFloat(delta);
    }

    public final float addAndGet(float delta) {
        return this.getAndAddFloat(delta) + delta;
    }

    private float getAndAddFloat(float delta) {
        int newBits;
        int oldBits;
        while (!FIELD_UPDATER.compareAndSet(this, oldBits = this.intBits, newBits = Float.floatToIntBits(Float.intBitsToFloat(oldBits) + delta))) {
        }
        return Float.intBitsToFloat(oldBits);
    }

    private float getAndSetFloat(float newValue) {
        int newBits;
        int oldBits;
        while (!FIELD_UPDATER.compareAndSet(this, oldBits = this.intBits, newBits = Float.floatToIntBits(newValue))) {
        }
        return Float.intBitsToFloat(oldBits);
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    @Override
    public int compareTo(AtomicFloat o) {
        return Float.compare(this.get(), o.get());
    }

    public String toString() {
        return "AtomicFloat{intBits=" + this.intBits + ", value = " + this.get() + "}";
    }
}

