/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.filter;

import jakarta.ws.rs.NameBinding;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.AbstractMultivaluedMap;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.masterelection.GlobalMasterInfo;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.jersey.message.internal.HeaderUtils;
import org.slf4j.Logger;

public class RedirectFilter
implements ContainerRequestFilter {
    private static final Logger LOG = Log.logger(RedirectFilter.class);
    private static final String X_HG_REDIRECT = "x-hg-redirect";
    private static volatile Client client = null;
    @Context
    private IterableProvider<GraphManager> managerProvider;
    private static final Set<String> MUST_BE_NULL = new HashSet<String>();

    public void filter(ContainerRequestContext context) throws IOException {
        URI redirectUri;
        ServiceHandle handle = this.managerProvider.getHandle();
        E.checkState((handle != null ? 1 : 0) != 0, (String)"Context GraphManager is absent", (Object[])new Object[0]);
        GraphManager manager = (GraphManager)handle.getService();
        E.checkState((manager != null ? 1 : 0) != 0, (String)"Context GraphManager is absent", (Object[])new Object[0]);
        String redirectTag = context.getHeaderString(X_HG_REDIRECT);
        if (StringUtils.isNotEmpty((CharSequence)redirectTag)) {
            return;
        }
        GlobalMasterInfo globalNodeInfo = manager.globalNodeRoleInfo();
        if (globalNodeInfo == null || !globalNodeInfo.supportElection()) {
            return;
        }
        GlobalMasterInfo.NodeInfo masterInfo = globalNodeInfo.masterInfo();
        if (masterInfo == null || masterInfo.isMaster() || StringUtils.isEmpty((CharSequence)masterInfo.nodeUrl())) {
            return;
        }
        String url = masterInfo.nodeUrl();
        try {
            URIBuilder redirectURIBuilder = new URIBuilder(context.getUriInfo().getRequestUri());
            URI masterURI = URI.create(url);
            redirectURIBuilder.setHost(masterURI.getHost());
            redirectURIBuilder.setPort(masterURI.getPort());
            redirectURIBuilder.setScheme(masterURI.getScheme());
            redirectUri = redirectURIBuilder.build();
        }
        catch (URISyntaxException e) {
            LOG.error("Redirect request exception occurred", (Throwable)e);
            return;
        }
        this.initClientIfNeeded();
        Response response = this.forwardRequest(context, redirectUri);
        context.abortWith(response);
    }

    private Response forwardRequest(ContainerRequestContext requestContext, URI redirectUri) {
        MultivaluedMap headers = requestContext.getHeaders();
        AbstractMultivaluedMap newHeaders = HeaderUtils.createOutbound();
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    newHeaders.add((Object)((String)entry.getKey()), (Object)value);
                }
            }
        }
        newHeaders.add((Object)X_HG_REDIRECT, (Object)new Date().getTime());
        Invocation.Builder builder = client.target(redirectUri).request().headers((MultivaluedMap)newHeaders);
        Response response = MUST_BE_NULL.contains(requestContext.getMethod()) ? builder.method(requestContext.getMethod()) : builder.method(requestContext.getMethod(), Entity.json((Object)requestContext.getEntityStream()));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClientIfNeeded() {
        if (client != null) {
            return;
        }
        Class<RedirectFilter> clazz = RedirectFilter.class;
        synchronized (RedirectFilter.class) {
            if (client != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            client = ClientBuilder.newClient();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        MUST_BE_NULL.add("DELETE");
        MUST_BE_NULL.add("GET");
        MUST_BE_NULL.add("HEAD");
        MUST_BE_NULL.add("TRACE");
    }

    @NameBinding
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RedirectMasterRole {
    }
}

