/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.controller;

import com.alipay.sofa.jraft.entity.PeerId;
import java.util.ArrayList;
import org.apache.hugegraph.store.HgStoreEngine;
import org.apache.hugegraph.store.PartitionEngine;
import org.apache.hugegraph.store.meta.Partition;
import org.apache.hugegraph.store.meta.Store;
import org.apache.hugegraph.store.node.grpc.HgStoreNodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test"})
public class HgTestController {
    private static final Logger log = LoggerFactory.getLogger(HgTestController.class);
    @Autowired
    HgStoreNodeService nodeService;

    @GetMapping(value={"/leaderStore"}, produces={"application/json"})
    public Store testGetStoreInfo() {
        Store store = null;
        PartitionEngine engine = this.nodeService.getStoreEngine().getPartitionEngine(Integer.valueOf(0));
        for (Partition partition : engine.getPartitions().values()) {
            store = this.nodeService.getStoreEngine().getHgCmdClient().getStoreInfo(engine.getLeader().toString());
        }
        return store;
    }

    @GetMapping(value={"/raftRestart/{groupId}"}, produces={"application/json"})
    public String restartRaftNode(@PathVariable(value="groupId") int groupId) {
        PartitionEngine engine = this.nodeService.getStoreEngine().getPartitionEngine(Integer.valueOf(groupId));
        if (engine != null) {
            engine.restartRaftNode();
            return "OK";
        }
        return "partition engine not found";
    }

    @GetMapping(value={"/raftDelete/{groupId}"}, produces={"application/json"})
    public String deleteRaftNode(@PathVariable(value="groupId") int groupId) {
        ArrayList graphs = new ArrayList();
        PartitionEngine engine = this.nodeService.getStoreEngine().getPartitionEngine(Integer.valueOf(groupId));
        if (engine != null) {
            engine.getPartitions().forEach((k, v) -> graphs.add(v.getGraphName()));
            this.nodeService.getStoreEngine().destroyPartitionEngine(Integer.valueOf(groupId), graphs);
            return "OK";
        }
        return "Partition not found";
    }

    @GetMapping(value={"/gc"}, produces={"application/json"})
    public String doGc() {
        System.gc();
        return "gc OK!";
    }

    @GetMapping(value={"/flush"}, produces={"application/json"})
    public String doFlush() {
        this.nodeService.getStoreEngine().getBusinessHandler().flushAll();
        return "flush all!";
    }

    @GetMapping(value={"/close"}, produces={"application/json"})
    public String doCloseAll() {
        this.nodeService.getStoreEngine().getBusinessHandler().closeAll();
        return "close all!";
    }

    @GetMapping(value={"/snapshot"}, produces={"application/json"})
    public String doSnapshot() {
        this.nodeService.getStoreEngine().getPartitionEngines().forEach((k, v) -> v.snapshot());
        return "snapshot OK!";
    }

    @GetMapping(value={"/compact"}, produces={"application/json"})
    public String dbCompaction() {
        this.nodeService.getStoreEngine().getPartitionEngines().forEach((k, v) -> this.nodeService.getStoreEngine().getBusinessHandler().dbCompaction("", k.intValue()));
        return "snapshot OK!";
    }

    @GetMapping(value={"/pulse/reset"}, produces={"application/json"})
    public String resetPulse() {
        try {
            this.nodeService.getStoreEngine().getHeartbeatService().connectNewPulse();
            return "OK";
        }
        catch (Exception e) {
            log.error("pulse reset error: ", (Throwable)e);
            return e.getMessage();
        }
    }

    @GetMapping(value={"/transferLeaders"}, produces={"application/json"})
    public String transferLeaders() {
        try {
            this.nodeService.getStoreEngine().getLeaderPartition().forEach(engine -> {
                try {
                    engine.getRaftNode().transferLeadershipTo(PeerId.ANY_PEER);
                }
                catch (Exception e) {
                    log.error("transfer leader error: ", (Throwable)e);
                }
            });
            return "OK";
        }
        catch (Exception e) {
            log.error("transfer leaders error: ", (Throwable)e);
            return e.getMessage();
        }
    }

    @GetMapping(value={"/restart_raft"}, produces={"application/json"})
    public String restartRaft() {
        try {
            this.nodeService.getStoreEngine().getPartitionEngines().values().forEach(PartitionEngine::restartRaftNode);
            return "OK";
        }
        catch (Exception e) {
            log.error("restart raft error: ", (Throwable)e);
            return e.getMessage();
        }
    }

    @GetMapping(value={"/all_raft_start"}, produces={"application/json"})
    public String isRaftAllStarted() {
        try {
            HgStoreEngine engine = this.nodeService.getStoreEngine();
            long storeId = engine.getPartitionManager().getStore().getId();
            boolean flag = this.nodeService.getStoreEngine().getPdProvider().getPartitionsByStore(storeId).stream().mapToInt(Partition::getId).allMatch(i -> engine.getPartitionEngine(Integer.valueOf(i)) != null);
            return flag ? "OK" : "NO";
        }
        catch (Exception e) {
            log.error("raft status check error: ", (Throwable)e);
            return e.getMessage();
        }
    }
}

