/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.query;

import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hugegraph.backend.BackendColumn;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.serializer.BinaryElementSerializer;
import org.apache.hugegraph.store.business.MultiPartitionIterator;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.apache.hugegraph.store.grpc.query.QueryRequest;
import org.apache.hugegraph.store.grpc.query.QueryResponse;
import org.apache.hugegraph.store.node.grpc.query.AggregativeQueryObserver;
import org.apache.hugegraph.store.node.grpc.query.AggregativeQueryService;
import org.apache.hugegraph.store.node.grpc.query.QueryUtil;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResult;
import org.apache.hugegraph.store.node.grpc.query.model.QueryPlan;
import org.apache.hugegraph.store.node.grpc.query.stages.EarlyStopException;
import org.apache.hugegraph.store.query.KvSerializer;
import org.apache.hugegraph.store.util.MultiKv;
import org.apache.hugegraph.structure.BaseEdge;
import org.apache.hugegraph.structure.BaseElement;
import org.apache.hugegraph.structure.BaseVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregativeQueryObserver
implements StreamObserver<QueryRequest> {
    private static final Logger log = LoggerFactory.getLogger(AggregativeQueryObserver.class);
    private static final int RESULT_COUNT = 16;
    private final ExecutorService threadPool;
    private final long timeout;
    private final int batchSize;
    private final AtomicInteger consumeCount = new AtomicInteger(0);
    private final AtomicInteger sendCount = new AtomicInteger(0);
    private final AtomicBoolean clientCanceled = new AtomicBoolean(false);
    private final BinaryElementSerializer serializer = BinaryElementSerializer.getInstance();
    private final StreamObserver<QueryResponse> sender;
    private volatile ScanIterator iterator = null;
    private QueryPlan plan = null;
    private String queryId;

    public AggregativeQueryObserver(StreamObserver<QueryResponse> sender, ExecutorService threadPool, long timeout, int batchSize) {
        this.sender = sender;
        this.threadPool = threadPool;
        this.batchSize = batchSize;
        this.timeout = timeout;
    }

    public void onNext(QueryRequest request) {
        if (this.queryId == null) {
            log.debug("got request: {}", (Object)request);
            this.queryId = request.getQueryId();
        }
        if (this.iterator == null) {
            long current = System.nanoTime();
            this.iterator = QueryUtil.getIterator((QueryRequest)request);
            this.plan = QueryUtil.buildPlan((QueryRequest)request);
            this.threadPool.submit(() -> this.sendData());
            log.debug("query id: {}, init data cost: {} ms", (Object)this.queryId, (Object)((double)(System.nanoTime() - current) * 1.0 / 1000000.0));
        } else {
            this.consumeCount.incrementAndGet();
            log.debug("query id: {}, send feedback of {}", (Object)this.queryId, (Object)this.consumeCount.get());
        }
    }

    public void onError(Throwable t) {
        this.clientCanceled.set(true);
        log.error("AggregativeQueryService, query id: {},  got error", (Object)this.queryId, (Object)t);
    }

    public void onCompleted() {
        this.clientCanceled.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData() {
        try {
            long lastSend = System.currentTimeMillis();
            QueryResponse.Builder responseBuilder = this.getBuilder();
            Kv.Builder kvBuilder = this.getKvBuilder();
            while (!this.clientCanceled.get()) {
                QueryResponse.Builder builder;
                if (this.sendCount.get() - this.consumeCount.get() >= 16) {
                    if (System.currentTimeMillis() - lastSend > this.timeout) {
                        this.sender.onNext((Object)AggregativeQueryService.errorResponse((QueryResponse.Builder)this.getBuilder(), (String)this.queryId, (Throwable)new RuntimeException("sending-timeout, server closed")));
                        this.sender.onCompleted();
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        log.warn("send data is interrupted, {}", (Object)ignore.getMessage());
                    }
                }
                if ((builder = this.readBatchData(responseBuilder, kvBuilder)) == null) break;
                if (this.clientCanceled.get()) {
                    break;
                }
                try {
                    builder.setQueryId(this.queryId);
                    this.sender.onNext((Object)builder.build());
                    this.sendCount.incrementAndGet();
                    lastSend = System.currentTimeMillis();
                }
                catch (Exception e) {
                    log.error("send data got error: ", (Throwable)e);
                    break;
                }
                if (!builder.getIsFinished()) {
                    if (builder.getIsOk()) continue;
                }
                break;
            }
        }
        finally {
            this.plan.clear();
            this.iterator.close();
            this.sender.onCompleted();
        }
    }

    private QueryResponse.Builder readBatchData(QueryResponse.Builder builder, Kv.Builder kvBuilder) {
        ScanIterator itr = this.iterator;
        boolean empty = this.plan.isEmpty();
        boolean finish = false;
        boolean checkIterator = true;
        int count = 0;
        long current = System.nanoTime();
        try {
            if (!empty) {
                if (this.plan.onlyStopStage()) {
                    builder.setIsOk(true).setIsFinished(true);
                    return builder;
                }
                if (this.plan.hasIteratorResult()) {
                    checkIterator = false;
                    AtomicReference exception = new AtomicReference();
                    if (this.iterator instanceof MultiPartitionIterator) {
                        List iterators = ((MultiPartitionIterator)this.iterator).getIterators();
                        CountDownLatch latch = new CountDownLatch(iterators.size());
                        for (ScanIterator itr2 : iterators) {
                            this.threadPool.execute(() -> {
                                try {
                                    this.execute(itr2);
                                }
                                catch (Exception e) {
                                    exception.set(e);
                                }
                                finally {
                                    itr2.close();
                                    latch.countDown();
                                }
                            });
                        }
                        latch.await(this.timeout, TimeUnit.MILLISECONDS);
                        if (exception.get() != null) {
                            throw (Exception)exception.get();
                        }
                    } else {
                        this.execute(this.iterator);
                    }
                    try {
                        itr = (ScanIterator)this.plan.execute(PipelineResult.EMPTY);
                    }
                    catch (EarlyStopException iterators) {}
                } else {
                    itr = this.executePlainPipeline(this.iterator);
                }
            }
            builder.clear();
            ArrayList<Kv> batchResult = new ArrayList<Kv>();
            while (itr.hasNext() && !this.clientCanceled.get() && count < this.batchSize) {
                if (empty) {
                    RocksDBSession.BackendColumn column = (RocksDBSession.BackendColumn)this.iterator.next();
                    if (column == null) continue;
                    batchResult.add(kvBuilder.clear().setKey(ByteString.copyFrom((byte[])column.name)).setValue(column.value == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])column.value)).build());
                    ++count;
                    continue;
                }
                PipelineResult result = (PipelineResult)itr.next();
                if (result == null) continue;
                if (result == PipelineResult.EMPTY) {
                    finish = true;
                    break;
                }
                ++count;
                batchResult.add(this.toKv(kvBuilder, result));
            }
            builder.addAllData(batchResult);
        }
        catch (Exception e) {
            log.error("readBatchData got error: ", (Throwable)e);
            return builder.setIsOk(false).setIsFinished(false).setMessage("Store Server Error: " + Arrays.toString(e.getStackTrace()));
        }
        if (checkIterator) {
            finish = !itr.hasNext();
        }
        log.debug("query id: {}, finished batch, with size :{}, finish:{}, cost: {} ms", new Object[]{this.queryId, count, finish, (double)(System.nanoTime() - current) * 1.0 / 1000000.0});
        return builder.setIsOk(true).setIsFinished(finish);
    }

    public ScanIterator executePlainPipeline(ScanIterator itr) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void execute(ScanIterator itr) {
        long recordCount = 0L;
        long current = System.nanoTime();
        while (itr.hasNext() && !this.clientCanceled.get()) {
            try {
                ++recordCount;
                this.executePipeline(itr.next());
                if (System.nanoTime() - current <= this.timeout * 1000000L) continue;
                throw new RuntimeException("execution timeout");
            }
            catch (EarlyStopException ignore) {
                // empty catch block
                break;
            }
        }
        log.debug("query id: {}, read records: {}", (Object)this.queryId, (Object)recordCount);
    }

    private Object executePipeline(Object obj) throws EarlyStopException {
        PipelineResult input;
        if (obj instanceof RocksDBSession.BackendColumn) {
            input = new PipelineResult((RocksDBSession.BackendColumn)obj);
        } else if (obj instanceof BaseElement) {
            input = new PipelineResult((BaseElement)obj);
        } else {
            return null;
        }
        return this.plan.execute(input);
    }

    private QueryResponse.Builder getBuilder() {
        return QueryResponse.newBuilder();
    }

    private Kv.Builder getKvBuilder() {
        return Kv.newBuilder();
    }

    private Kv toKv(Kv.Builder builder, PipelineResult result) {
        builder.clear();
        switch (2.$SwitchMap$org$apache$hugegraph$store$node$grpc$query$model$PipelineResultType[result.getResultType().ordinal()]) {
            case 1: {
                RocksDBSession.BackendColumn column = result.getColumn();
                builder.setKey(ByteString.copyFrom((byte[])column.name));
                builder.setValue(column.value == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])column.value));
                break;
            }
            case 2: {
                MultiKv mkv = result.getKv();
                builder.setKey(ByteString.copyFrom((byte[])KvSerializer.toBytes((List)mkv.getKeys())));
                builder.setValue(ByteString.copyFrom((byte[])KvSerializer.toBytes((List)mkv.getValues())));
                break;
            }
            case 3: {
                BaseElement element = result.getElement();
                BackendColumn backendColumn = element instanceof BaseVertex ? this.serializer.writeVertex((BaseVertex)element) : this.serializer.writeEdge((BaseEdge)element);
                builder.setKey(ByteString.copyFrom((byte[])backendColumn.name));
                builder.setValue(ByteString.copyFrom((byte[])backendColumn.value));
                break;
            }
            default: {
                throw new RuntimeException("unsupported result type: " + String.valueOf(result.getResultType()));
            }
        }
        return builder.build();
    }
}

