/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.query.stages;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.store.node.grpc.query.QueryStage;
import org.apache.hugegraph.store.node.grpc.query.QueryUtil;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResult;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResultType;
import org.apache.hugegraph.store.util.MultiKv;
import org.apache.hugegraph.structure.BaseElement;

public class ExtractAggFieldStage
implements QueryStage {
    private List<Id> groupBys;
    private List<Id> fields;
    private boolean groupByElementSchemaId;
    private boolean isVertex;

    public void init(Object ... objects) {
        this.groupBys = QueryUtil.fromStringBytes((List)((List)objects[0]));
        this.fields = QueryUtil.fromStringBytes((List)((List)objects[1]));
        this.groupByElementSchemaId = (Boolean)objects[2];
        this.isVertex = (Boolean)objects[3];
    }

    public PipelineResult handle(PipelineResult result) {
        if (result == null) {
            return null;
        }
        if (this.groupByElementSchemaId && !result.isEmpty()) {
            return new PipelineResult(MultiKv.of(List.of(QueryUtil.getLabelId((RocksDBSession.BackendColumn)result.getColumn(), (boolean)this.isVertex)), List.of(Long.valueOf(1L))));
        }
        if (result.getResultType() == PipelineResultType.HG_ELEMENT) {
            BaseElement element = result.getElement();
            return new PipelineResult(MultiKv.of((List)this.getFields(this.groupBys, element), (List)this.getFields(this.fields, element)));
        }
        return result;
    }

    private List<Object> getFields(List<Id> ids, BaseElement element) {
        return ids.stream().map(id -> id == null ? null : element.getPropertyValue(id)).collect(Collectors.toList());
    }

    private List<Object> getSchemaId(BaseElement element) {
        return List.of(Long.valueOf(element.schemaLabel().id().asLong()));
    }

    public String getName() {
        return "EXTRACT_AGG_FIELD_STAGE";
    }

    public void close() {
        this.fields.clear();
        this.groupBys.clear();
    }
}

