/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.task.ttl;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.store.business.BusinessHandler;
import org.apache.hugegraph.store.business.BusinessHandlerImpl;
import org.apache.hugegraph.store.node.grpc.HgStoreNodeService;
import org.apache.hugegraph.store.node.task.ttl.DefaulTaskSubmitter;
import org.apache.hugegraph.store.node.task.ttl.RaftTaskSubmitter;
import org.apache.hugegraph.store.node.task.ttl.TaskSubmitter;

public class TaskInfo {
    String graph;
    boolean isRaft;
    transient BusinessHandlerImpl handler;
    long startTime;
    String[] tables;
    ConcurrentHashMap<String, AtomicLong> tableCounter;
    transient TaskSubmitter taskSubmitter;

    public TaskInfo(BusinessHandlerImpl handler, String graph, boolean isRaft, long startTime, String[] tables, HgStoreNodeService service) {
        this.handler = handler;
        this.graph = graph;
        this.isRaft = isRaft;
        this.tables = tables;
        this.startTime = startTime;
        this.tableCounter = new ConcurrentHashMap(tables.length);
        for (String table : tables) {
            this.tableCounter.put(table, new AtomicLong());
        }
        this.taskSubmitter = isRaft ? new RaftTaskSubmitter(service, (BusinessHandler)handler) : new DefaulTaskSubmitter(service, (BusinessHandler)handler);
    }

    public List<Integer> getPartitionIds() {
        return this.isRaft ? this.handler.getLeaderPartitionIds(this.graph) : this.handler.getPartitionIds(this.graph);
    }

    public String getGraph() {
        return this.graph;
    }

    public boolean isRaft() {
        return this.isRaft;
    }

    public BusinessHandlerImpl getHandler() {
        return this.handler;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String[] getTables() {
        return this.tables;
    }

    public ConcurrentHashMap<String, AtomicLong> getTableCounter() {
        return this.tableCounter;
    }

    public TaskSubmitter getTaskSubmitter() {
        return this.taskSubmitter;
    }

    public void setGraph(String graph) {
        this.graph = graph;
    }

    public void setRaft(boolean isRaft) {
        this.isRaft = isRaft;
    }

    public void setHandler(BusinessHandlerImpl handler) {
        this.handler = handler;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setTables(String[] tables) {
        this.tables = tables;
    }

    public void setTableCounter(ConcurrentHashMap<String, AtomicLong> tableCounter) {
        this.tableCounter = tableCounter;
    }

    public void setTaskSubmitter(TaskSubmitter taskSubmitter) {
        this.taskSubmitter = taskSubmitter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskInfo)) {
            return false;
        }
        TaskInfo other = (TaskInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isRaft() != other.isRaft()) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        String this$graph = this.getGraph();
        String other$graph = other.getGraph();
        if (this$graph == null ? other$graph != null : !this$graph.equals(other$graph)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTables(), other.getTables())) {
            return false;
        }
        ConcurrentHashMap this$tableCounter = this.getTableCounter();
        ConcurrentHashMap other$tableCounter = other.getTableCounter();
        return !(this$tableCounter == null ? other$tableCounter != null : !((Object)this$tableCounter).equals(other$tableCounter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRaft() ? 79 : 97);
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        String $graph = this.getGraph();
        result = result * 59 + ($graph == null ? 43 : $graph.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTables());
        ConcurrentHashMap $tableCounter = this.getTableCounter();
        result = result * 59 + ($tableCounter == null ? 43 : ((Object)$tableCounter).hashCode());
        return result;
    }

    public String toString() {
        return "TaskInfo(graph=" + this.getGraph() + ", isRaft=" + this.isRaft() + ", handler=" + String.valueOf(this.getHandler()) + ", startTime=" + this.getStartTime() + ", tables=" + Arrays.deepToString(this.getTables()) + ", tableCounter=" + String.valueOf(this.getTableCounter()) + ", taskSubmitter=" + String.valueOf(this.getTaskSubmitter()) + ")";
    }
}

