/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import org.apache.hugegraph.store.node.util.HgAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HgBufferProxy<T> {
    private static final Logger log = LoggerFactory.getLogger(HgBufferProxy.class);
    private final BlockingQueue<Supplier<T>> queue;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ReentrantLock lock = new ReentrantLock();
    private final Runnable applier;
    private final Executor executor;

    private HgBufferProxy(Executor executor, Runnable applier) {
        this.executor = executor;
        this.applier = applier;
        this.queue = new LinkedBlockingQueue();
    }

    public static HgBufferProxy of(Executor executor, Runnable applier) {
        HgAssert.isArgumentNotNull((Object)applier, (String)"applier");
        HgAssert.isArgumentNotNull((Object)executor, (String)"executor");
        return new HgBufferProxy(executor, applier);
    }

    public void send(T t) {
        if (t == null) {
            throw new IllegalArgumentException("the argument t is null");
        }
        if (this.closed.get()) {
            log.warn("the proxy has been closed");
            return;
        }
        this.lock.lock();
        try {
            this.queue.offer(() -> t);
        }
        finally {
            this.lock.unlock();
        }
    }

    @CheckForNull
    public T receive(int timeoutSeconds) {
        return (T)this.receive(timeoutSeconds, timeout -> {
            throw new RuntimeException("Timeout, max time: " + timeout + " seconds;");
        });
    }

    private void apply() {
        this.lock.lock();
        try {
            if (!this.closed.get()) {
                this.executor.execute(this.applier);
                Thread.yield();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public T receive(int timeoutSeconds, Consumer<Integer> timeoutCallBack) {
        Supplier s = null;
        if (this.closed.get()) {
            s = (Supplier)this.queue.poll();
            return s != null ? (T)s.get() : null;
        }
        if (this.queue.size() <= 1) {
            this.apply();
        }
        this.lock.lock();
        try {
            if (this.isClosed()) {
                s = (Supplier)this.queue.poll();
                T t = s != null ? (T)s.get() : null;
                return t;
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            s = (Supplier)this.queue.poll(timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            log.error("Failed to receive a item from chan. cause by: ", t);
            throw new RuntimeException(t);
        }
        if (s == null) {
            if (this.closed.get()) {
                s = (Supplier)this.queue.poll();
            } else {
                if (timeoutCallBack == null) {
                    throw new RuntimeException("Timeout, max time: " + timeoutSeconds + " seconds;");
                }
                timeoutCallBack.accept(timeoutSeconds);
            }
        }
        return s != null ? (T)s.get() : null;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void close() {
        if (this.closed.get()) {
            return;
        }
        this.lock.lock();
        this.closed.set(true);
        try {
            this.queue.offer(() -> null);
        }
        finally {
            this.lock.unlock();
        }
    }
}

