/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.summary;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ansj.app.keyword.KeyWordComputer;
import org.ansj.app.keyword.Keyword;
import org.ansj.app.summary.pojo.Summary;
import org.ansj.domain.Term;
import org.ansj.splitWord.analysis.NlpAnalysis;
import org.nlpcn.commons.lang.tire.SmartGetWord;
import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.util.MapCount;
import org.nlpcn.commons.lang.util.WordAlert;
import org.nlpcn.commons.lang.util.tuples.Triplet;

public class SummaryComputer {
    private static final Set<String> FILTER_SET = new HashSet<String>();
    private int len = 300;
    private boolean isSplitSummary = true;
    String title;
    String content;

    public SummaryComputer(String title, String content) {
        this.title = title;
        this.content = content;
    }

    public SummaryComputer(int len, String title, String content) {
        this.len = len;
        this.title = title;
        this.content = content;
    }

    public SummaryComputer(int len, boolean isSplitSummary, String title, String content) {
        this.len = len;
        this.title = title;
        this.content = content;
        this.isSplitSummary = isSplitSummary;
    }

    public Summary toSummary() {
        return this.toSummary(new ArrayList<Keyword>());
    }

    public Summary toSummary(String query) {
        List<Term> parse = NlpAnalysis.parse(query).getTerms();
        ArrayList<Keyword> keywords = new ArrayList<Keyword>();
        for (Term term : parse) {
            if (FILTER_SET.contains(term.natrue().natureStr)) continue;
            keywords.add(new Keyword(term.getName(), term.termNatures().allFreq, 1.0));
        }
        return this.toSummary(keywords);
    }

    public Summary toSummary(List<Keyword> keywords) {
        if (keywords == null) {
            keywords = new ArrayList<Keyword>();
        }
        if (keywords.size() == 0) {
            KeyWordComputer kc = new KeyWordComputer(10);
            keywords = kc.computeArticleTfidf(this.title, this.content);
        }
        return this.explan(keywords, this.content);
    }

    private Summary explan(List<Keyword> keywords, String content) {
        SmartForest sf = new SmartForest();
        for (Keyword keyword : keywords) {
            sf.add(keyword.getName(), (Object)keyword.getScore());
        }
        List<Sentence> sentences = this.toSentenceList(content.toCharArray());
        boolean flag = false;
        for (Sentence sentence : sentences) {
            flag = this.computeScore(sentence, (SmartForest<Double>)sf, false) || flag;
        }
        if (!flag) {
            if (content.length() <= this.len) {
                return new Summary(keywords, content);
            }
            return new Summary(keywords, content.substring(0, this.len));
        }
        double maxScore = 0.0;
        int maxIndex = 0;
        MapCount mc = new MapCount();
        for (int i = 0; i < sentences.size(); ++i) {
            double tempScore = sentences.get(i).score;
            int tempLength = sentences.get((int)i).value.length();
            mc.addAll((Map)sentences.get(i).mc.get());
            if (tempLength >= this.len) {
                if (maxScore <= (tempScore *= (double)mc.get().size())) {
                    maxScore = tempScore;
                    maxIndex = i;
                    continue;
                }
                mc.get().clear();
                continue;
            }
            for (int j = i + 1; j < sentences.size(); ++j) {
                tempScore += sentences.get(j).score;
                mc.addAll((Map)sentences.get(j).mc.get());
                if ((tempLength += sentences.get((int)j).value.length()) < this.len) continue;
                if (maxScore <= (tempScore *= (double)mc.get().size())) {
                    maxScore = tempScore;
                    maxIndex = i;
                }
                mc.get().clear();
                break;
            }
            if (tempLength >= this.len) continue;
            if (maxScore <= (tempScore *= (double)mc.get().size())) {
                maxScore = tempScore;
                maxIndex = i;
                break;
            }
            mc.get().clear();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = maxIndex; i < sentences.size(); ++i) {
            sb.append(sentences.get((int)i).value);
            if (sb.length() > this.len) break;
        }
        String summaryStr = sb.toString();
        if (this.isSplitSummary && sb.length() > this.len) {
            String str = sb.toString();
            Sentence sentence = new Sentence(str);
            this.computeScore(sentence, (SmartForest<Double>)sf, true);
            List<Triplet<Integer, Integer, Double>> offset = sentence.offset;
            ArrayList<Integer> beginArr = new ArrayList<Integer>();
            block5: for (int i = 0; i < str.length(); ++i) {
                for (Triplet<Integer, Integer, Double> t : offset) {
                    if (i <= (Integer)t.getValue0() || i >= (Integer)t.getValue1()) continue;
                    continue block5;
                }
                if (str.length() - i < this.len) break;
                beginArr.add(i);
            }
            maxIndex = 0;
            maxScore = -10000.0;
            for (Integer begin : beginArr) {
                double score = 0.0;
                for (Triplet<Integer, Integer, Double> t : offset) {
                    if (begin >= (Integer)t.getValue0() || begin + this.len <= (Integer)t.getValue1()) continue;
                    score += ((Double)t.getValue2()).doubleValue();
                }
                if (!(score > maxScore)) continue;
                maxIndex = begin;
                maxScore = score;
            }
            summaryStr = str.substring(maxIndex, Math.min(maxIndex + this.len + 1, str.length()));
        }
        return new Summary(keywords, summaryStr);
    }

    private boolean computeScore(Sentence sentence, SmartForest<Double> forest, boolean offset) {
        SmartGetWord sgw = new SmartGetWord(forest, sentence.value.toLowerCase());
        String name = null;
        boolean flag = false;
        while ((name = sgw.getFrontWords()) != null) {
            flag = true;
            sentence.updateScore(name, (Double)sgw.getParam());
            if (!offset) continue;
            Triplet triplet = new Triplet((Object)sgw.offe, (Object)(sgw.offe + name.length()), sgw.getParam());
            sentence.offset.add((Triplet<Integer, Integer, Double>)triplet);
        }
        if (sentence.score == 0.0) {
            sentence.score = (double)sentence.value.length() * -0.005;
        } else {
            Sentence sentence2 = sentence;
            sentence2.score = sentence2.score / Math.log(sentence.value.length() + 3);
        }
        return flag;
    }

    public List<Sentence> toSentenceList(char[] chars) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Sentence> sentences = new ArrayList<Sentence>();
        block5: for (int i = 0; i < chars.length; ++i) {
            if (sb.length() == 0 && (Character.isWhitespace(chars[i]) || chars[i] == '\u00a0')) continue;
            sb.append(chars[i]);
            switch (chars[i]) {
                case '.': {
                    if (i >= chars.length - 1 || WordAlert.isNumber((char)chars[i + 1])) continue block5;
                    this.insertIntoList(sb, sentences, false);
                    sb = new StringBuilder();
                    continue block5;
                }
                case '\t': 
                case '!': 
                case ',': 
                case ';': 
                case '?': 
                case '\u00a0': 
                case '\u3000': 
                case '\u3002': 
                case '\uff01': 
                case '\uff0c': 
                case '\uff1b': 
                case '\uff1f': {
                    this.insertIntoList(sb, sentences, false);
                    sb = new StringBuilder();
                    continue block5;
                }
                case '\n': 
                case '\r': {
                    this.insertIntoList(sb, sentences, true);
                    sb = new StringBuilder();
                }
            }
        }
        if (sb.length() > 0) {
            this.insertIntoList(sb, sentences, false);
        }
        return sentences;
    }

    private void insertIntoList(StringBuilder sb, List<Sentence> sentences, boolean space) {
        String content = sb.toString().trim();
        if (content.length() > 0) {
            sentences.add(new Sentence(content));
            if (space) {
                sentences.add(new Sentence(" "));
            }
        }
    }

    static {
        FILTER_SET.add("w");
        FILTER_SET.add("null");
    }

    public class Sentence {
        String value;
        private double score;
        List<Triplet<Integer, Integer, Double>> offset = new ArrayList<Triplet<Integer, Integer, Double>>();
        private MapCount<String> mc = new MapCount();

        public Sentence(String value) {
            this.value = value;
        }

        public void updateScore(String name, double score) {
            this.mc.add((Object)name);
            Double size = (Double)this.mc.get().get(name);
            this.score += score / size;
        }

        public String toString() {
            return this.value;
        }
    }
}

