/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.ansj.domain.Term;
import org.ansj.exception.LibraryException;
import org.ansj.library.StopLibrary;
import org.ansj.recognition.Recognition;
import org.ansj.recognition.impl.StopRecognition;
import org.ansj.splitWord.Analysis;
import org.ansj.splitWord.analysis.BaseAnalysis;
import org.ansj.splitWord.analysis.DicAnalysis;
import org.ansj.splitWord.analysis.IndexAnalysis;
import org.ansj.splitWord.analysis.NlpAnalysis;
import org.ansj.splitWord.analysis.ToAnalysis;
import org.nlpcn.commons.lang.util.CollectionUtil;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class Counter {
    private static final Log LOG = LogFactory.getLog(Counter.class);
    public static int SIZE = 100000;
    public static float FACTOR = 0.2f;

    public static Result count(File file, String encoding, Analysis analysis, int size, Recognition ... recognitions) {
        if (recognitions == null || recognitions.length < 1) {
            LOG.warn("Maybe you should add a `Recognition`");
        }
        if (encoding == null) {
            LOG.warn("encoding is null! Then use UTF-8 encoding!");
            encoding = "utf-8";
        }
        LOG.info("start to count[file=" + file + ", encoding=" + encoding + ", analysis=" + analysis.getClass().getName() + ", size=" + size + ", recognitions=" + Arrays.toString(recognitions) + "]");
        AtomicInteger ai = new AtomicInteger(0);
        long t = System.currentTimeMillis();
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        if (!file.isHidden() && file.exists() && file.canRead()) {
            try {
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    if (files != null) {
                        for (File f : files) {
                            if (!f.isFile() || f.isHidden() || !f.exists() || !f.canRead()) continue;
                            Counter.visitFile(ai, hm, f, encoding, analysis, recognitions);
                        }
                    }
                } else {
                    Counter.visitFile(ai, hm, file, encoding, analysis, recognitions);
                }
            }
            catch (Exception e) {
                throw new LibraryException(e);
            }
        }
        LOG.info("count " + ai.get() + " files, took " + (System.currentTimeMillis() - t) + "ms");
        List items = CollectionUtil.sortMapByValue(hm, (int)1);
        Result ret = new Result();
        ret.map = new HashMap<String, Integer>(size);
        for (Map.Entry entry : items) {
            if (ret.map.size() == size) break;
            ret.map.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return ret;
    }

    private static void visitFile(AtomicInteger ai, Map<String, Integer> hm, File f, String encoding, Analysis analysis, Recognition ... recognitions) throws IOException {
        String name = f.getName().trim().toLowerCase();
        if (name.endsWith(".txt") || name.endsWith(".dic")) {
            BufferedReader br = IOUtil.getReader((File)f, (String)encoding);
            Throwable throwable = null;
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    org.ansj.domain.Result result = analysis.parseStr(line);
                    if (recognitions != null) {
                        for (Recognition r : recognitions) {
                            if (r == null) continue;
                            result.recognition(r);
                        }
                    }
                    for (Term term : result) {
                        Counter.addTerm(term.getRealName(), hm);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        br.close();
                    }
                }
            }
            ai.incrementAndGet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("count file: " + f);
            }
        }
    }

    private static void addTerm(String term, Map<String, Integer> termMap) {
        if (termMap.containsKey(term)) {
            termMap.put(term, termMap.get(term) + 1);
            return;
        }
        int capacity = (int)((float)SIZE * (1.0f + FACTOR));
        if (capacity <= termMap.size()) {
            LOG.info("map size over capacity[" + capacity + "], then start to remove low frequency terms");
            List items = CollectionUtil.sortMapByValue(termMap, (int)1);
            for (Map.Entry item : items.subList(SIZE, items.size())) {
                termMap.remove(item.getKey());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("term[`" + (String)item.getKey() + "`-" + item.getValue() + "] removed");
            }
        }
        termMap.put(term, 1);
    }

    public static Result count(File file, Analysis analysis, int size) {
        return Counter.count(file, null, analysis, size);
    }

    public static Result count(File file, String encoding, Analysis analysis, int size) {
        return Counter.count(file, encoding, analysis, size, new Recognition[]{null});
    }

    public static Result count(File file, Analysis analysis) {
        return Counter.count(file, null, analysis);
    }

    public static Result count(File file, String encoding, Analysis analysis) {
        return Counter.count(file, encoding, analysis, SIZE, new Recognition[]{null});
    }

    public static Result count(File file) {
        return Counter.count(file, (String)null);
    }

    public static Result count(File file, String encoding) {
        return Counter.count(file, encoding, new ToAnalysis(), SIZE, new Recognition[]{null});
    }

    public static void main(String[] args) throws IOException {
        File f = null;
        Analysis analysis = new ToAnalysis();
        int size = SIZE;
        StopRecognition sr = null;
        String encoding = null;
        String output = null;
        block32: for (String arg : args) {
            String[] dim;
            if (!arg.startsWith("--") || !arg.contains("=") || (dim = arg.split("=")).length < 2) continue;
            String string = dim[0];
            int n = -1;
            switch (string.hashCode()) {
                case 1333303749: {
                    if (!string.equals("--path")) break;
                    n = 0;
                    break;
                }
                case 1726976755: {
                    if (!string.equals("--encoding")) break;
                    n = 1;
                    break;
                }
                case -1008691076: {
                    if (!string.equals("--analysis")) break;
                    n = 2;
                    break;
                }
                case 1333400993: {
                    if (!string.equals("--size")) break;
                    n = 3;
                    break;
                }
                case 1333411234: {
                    if (!string.equals("--stop")) break;
                    n = 4;
                    break;
                }
                case 1394501281: {
                    if (!string.equals("--output")) break;
                    n = 5;
                }
            }
            switch (n) {
                case 0: {
                    f = new File(dim[1]);
                    continue block32;
                }
                case 1: {
                    encoding = dim[1];
                    continue block32;
                }
                case 2: {
                    String string2 = dim[1];
                    int n2 = -1;
                    switch (string2.hashCode()) {
                        case 3016401: {
                            if (!string2.equals("base")) break;
                            n2 = 0;
                            break;
                        }
                        case -1816981518: {
                            if (!string2.equals("base_ansj")) break;
                            n2 = 1;
                            break;
                        }
                        case 100346066: {
                            if (!string2.equals("index")) break;
                            n2 = 2;
                            break;
                        }
                        case 746587793: {
                            if (!string2.equals("index_ansj")) break;
                            n2 = 3;
                            break;
                        }
                        case 99454: {
                            if (!string2.equals("dic")) break;
                            n2 = 4;
                            break;
                        }
                        case -189000091: {
                            if (!string2.equals("dic_ansj")) break;
                            n2 = 5;
                            break;
                        }
                        case 109170: {
                            if (!string2.equals("nlp")) break;
                            n2 = 6;
                            break;
                        }
                        case -1201043215: {
                            if (!string2.equals("nlp_ansj")) break;
                            n2 = 7;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 1: {
                            analysis = new BaseAnalysis();
                            continue block32;
                        }
                        case 2: 
                        case 3: {
                            analysis = new IndexAnalysis();
                            continue block32;
                        }
                        case 4: 
                        case 5: {
                            analysis = new DicAnalysis();
                            continue block32;
                        }
                        case 6: 
                        case 7: {
                            analysis = new NlpAnalysis();
                            continue block32;
                        }
                    }
                    LOG.warn("invalid analysis[" + dim[1] + "], then use `ToAnalysis`");
                    continue block32;
                }
                case 3: {
                    size = Integer.parseInt(dim[1]);
                    continue block32;
                }
                case 4: {
                    sr = StopLibrary.get(dim[1]);
                    continue block32;
                }
                case 5: {
                    output = dim[1];
                    continue block32;
                }
                default: {
                    LOG.warn("invalid argument[" + dim[0] + "], allowed arguments: --path, --encoding, --analysis, --size, --stop, --output");
                }
            }
        }
        if (f == null) {
            LOG.error("source path not found! You must add argument[--path]!");
            System.exit(1);
        }
        if (output == null) {
            LOG.warn("output file not found! You should add argument[--output]!");
        }
        Result result = Counter.count(f, encoding, analysis, size, sr);
        if (output != null) {
            result.writeToFile(output, "utf-8");
            LOG.info("results have been writen to file[" + output + "] in UTF-8 format");
        }
    }

    public static class Result
    implements Iterable<Map.Entry<String, Integer>> {
        public Map<String, Integer> map;

        public void writeToFile(String path, String encoding) throws IOException {
            IOUtil.writeMap(this.map, (String)path, (String)encoding);
        }

        @Override
        public Iterator<Map.Entry<String, Integer>> iterator() {
            return this.map.entrySet().iterator();
        }
    }
}

